/* -*- C -*-
 *
 * Program:	ximap
 * File:        compose.h -- Declarations and structures
 *                           for creating a compose window and sending 
 *                           a message.
 *
 * Author:	Kevin Brock
 *	        Symbolic Systems Resources Group
 *		Stanford University
 *              MSOB x241
 *		Stanford, CA 94305
 *		Internet: brock@CAMIS.Stanford.Edu
 *
 * Date:	07 September 1992
 *
 * Copyright 1992 by The Leland Stanford Junior University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * above copyright notices and this permission notice appear in supporting
 * documentation, and that the name of The Leland Stanford Junior University 
 * not be used in advertising or publicity pertaining to distribution of the 
 * software without specific, written prior permission.  This software is made 
 * available "as is", and
 * THE LELAND STANFORD JUNIOR UNIVERSITY DISCLAIMS ALL WARRANTIES, EXPRESS OR 
 * IMPLIED, WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN NO EVENT 
 * SHALL THE LELAND STANFORD JUNIOR UNIVERSITY BE LIABLE FOR ANY SPECIAL, INDIRECT 
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, 
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT (INCLUDING NEGLIGENCE) 
 * OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 *
 */
#ifndef __ximap_compose_h
#define __ximap_compose_h

typedef struct compose_window
{
  MAILHANDLE      *handle;
  struct _MailBox *ms;
  MessageNode     *message;
  int              msgno;
  char            *host;

  ENVELOPE        *env;     /* Envelope and body of the message being replied to, */
  BODY            *body;    /* if any...                                          */

  ENVELOPE        *newEnv;  /* Envelope and body of the message being composed.   */
  BODY            *newBody; /* These are where, e.g., parts are attached...       */

  PART            *attachments;

  unsigned int       status; 

  unsigned int       state; /* These are used to determine button sensitivity    */
  struct _StateList *states;

  Widget           shell;
  Widget           panes;
  Widget           from;         /* These are where the user puts the address...  */
  Widget           to;
  Widget           cc;
  Widget           bcc;
  Widget           subject;

  Widget           part_buttons;      /* Buttons for attaching body parts       */
  Widget           part_browser_form;
  Widget           part_browser;      /* Displays currently attached body parts */
      
  Widget           text;              /* Plain text being composed.             */

  Widget           lastFocus;         /* Tracks keyboard focus                  */

  READWINDOW       *rwin;             /* parent read window, if applicable */

  struct compose_window *next;
} ComposeWindow;

#define SUBJECTPREFIX "Subject: "
#define TOPREFIX   "To: "
#define FROMPREFIX "From: "
#define REPLYTOPREFIX "Reply To: "
#define CCPREFIX   "CC: "
#define BCCPREFIX  "BCC: "

/* These are button states which are specific to the compose window. */
#define NOATTACHEDPART ((unsigned long) 1 << 1)
#define NOREPLYTEXT    ((unsigned long) 1 << 2)

extern ComposeWindow* ComposeMessage();
extern void sendMessage();
extern void sendQuit();
extern void clearMessage();
extern void addComposeActions();

#endif /* __ximap_compose_h */
