/*
 * Copyright 1989 Massachusetts Institute of Technology
 * Copyright 1991 Leland Stanford Junior University
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN 
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */

/*
 * ListP.c - Private header file for the List widget
 *
 * This is the List widget, it is useful to display a list, without the
 * overhead of having a widget for each item in the list.  It allows 
 * the user to select an item in a list and notifies the application through
 * a callback function.
 *
 *	Original Created: 	8/13/88
 *	       By:		Chris D. Peterson
 *                              MIT X Consortium
 *
 *      Rewritten  by:  Kevin Brock
 *                      Symbolic Systems Resources Group
 *		        Knowledge Systems Laboratory
 *		        Departments of Computer Science and Medicine
 *		        Stanford University
 *		        Stanford, CA 94305
 *
 *        THIS WIDGET IS *NOT* COMPATIBLE WITH THE CURRENT Xaw List Widget.
 *        PROGRAMS DESIGNED TO USE THE ORIGINAL WIDGET MUST BE MODIFIED IN
 *        A NUMBER OF WAYS BEFORE THEY CAN USE THIS WIDGET.
 *
 */
#ifndef _XbListP_h
#define _XbListP_h

/***********************************************************************
 *
 * List Widget Private Data
 *
 ***********************************************************************/

#include <X11/Xaw/SimpleP.h>
#include "List.h"

#define XB_NO_HIGHLIGHT            XB_LIST_NONE
#define XB_OUT_OF_RANGE            -1
#define XB_OKAY                     0

/* New fields for the List widget class record */

typedef struct {
  int foo;
} XbListClassPart;

/* Full class record declaration */
typedef struct _XbListClassRec {
    CoreClassPart	core_class;
    SimpleClassPart	simple_class;
    XbListClassPart	list_class;
} XbListClassRec;

extern XbListClassRec XblistClassRec;

/* New fields for the List widget record */
typedef struct {
    /* resources */
    Pixel	foreground;
    Dimension	internal_width,
        	internal_height,
                column_space,
                row_space;
    int         default_cols;
    Boolean     force_cols,
                paste,
                vertical_cols;
    int         longest;
    int         nitems;		/* number of items in the list. */

    XFontStruct	*normalFont; 
    XFontStruct	*emphaticFont;

    XbListSelectionPtr list;
    int         num_selected;
    XtCallbackList  callback;
    XtCallbackList  double_click;
    long int    double_click_delay;

    /* private state */
    Dimension   col_width,	/* width of each column. */
                row_height;	/* height of each row. */

    int         nrows,		/* number of rows in the list. */
                ncols;		/* number of columns in the list. */

    GC		normgc,		/* a couple o' GC's. */
                boldgc,
                revboldgc,
                revgc;
    
    /* motion handling stuff */
    Boolean     inMoveSelect;
    Boolean     inExtend;
    int         origin;
    int         last;
    int         direction;
    Time        last_click;
    int         last_item_clicked;
} XbListPart;


/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _XbListRec {
    CorePart	core;
    SimplePart	simple;
    XbListPart	list;
} XbListRec;

#endif /* _XbListP_h */


