/***********************************************************
*
*
*  Author(s):       Kevin J. Brock
*                   Symbolic Systems Resources Group
*		    Knowledge Systems Laboratory
*		    Departments of Computer Science and Medicine
*		    Stanford University
*		    Stanford, CA 94305
*
*  Date:            28 March, 1991
*
*  Copyright () 1991 by the Leland Stanford Junior University
*  
*  "This program may be distributed without restriction for non-commercial
*  use. Any sale or use of this program or adaptations thereof for commercial
*  purposes is prohibited except under license from the Stanford Office of
*  Technology Licensing."
*
***********************************************************/
/* 
 *  private header for mailbox compound widget
 *
 */

#ifndef _XbBrowserP_h
#define _XbBrowserP_h

#include <X11/Xaw/ViewportP.h>
#include "Browser.h"

typedef struct {
    int empty;		/* For future needs. */
} XbBrowserClassPart;

typedef struct _XbBrowserMenuClassRec {
  CoreClassPart	          core_class;
  CompositeClassPart      composite_class;
  ConstraintClassPart     constraint_class;
  FormClassPart           form_class;
  ViewportClassPart       viewport_class;
  XbBrowserClassPart      Xbbrowser_class;
} XbBrowserClassRec;

extern XbBrowserClassRec XbbrowserClassRec;

typedef struct _XbBrowserPart {
    Widget    list;

    int view;
    int minView;
    Dimension minViewDim;

    int initialHighlight;
    int initialPosition;

    XtCallbackList  singleClick;
    XtCallbackList  doubleClick;
    XtCallbackList  scrollProc;
    XtCallbackList  jumpProc;

    XbListSelectionPtr items;

    int         *reverseMap;
    int         maxItem;
    int         maxReverse;

    int         sortedBrowser;
    int         position;
} XbBrowserPart;

typedef struct _XbBrowserRec {
  CorePart        core;
  CompositePart   composite;
  ConstraintPart  constraint;
  FormPart        form;
  ViewportPart    viewport;
  XbBrowserPart     Xbbrowser;
} XbBrowserRec;

typedef struct _XbBrowserConstraintsPart {
  int empty;
} XbBrowserConstraintsPart;

typedef struct _XbBrowserConstraintsRec {
    FormConstraintsPart       form;
    ViewportConstraintsPart   viewport;
    XbBrowserConstraintsPart    Xbbrowser;
} XbBrowserConstraintsRec;


#endif /* _XbBrowserP_h */
