/*
 * July 28, 1992 -- Bill Yeager
 * Additions to the c-client for slight variances to the uw imapd.
 */
#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <pwd.h>

#define null 0
#define BUFLEN 256
#define PATHLEN 1024

char *ucase();

static char rdbuf[BUFLEN];			  /* input buffer */
typedef struct INITOBJ_ {
  char *property;				  /* property to set */
  void  (*method)();				  /* method that does it */
} initobj;

static void setmailfile(), setmaildir();

static initobj initlist[]= {
      "MAIL-FILE", setmailfile,			  /* property UPPERCASE */
      "MAIL-DIRECTORY", setmaildir,
      null, null
};

static char mailfile[BUFLEN];
static char maildir[BUFLEN];

void parse_tenex_init();
static void parse_init_file(); 

#ifdef TESTING
char *fs_get(i)
     int i;
{
  return((char *)malloc(i));
}

main ()
{
  parse_tenex_init();
}

#endif
/*
 * Here we parse both .imapinit, and .mminit if they exist.
 * We set parameters whose values can be accessed by function
 * calls:
 *   (char *)tenex_mail_file()     returns mail file name or null pointer.
 *   char *)tenex_mail_dir()       returns $home relative directory or 
 *                                 null string, ie, "". If directory 
 *                                 exists, it ALWAYS terminates in "/"
 * We look at .imapinit first. If a variable is set there, and also in
 * .mminit, then the second "set" is ignored.
 */
static int dejaFait= 0;				  /* aready done */
static char home[PATHLEN];			  /* home dir */
void
parse_tenex_init()
{
  FILE *fd;
  char path[PATHLEN];

  if (dejaFait)					  /* Done yet */
    return;
  else
    dejaFait = 1;
  mailfile[0] = maildir[0] = '\0';
  /* 
   * get the homedirectory */
  strcpy(home, getpwuid(geteuid())->pw_dir);
  /*
   * look for .imapinit */
  strcpy(path, home);
  strcat(path, "/.imapinit");
  /*
   * open the file */
  fd = fopen(path, "r");
  /*
   * if exists, then parse */
  if (fd)
    parse_init_file(fd);
  /*
   * Now, try .mminit. */
  strcpy(path, home);
  strcat(path, "/.mminit");
  fd = fopen(path, "r");
  /*
   * if exists, then parse */
  if (fd)
    parse_init_file(fd);
}

/*
 * read until eof skipping lines that begin with '#',
 * and parsing the appropriate other lines */
static void
parse_init_file(fd)
     FILE *fd;
{
  char *token;
  char *property;
  initobj *iop;

  while (fgets(rdbuf, BUFLEN, fd)) {
    if (*rdbuf == '#')
      continue;
    token = strtok(rdbuf, " \t\n");
    if (!token)
      continue;					  /* empty line */
    token = ucase(token);
    if (strcmp(token, "SET") != 0) 
      continue;					  /* bogus line */
    token = strtok(null, " \t\n");		  /* set variable */
    if (!token)
      continue;					  /* missing property?? */
    token = ucase(token);
    for (iop = initlist; iop->property; ++iop) {
      if (strcmp(token, iop->property) != 0)
	continue;				  /* Zut! Ratez! */
      /*
       * fetch value token */
      token = strtok(null, " \t\n");
      if (!token)
	continue;				  /* Ratez */
      /*
       * send to the method */
      (*iop->method)(token);
      break;
    }
  }
}

/*
 * we return the file name here. If there is a path supplied, we
 * ignore it. "set mail-directory <folie>" is used for the path */

static void
setmailfile(value)
     char *value;
{
  char *tmp= rindex(value, "/");

  if (mailfile[0] != '\0')
    return;					  /* already set */
  if (tmp)
    strcpy(mailfile, tmp+1);			  /* ignore ../ */
  else
    strcpy(mailfile, value);
}

/*
 * We are connected to ~, so we ignore "~/" if it is there:
 * Possibilities:  return
 *  fou            fou/
 *  fou.           fou./
 *  fou/           fou/
 *  fou/.          fou/
 *  
 */
static void
setmaildir(value)
     char *value;
{
  int len;

  if (maildir[0] != '\0')
    return;					  /* aready set */
  if (*value != '/')				  /* not absolute? */
    sprintf(maildir, "%s/", home);		  /* yes. */
  if (*value == '~')
    if (*(value + 1) != '/')	  
      return;					  /* bogus */
    else {
      value += 2;				  /* skip "~/"" */
      if (*value == '.')
	return;					  /* "~/." est possible */
    }
  strcat(maildir, value);
  /*
   * Insure "/" termination */
  len = strlen(maildir);
  if (maildir[len-1] != '/') {			  /* last character */
    if (maildir[len-1] == '.') {		  /* "fou/."  est possible */
      if (maildir[len-2] == '/') {
	maildir[len-1] = '\0';			  /* termination of "/." */
	return;
      }
    }
    maildir[len] = '/';				  /* ajoutez un '/' */
    maildir[len+1] = '\0';			  /* bien termine */
  } 
}

/*
 * the probes */
char *
tenex_mail_file()
{
  return (mailfile[0] == '\0' ? (char *)null : mailfile);
}
/*
 * if the name is "~...", then we assume it is home relative, and
 * just return "USER/". Otherwise we return the maildir path. We don't
 * allow "~user_name/..." and so the open will choke */
static char homedir[PATHLEN];
char *
tenex_mail_dir(name)
     char *name;
{
  /*
   * see if we need to look for "~/" */
  if (!name)
    return maildir;				  /* INBOX - no ~ */
  else 
    if (*name != '~')
      return maildir;
    else {
      sprintf(homedir, "%s/", home);
      return homedir;
    }
}

/* just check for "~/" and skip it */
char *tenex_name_path(name)
     char *name;
{
  if (*name != '~')
    return name;
  else {
    ++name;
    if (*name == '/')
      ++name;
  }
  return name;
}

char *
ucb_mail_folder(name)
     char *name;
{
  /*
   * see if we need to look for "~/" */
  sprintf(homedir, "%s/", home);
  if (*name != '~')
    /* 
     * Either init specificed or user's root path */
    return ((maildir[0] == '\0') ? homedir :	  /* user's root path */
	    maildir);				  /* init specified */
  else 
    return homedir;				  /* ~ coerces root path */
}

/* just check for "~/" and skip it */
char *ucb_name_path(name)
     char *name;
{
  if (*name != '~')
    return name;
  else {
    ++name;
    if (*name == '/')
      ++name;
  }
  return name;
}
