/*
 * ncsalib.h - declarations for transparent declaration of necessary global
 *             variables for NCSA Telnet library functions
 * 
 */ 


/*
*  Machine specific information for NCSA Telnet TCP/IP kernel
****************************************************************************
*                                                                          *
*                                                                          *
*      NCSA Telnet                                                         *
*      by Tim Krauskopf, VT100 by Gaige Paulsen, Tek by Aaron Contorer     *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign, IL  61820                                                *
*                                                                          *
****************************************************************************
*   Defines for TCP/IP library, are you a Mac or a PC?
*/

#ifndef MAC
#define PC 1
#define ETHER 1
#define UB 1 
#endif


#ifndef ETHER
#define ATALK 1
#endif

/*
*   Defines which have to do with Ethernet addressing versus Appletalk
*   addressing.  Ethernet has 6 bytes of hardware address, ATALK has 4
*/
#ifdef ETHER
#define DADDLEN 6
#define WINDOWSIZE 2048
#define TSENDSIZE 1024
#define DEFWINDOW 2048
#define DEFSEG	1024
#define TMAXSIZE 1024
#define UMAXLEN 1024
#define ICMPMAX 300 
#else
/*  define for AppleTalk */
#define DADDLEN 4
#define WINDOWSIZE 4096
#define TSENDSIZE 512
#define DEFWINDOW 512
#define DEFSEG	512
#define TMAXSIZE 512
#define UMAXLEN 512
#define ICMPMAX 300 
#endif


#ifdef PC
/*
*  define length of an integer - can be 16 or 32, we need to know which
*/
typedef char int8;
typedef unsigned char uint8;
typedef int int16;
typedef long int int32;
typedef unsigned int uint16;
typedef unsigned int uint;
typedef unsigned long int uint32;


#define TICKSPERSEC 18
#define SMINRTO 5
#define WRAPTIME 86400L				/* in seconds, only for PC */
#define NPORTS	30
#define CONNWAITTIME 20				/* default contime in seconds */
uint32 longswap();

#define NFDEF {2,0,0}
#define NBDEF {0,0,0}
#define BFDEF {0,0,0}
#define BBDEF {2,0,0}
#define UFDEF {1,0,0}
#define UBDEF {0,0,0}

#else
#define TICKSPERSEC 60
#define SMINRTO 25
#define NPORTS	30
#define CONNWAITTIME 20				/* default contime in seconds */

#define	longswap(x) x
#define intswap(x) x
#define movebytes(x,y,z) movmem(y,x,z)
#define movenbytes(x,y,z) movmem(y,x,z)
#define n_putchar(x) putchar(x)
#define n_puts(x) putln(x)
#define NPORTS	30

#endif

/* #include "netevent.h" */
#ifdef  __TURBOC__
#include <mem.h>


/*
*  Events for event processing in NCSA Telnet.
*  Used for netgetevent().
*/


#define USERCLASS	1	/* the user program will accept these events */
#define ICMPCLASS	2	/* ICMP in netsleep will look for these */
#define ERRCLASS    4	/* the user may or may not read these error messages */
#define SCLASS		8	/* the background server will take these */
#define CONCLASS    0x10	/* the application manages connections with these */

#define ERR1	1		/* an error message is waiting, ERRCLASS */

#define IREDIR	1		/* ICMP redirect, ICMPCLASS */

#define CONOPEN 1		/* connection has opened, CONCLASS */
#define CONDATA 2       /* there is data available on this connection */
#define CONCLOSE 3		/* the other side has closed its side of the connection */
#define CONFAIL 4		/* connection open attempt has failed */

#define UDPDATA 1		/* UDP data has arrived on listening port, USERCLASS */
#define DOMOK	2		/* domain name ready */
#define DOMFAIL 3		/* domain name lookup failed */
#define FTPCOPEN 20     /* FTP command connection has opened */
#define FTPCLOSE 21     /* FTP command connection has closed */
#define FTPBEGIN 22     /* FTP transfer beginning, dat =1 for get, 0 for put */
#define FTPEND   23     /* FTP transfer ending */
#define FTPLIST  24     /* FTP file listing taking place */
#define FTPUSER  25     /* FTP user name has been entered */
#define FTPPWOK	26		/* FTP password verified */
#define FTPPWNO 27		/* FTP password failed */
#define RCPBEGIN 30		/* RCP beginning */
#define RCPEND 31		/* RCP ending */

#define UDPTO 1			/* UDP request from DOMAIN timed out, SCLASS */
#define FTPACT 2		/* FTP transfer is active, keep sending */
#define TCPTO  3		/* TCP for DOMAIN timed out */
#define RCPACT 4		/* rcp is active, needs CPU time */
#define RETRYCON 5		/* retry connection packet, might be lost */
#define DOMNEXT 6               /* search next domain list entry */
#define E_CLOCK 7



#endif



/*
*  Host and local machine configuration information.
*
****************************************************************************
*                                                                          *
*      NCSA Telnet for the PC                                              *
*      by Tim Krauskopf, VT100 by Gaige Paulsen, Tek by Aaron Contorer     *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign, IL  61820                                                *
*                                                                          *
*      This program is in the public domain.                               *
*                                                                          *
****************************************************************************
*/

/*
*  Linked list of structures which describe other machines.
*  Arranged one per session with unique session names.
*/

struct machinfo {
	unsigned char 
		*sname,					/* pointer to name of session */
		*hname,                 /* pointer to name of that machine */
		*font,					/* font name, if we can do it */
		hostip[4],				/* IP number of this machine */
		gateway,				/* gateway preference, start with 1 */
		nameserv,				/* nameserver preference, start with 1 */
		bksp,					/* backspace value */
		halfdup,				/* half duplex required */
		crmap,					/* Strange Berkeley 4.3 CR mode needed */
		vtwrap,					/* flag on when need wrap mode */
		vtwidth;				/* how wide screen should be for this session */
	int
		clearsave,				/* whether to save cleared lines */
		fsize,					/* font size in points */
		nfcolor[3],				/* normal foreground */
		nbcolor[3],				/* normal background */
		bfcolor[3],				/* blink             */
		bbcolor[3],
		ufcolor[3],             /* underline */
		ubcolor[3],
		mno,					/* machine number for reference */
		mstat,					/* status of this machine entry */
		bkscroll,				/* how many lines to save */
		retrans,				/* initial retrans timeout */
		conto,					/* time out in seconds to wait for connect */
		window,					/* window, will be checked against buffers */
		maxseg,					/* maximum receivable segment size */
		mtu,					/* maximum transfer unit MTU (out) */
                domainsremaining,                       /* how many domain search list entries remain */
                destport;                               /* yepper, you can telnet to a different port than 23 */

	struct machinfo *next;		/* surprise, its a linked list! */
};

struct machinfo *gethostbyname(), *Sgethost(),*Shostlook(),*Slooknum(),*Slookip(),*Smadd();

/*
*  status fields for mstat, what do we know about that machine?
*/
#define NOIP 1					/* we don't have IP number */
#define UDPDOM 3				/* there is a UDP request pending on it */
/*  The next 20 numbers are reserved for UDPDOM */
#define HAVEIP 50				/* at least we have the # */
#define HFILE 70				/* we have IP number from host file */
#define DOM 71					/* we have an IP number from DOMAIN */
#define FROMKIP 72				/* have IP# from KIP server */



/*
*   Configuration information which 
*   the calling program may want to obtain from the hosts file.
*   The calling program should include hostform.h and call
*   Sgetconfig(cp)
*     struct config *cp;
*   which will copy the information to the user's data structure.
*/
struct config {
	unsigned char
		netmask[4],				/* subnetting mask being used */
		havemask,				/* do we have a netmask? */
		irqnum,					/* which hardware interrupt */
		myipnum[4],				/* what is my IP #? */
		me[32],					/* my name description (first 30 chars) */
		color[3],				/* default colors to use */
		hw[10],					/* hardware type for network */
		video[10],				/* video graphics hardware available */
		bios,					/* flag, do we want to use BIOS for screen access */
		tek,					/* flag, enable tektronix graphics */
		ftp,					/* flag, enable ftp server */
		rcp,					/* flag, enable rcp server */
		comkeys,				/* flag, commandkeys=yes */
		*termtype,				/* terminal type specification */
		*zone,					/* AppleTalk zone for KIP NBP */
		*defdom,				/* default domain */
		*capture,				/* pointer to where the capture file name is */
		*pass,					/* pointer to where the password file name is */
		*hpfile,				/* HP file name */
		*psfile,				/* PS file name */
		*tekfile;				/* tek file name */
int
		nstype,					/* nameserver = 1-domain 2-IEN116  */
		domto,					/* time out for UDP domain request */
		ndom,					/* number of retries for domain requests */
		timesl,					/* time slice */
		address,				/* segment address */
		ioaddr;					/* I/O address */
char            *domainpath;                               /* domain name search path */
char            *map3270;                               /* path to 3270 map */
char            tnmode;                                 /* how we decide to connect to 3270 streams */
};


#define TNMODE_FLAGGED  0
#define TNMODE_AUTO     1
#define TNMODE_NOTFLAGGED 2
#define TNMODE_OFF      3

#define BUFLENGTH       256

/*
 * Declaration of TCP/IP IO functions
 */
/*
int tcp_open(), tcp_write(), tcp_push(), tcp_close(), errhandle();
char *tcp_host(), tcp_getbuffer();
*/


struct machinfo *mp;
char *neterrstring();
char  buf[BUFLENGTH];
 
