#!/home/bwelch/bin/wish -f
# Cursor chapter

set file cursorfont.h

. config -cursor gumby -bd 2 -bg black

set in [open $file]
foreach line [split [read $in] \n] {
    if [regexp {^#define XC_([^ ]+) ([0-9]+)} $line match name value] {
	if {$name == "num_glyphs"} {
	    set num_glyphs [expr $value/2]
	    continue
	}
	if {$value == 0} {
	    set value 1	;# fudge on first cursor to avoid NULL
	}
	set glyphs($name) $value
    }
}
set maxcols 13
set maxrows [expr $num_glyphs/$maxcols + 1]
for {set row 0} {$row < $maxrows} {incr row} {
    frame .$row -bd 0 -bg white
    pack .$row -side top -fill x -expand true
    bind .$row <Any-Button> exit
}
set row 0
set col 0
foreach name [lsort [array names glyphs]] {
    label .$row.$col -text [format "%c" $glyphs($name)] -font cursor -bg white -width 1
    pack .$row.$col -side left
    update
    set map($row,$col) $name
    incr col
    if {$col >= $maxcols} {
	incr row
	set col 0
    }
}
close $in

set out [open /tmp/tab w]
for {set row 0 } {$row < $maxrows} {incr row} {
    puts -nonewline $out "Row [expr $row+1]"
}
puts $out ""
for {set col 0} {$col < $maxcols} {incr col} {
    for {set row 0 } {$row < $maxrows} {incr row} {
	if [info exists map($row,$col)] {
	    puts -nonewline $out $map($row,$col)\t
	}
    }
    puts $out ""
}
close $out
exec cat /tmp/tab &
