/*
 *
 * Copyright (C) 1993 Swedish University Network (SUNET)
 *
 *
 * This program is developed by UDAC, Uppsala University by commission
 * of the Swedish University Network (SUNET). 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 *                                          Martin.Wendel@udac.uu.se
 *
 *                                          Martin Wendel
 *                                          UDAC	
 *                                          Box 174
 *                                          S-751 04 Uppsala
 *                                          Sweden
 */

#include <tcl.h>
#ifndef const
#define const
#endif
#ifndef TRUE
# define TRUE 1
#endif
#ifndef FALSE
# define FALSE 0
#endif

#ifndef NL
# define NL '\12'
#endif
#ifndef CR
# define CR '\15'
#endif

#ifndef MIME_CHARSET
# define MIME_CHARSET "ISO-8859-1"
#endif
#define BUFSIZE 2048
#define ENC7BIT 0
#define ENC8BIT 1
#define ENCBINARY 2
#define ENCBASE64 3
#define ENCQUOTEDPRINTABLE 4
#define ENCUUENCODE 5
#define ENCBINHEX 6
#define ENCUNKNOWN 7

#define TYPETEXT 0
#define TYPEAPPLICATION 1
#define TYPEIMAGE 2
#define TYPEAUDIO 3
#define TYPEVIDEO 4
#define TYPEMULTIPART 5
#define TYPEMESSAGE 6
#define TYPEEXTERNAL 7
#define TYPEBINHEX 8
#define TYPEAPPLESINGLE 9
#define TYPEAPPLEDOUBLE 10
#define TYPEUNKNOWN 11

#define ERROR_MORE     -4
#define ERROR_LESS     -3
#define ERROR_CHECKSUM -2
#define ERROR_FORMAT   -1
#define OK             0
#define DONE           1

#ifndef SENDMAIL
#ifndef bool
#define bool int
#endif
#endif /*! SENDMAIL */

typedef struct messagestruct MessageStruct;
typedef struct binhexstruct BinHexStruct;
typedef struct bufstruct BufStruct;
typedef struct funcstruct FuncStruct;
typedef struct typestruct TypeStruct;
typedef struct boundstruct BoundStruct;
typedef struct specheaderstruct SpecHeaderStruct;
  
#ifndef SENDMAIL
#ifndef EMIL
typedef struct envelope ENVELOPE;

struct header {
  char *h_field;
  char *h_value;
  struct header *h_link;
};

typedef struct header HDR;

struct envelope {
  MessageStruct *message;
  BufStruct *buf;
  HDR *e_header;
};

#endif /* EMIL */
#endif /* SENDMAIL */

struct messagestruct {

  /* Header info */

  HDR *header;          /* Header structure */
  SpecHeaderStruct *specheader; /* Special headers */
  char *maintype;
  char *subtype;
  /* Various booleans */
  bool dosubheaders;    /* Use headers to mark parts */
  bool washeaders;      
  bool topofmulti;      /* Top of a multipart, don't write */
  bool ismulti;
  bool investigate;     /* Check or convert? */
  bool dotunnel;        /* Tunnel mail without any conversions */

  BoundStruct *bound;   /* Boundary stack */
  bool putendbound;    /* Put end boundary at end of this bodypart */
  bool newbound;
  /* Buffer list */

  BufStruct *buf;


  /* File info */
  char *filename;	/* Name of attached file */
  char *extension;
  short filenamelen;	/* Length of `filename' */
  long applefile;

  /* Text info */
  char *fcharset;	/* Character set of text */
  char *tcharset;	/* Character set of text */
  short esc;
  long highchars;
  CHARSET *from_charset;
  CHARSET *to_charset;

  /* Codings */
  char *encoding;	/* Encoding of data */
  short enc;		

  /* Type */
  short type;

  /* General positional info */
  bool first;		/* True if first line in part */
  bool last;		/* True if last line in part */
  long inlinelen;		
  long lfs;
  long start_line;	/* lineno of first line in part */
  long end_line;		/* lineno of last line in part */
  long totlen;		

  long fpartlen;	/* Used by BinHex */

  BinHexStruct *binhex;

  int (*fpart)();	/* Used by BinHex */

  MessageStruct *next;	/* Next node in list */

};

struct bufstruct {
  /* Input */
  char *in;		/* Input buffer */
  long inlen;		/* Length of data in `in' */
  long inpos;		/* Position */
  long uulen;

  /* Output */
  char *out;		/* Output buffer */
  long outlen;		/* Length of data in `out' */
  long outpos;		/* Position */
  long outdiff;		/* Used by BinHex */

  /* Buffer */
  char *inrest;		/* Input rest buffer (leftovers from `in') */
  long inrestlen;	/* Length of `inrest' */
  
  long linelen;
  long inpartlen;
  long outpartlen;
  int (*fconv)();	/* Actual conversion function */
  char *name;
  BufStruct *next;
};

struct binhexstruct {
  char hdr[21];		/* End of BinHex header fork */
  long hdrlen;		/* Length of header */
  unsigned short checksum;/* BinHex CRC */
  char btype[4];	/* Type */
  char bauth[4];	/* Author */
  char flag[2];		/* Flags */
  char dclen[4];	/* Data fork length */
  char rclen[4];	/* Resource fork length */
  long dlen;		
  long dcount;
  long rlen;
  long rcount;
  char hc[2];		/* CRC */
  long datafork[2];	
  char lastrun;
  bool run;
};

struct funcstruct {
  char *name;
  int (*func)();
};

struct typestruct {
  char *name;
  short type;
};

struct boundstruct {
  char *name;
  char *lend;
  long namelen;
  long endlen;
  int bcount;
  BoundStruct *next;
};

struct specheaderstruct {
  char *name;
  SpecHeaderStruct *next;
};

/* Globals */

CHARSET *local_mime_charset;
char ISO_TO_7BIT[256];
char ISO_TO_QP[256];
char BASE64_TO_8BIT[256];
char BASE64[64];
char BinHex[256];
char ToBinHex[64];
MessageStruct *MkMess_Root;
MessageStruct *MkMess_Curr;
MessageStruct *MkTcl_Root;
MessageStruct *MkTcl_Curr;
BufStruct *MkMess_Buf;
BufStruct *MkTcl_Buf;
BoundStruct *MkMess_Boundary;
bool checkuuencode, checkbinhex;
long linecount;
Tcl_Interp *interp;
#include "mkdef.h"




