#                     #
# header/mnemonic.tcl #
#######################


#############################################################################
#                                                                           #
# This file contains routines for parsing a Mnemonic message.               #
#                                                                           #
#############################################################################


#
# Check the headers X-Charset and X-Char-Esc
proc check_header_mnemonic {} {
	global SPECHEADER
	global MNEMESCAPE
	if {[set MAINTYPE [getmaintype]] != 0} {
		if {$MAINTYPE == "MIME"} {
			return 0
		}
	}
	if {[set MNEMCHARSET [getheader "X-Charset"]] != 0} {
		setfromcharset $MNEMCHARSET
		addspecheader X-Charset
		if {[set MNEMESCAPE [getheader "X-Char-Esc"]] != 0} {
			setfromesc $MNEMESCAPE
			addspecheader X-Char-Esc
		}
	}
}

check_header_mnemonic
