
static char rcsid[] = "@(#)$Id: exitprog.c,v 5.3 1992/12/25 00:26:49 syd Exp $";

/*******************************************************************************
 *  The Elm Mail System  -  $Revision: 5.3 $   $State: Exp $
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *	Syd Weinstein, Elm Coordinator
 *	elm@DSI.COM			dsinc!elm
 *
 *******************************************************************************
 * $Log: exitprog.c,v $
 * Revision 5.3  1992/12/25  00:26:49  syd
 * Fix routine names
 * From: Syd
 *
 * Revision 5.2  1992/12/24  21:42:01  syd
 * Fix messages and nls messages to match.  Plus use want_to
 * where appropriate.
 * From: Syd, via prompting from Jan Djarv <Jan.Djarv@sa.erisoft.se>
 *
 * Revision 5.1  1992/10/03  22:58:40  syd
 * Initial checkin as of 2.4 Release at PL0
 *
 *
 ******************************************************************************/

#include "headers.h"
#include "s_elm.h"

int
exit_prog()
{
	/** Exit, abandoning all changes to the mailbox (if there were
	    any, and if the user say's it's ok)
	**/

	char *msg, answer;
	register int i, changes;

	dprint(1, (debugfile, "\n\n-- exiting --\n\n"));

	/* Determine if any messages are scheduled for deletion, or if
	 * any message has changed status
	 */
	for (changes = 0, i = 0; i < message_count; i++)
	  if (ison(headers[i]->status, DELETED) || headers[i]->status_chgd)
	    changes++;
	
	if (changes) {
	  /* YES or NO on softkeys */
	  if (hp_softkeys) {
	    define_softkeys(YESNO);
	    softkeys_on();
	  }
	  if (changes == 1)
	    MCsprintf(msg, catgets(elm_msg_cat, ElmSet, ElmAbandonChange,
		"Abandon change to mailbox? (%c/%c) "), *def_ans_yes, *def_ans_no);
	  else
	    MCsprintf(msg, catgets(elm_msg_cat, ElmSet, ElmAbandonChangePlural,
		"Abandon changes to mailbox? (%c/%c) "), *def_ans_yes, *def_ans_no);
	  answer = want_to(msg, *def_ans_no, LINES-3);

	  if(answer != *def_ans_yes) return -1;
	}

	fflush(stdout);
	return leave(0);
}
