;;;
;;; $Id: irchat-globals.el,v 1.4 1994/08/01 11:35:29 tmo Exp $
;;;
;;; see file irchat-copyright.el for change log and copyright info

(eval-when-compile
  (if (not (featurep 'irchat-inlines))
      (require 'irchat-inlines)))
(provide 'irchat-globals)

;;;
;;; Do not change these
;;;

(defconst irchat-client-version-major "2"
  "Major version number. Major functional changes change this number.")

(defconst irchat-client-version-minor "42"
  "Minor version number. Protocol changes and bug fixes change this number.")

(defconst irchat-client-version-release "$Date: 1994/08/01 11:35:29 $"
  "version release date")

(defconst irchat-client-name "Irchat"
  "*Name of this program.")

(defconst irchat-version
  (format "%s %s.%s (%s)" 
	  irchat-client-name 
	  irchat-client-version-major
	  irchat-client-version-minor
	  (progn 
	    (string-match ".*: \\([^ ]*\\).*" irchat-client-version-release)
	    (substring irchat-client-version-release 
		       (match-beginning 1) (match-end 1))))
  "The version of irchat you are using.")

(defconst irchat-author-nickname "tml"
  "The nickname used by the author of IRCHAT.")


(defvar irchat-emacs-version (string-to-int (substring emacs-version 0 2))
  "*Emacs major version number.")

(defvar irchat-server-process nil)

(defvar irchat-status-message-string nil)

(defun irchat-buffer-disable-undo (buffer)
  "Disabling UNDO"
  (if (= irchat-emacs-version 19)
      (buffer-disable-undo buffer)
    (buffer-flush-undo buffer)))

(defun irchat-get-buffer-window (buffer)
  "Getting the window for a buffer"
  (if (= irchat-emacs-version 19)
      (get-buffer-window buffer t)
    (get-buffer-window buffer)))

(defconst irchat-client-error-msg "Unrecognized command: '%s'"
  "*Error message given to anyone asking wrong CLIENT data.")

(defvar irchat-channel-filter "" 
  "*Enables use of \\[universal-argument] with NAMES and TOPIC.")

(defvar irchat-invited-channel)
(setq irchat-invited-channel nil)

(defvar irchat-away-indicator)
(defvar irchat-freeze-indicator)

(defvar irchat-old-nickname nil
  "A place to keep old nickname in case it returs thas
we cannot change to new nick")

(defvar irchat-current-channel nil
  "The channel you currently have joined.")

(defvar irchat-current-channels nil
  "The channels you have currently joined.")

(defvar irchat-channel-indicator "No channel"
  "The current channel, \"pretty-printed.\"")

(defvar irchat-private-indicator nil
  "A string displayed in the mode line indicating that user is
currently engaged in a one-to-one conversation.")

(defvar irchat-polling 0
  "T when we are automatically polling the server.")

(defvar irchat-freeze nil
  "If non-nil the Dialogue window will not be scrolled automatically to bring
new entries into view.")

(defvar irchat-privmsg-partner nil
  "The person who got your last private message.")

(defvar irchat-current-chat-partner nil
  "The person you are in a private conversation with.")

(defvar irchat-current-chat-partners nil
  "An list containing nics user is chatting with.")

(defvar irchat-chat-partner-alist nil
  "An alist containing nics user is chatting with.")

(defvar irchat-command-buffer-mode 'channel
  "symbol chat or channel depending on which is current mode at 
command buffer.")

(defvar irchat-nick-alist nil
  "An alist containing the nicknames of users known to currently be on IRC.
Each element in the list is a list containing a nickname.")

(defvar irchat-channel-alist nil 
  "An alist containing the channels on IRC.  Each element in the list is 
a list containing a channel name.")

(defvar irchat-greet-author nil
  "T until we notice that the author of IRCHAT is present, and send him
a greeting telling what version of IRCHAT this is.")

(defvar irchat-userathost ""
  "The user@host for the current line.")

(defvar irchat-debug-buffer nil)
(defvar irchat-server-buffer nil)
(defvar irchat-server-name nil)

(defvar irchat-away-indicator "-")
(defvar irchat-freeze-indicator "-")

;;;
;;;  eof
;;; 
