/* 
 * 'new' config.h:
 *	A configuration file designed to make best use of the abilities
 *	of ircII, and trying to make things more intuitively understandable.
 *
 * Original: Michael Sandrof
 * V2 by Carl V. Loesch (lynx@dm.unirm1.it)
 * V2.EPIC by jfn (nelson@cs.uwp.edu)
 */

#ifndef _CONFIG_H_
#define _CONFIG_H_

/* 
 *  This is where you should set your default server list.  The list should
 *  be a space seperated list of the form hostname:portnum:password.  The
 *  portnum and password are optional.  An example is:
 *
 *	#define DEFAULT_SERVER "irc.iastate.edu irc-2.mit.edu:6666:lag-2sux"
 *
 *  If you choose to #define SERVERS_FILES, this #define will be ignored unless
 *  the SERVERS_FILES is empty or cannot be opened.
 *
 *  The client will not operate if you do not provide a server to use.
 */
#define DEFAULT_SERVER "/tmp/.ircd/6667 irc-2.mit.edu"


/*
 * Define this if you want an mIRC compatable /dcc resume capability.
 * Note that this BREAKS THE IRC PROTOCOL, and if you use this feature,
 * the behavior is NON COMPLIANT.  If this warning doesnt bother you,
 * and you really want this feature, then go ahead and #define this.
 */
#undef MIRC_BROKEN_DCC_RESUME

/*
 * Define this if you want the traditional EPIC behavior of checksumming
 * files before they are send and verification after they are recieved.
 * If this is #undef'd, you will not send out checksums, nor will you use
 * any checksums if they are recieved (from other epic clients).
 */
#define USE_DCC_CHECKSUM

/*
 * Define this if you dont want the $rand() function to really be random.
 * Some people have scripts that depend on $rand() being "psuedo-random".
 * I will not cast judgement as to whether this is or is not a good idea.
 */
#undef OLD_RANDOM_BEHAVIOR

/*
 * Define this if you want the $glob() function to be in your client.
 * There is a case for having this function and a case against having
 * this function:
 *
 * Pro: makes it easier to write scripts like xdcc, since they can easily
 *      get at the filenames in your xdcc directory
 * Cons: with $unlink(), $rmdir(), etc, it makes it that much easier for
 *      a backdoor to do damage to your account.
 *
 * You will have to weigh the evidence and decide if you want to include it.
 */
#define INCLUDE_GLOB_FUNCTION


/*
 * Youll want to define this if your system is missing the glob()
 * call, or if its broken (solaris).
 *
 * Actually, you should #define this if you can compile the supplied
 * glob.c.  If it works, dont mess with it.
 */
#define NEED_GLOB

/*
 * Define this to be the number of seconds that you want the client
 * to block on a server-connection.  I found it annoying that it was
 * hard coded to 15 seconds, as that was never long enough to make
 * a connection.  Change it back if you want.
 *
 * This is ONLY for /server and 'server-like' connections, not for DCC.
 */
#define CONNECT_TIMEOUT 30


/*
 * If you use menus, and if you think having a seperator between the
 * menu and the rest of the window would be nice, then #define this
 * to a string which you would like to use as a repeating pattern
 * for the seperator.  The string you specify here will be repeated 
 * as many times as neccesary to span the width of the screen.
 * If you #undef this, then no seperator line will be used (this is 
 * the "old" behavior).   If you dont want the seperator, make sure 
 * you #undef this, dont just #define it to NULL! =)
 */
#define MENU_BOTTOM "  Menu"


/*
 * Define this is you want support for long (30 character) nicknames.
 * You probably dont want to #define this if you dont use any servers
 * that support long nicknames.
 */
#define ALLOW_LONG_NICKNAMES

/*
 *  ircII has a security feature for paranoid sysadmins or for those
 *  users whose sysadmins are paranoid.  The security feature allows
 *  you to restrict who may use the ircII client.  You have four options:
 *
 *	1) compile into the binary a list of uids who can use the program
 *		*Pros: cant be hacked -- very secure
 *		*Cons: cant be changed w/o recompiling
 *	2) compile into the binary a file which will contain the uids of
 *	   the people who can use the program
 *		*Pros: can be changed as you need by just editing the file
 *		*Cons: since the uids are in a file, prone to hacking
 *	3) compile into the binary a file which will contain the uids of
 *	   the people who cannot use the program
 *		*Pros: allows for public use and allow you to exclude
 *		       troublemakers without enumerating everyone else
 *		*Cons: since the uids are in a file, prone to hacking
 *	4) compile into the binary a password
 *		*Pros: cant be hacked -- secure
 *		*Cons: cant be changed w/o recompiling
 *
 *    The first two options are mutually exclusive.  The third and fourth
 *    options can be specified at your option.  If you specify both the
 *    first and second options, the first option has precedence.
 */

/*
 *   To use the first security feature, #define HARD_SECURE.  You will also
 *   have to #define VALID_UIDS which will be a list of those uids (integers,
 *   not usernames) which will be allowed to execute the resulting program.
 *   If you #define HARD_SECURE but do not define #VALID_UIDS, then noone
 *   will be able to execute the program!
 */
#undef HARD_SECURE
#define VALID_UIDS "100 101"

/*
 *  To use the second security measure, simply #define SOFT_SECURE to a 
 *  filename that will be world-readable that will contain the uids of
 *  all the users who will be allowed to execute the program.  It is important
 *  that this file be readable by at least every person who can execute the
 *  program or this security measure will be comprimised.
 *
 *  The uid file should have one uid per line (integer, not username).
 *
 *  You can define VALID_UID_FILE, but if SOFT_SECURE is not defined, it will
 *  not be used.
 */
#undef SOFT_SECURE
#define VALID_UID_FILE "/home/jnelson/..."

/*
 *  This allows you to use the third security option.  If you define this,
 *  it should be assigned to a file that will contain a listing of all of
 *  the uids (integers, not usernames) that will not be allowed to execute
 *  the resulting program.
 */
/*#define INVALID_UID_FILE "/home/jnelson/...."*/

/*
 * This part lets you deny certain hosts from running your irc client.
 * For instance, my university does not allow irc'ing from dialup machines,
 * So by putting the dialup's hostnames in the specified file, they can't
 * Run irc.
 *  -- Chris Mattingly <Chris_Mattingly@ncsu.edu>
 *
 * If you define this, it *absolutely* must be in double quotes ("s)!
 */
#undef HOST_SECURE

#ifdef HOST_SECURE
#define INVALID_HOST_FILE "/home/jnelson/...host.deny"
#endif


/*
 *  This allows you to use the fourth security option.  If you define this,
 *  the program will prompt the user to enter this prompt before it will
 *  continue executing the program.  This password does not affect in any
 *  way the other protection schemes.  A user who is not allowed to run
 *  the program will not be allowed to use the program even if they know
 *  the password.
 */
/*#define PASSWORD "booya"*/

/*
 * This is the fun part.  If someone runs your program who shouldnt run
 * it, either because the dont know the password or because they arent
 * on the valid list or whatever, ircII will execute this program to 
 * "spoof" them into thinking your program is actually some other program.
 *
 * This can be defined to any valid C expression that will resolve to a
 * character string. (ie, a character literal or function call)
 */
#define SPOOF_PROGRAM getenv("SHELL")

/*
 * Define this if you want compatability with the old ircd2.7 servers.
 * If you do not ever use ircd2.7 servers, you should probably leave this
 * undefined, as you will save some space in your binary.
 *
 * There is no support whatsoever for 2.5 and 2.6 servers, so dont use
 * this client with those server versions.
 */
#define COMPAT_27

/*
 * Set the following to 1 if you wish for IRCII not to disturb the tty's flow
 * control characters as the default.  Normally, these are ^Q and ^S.  You
 * may have to rebind them in IRCII.  Set it to 0 for IRCII to take over the
 * tty's flow control.
 */
#define USE_FLOW_CONTROL 1


/* 
 * This should be defined to the thing that is used in your password files
 * to seperate the fields of the user information.  Dont change this unless
 * you know for sure that your password file doesnt use the comma. (most do)
 */
#define GECOS_DELIMITER ',' 

/*
 * Below you can set what type of mail your system uses and the path to the
 * appropriate mail file/directory.  Only one may be selected. 
 * You may also undefine both if you think mail checking in irc clients is
 * silly.
 *
 * You will have to define one of these ONLY if autoconf is not able to
 * determine your mailbox!
 *
 * Mail checking will *NOT* be done unless you use the unix or ams mail
 * systems.
 */
/* AMS_MAIL is the Andrew Mail System mail format. */
#undef AMS_MAIL

/* UNIX_MAIL is the normal unix mail format.  */
#undef UNIX_MAIL 

#ifdef AMS_MAIL
# define AMS_MAIL "Mailbox"
#endif /* AMS_MAIL */

/*
 * MAIL_DELIMITER specifies the unique text that separates one mail message
 * from another in the mail spool file when using UNIX_MAIL.
 *
 * This belongs somewhere else.
 */
#define MAIL_DELIMITER "From "


/* 
 * If you define UNAME_HACK, the uname information displayed in the
 * CTCP VERSION info will appear as "*IX" regardless of any other
 * settings.  Useful for paranoid users who dont want others to know
 * that theyre running a buggy SunOS machine. >;-)
 */
#undef UNAME_HACK


/* 
 * If defined, COMMENT_HACK will only allow C-like comments to appear
 * at the beginning of a line.  (To be precise, the opening "slash-star"
 * must be at the beginning of a line, and the closing "star-slash" may be
 * anywhere. This increases compatability with older ircII scripts that
 * dont know about the "slash-star star-slash" comments (like PhoEnIx)
 *
 * Any script that defines an alias '*' and then calls it with "slash-star"
 * loses.  No aplogies.
#define COMMENT_HACK
 */
/*
 * This is now controlled by /set COMMENT_HACK, whose default you can set
 * below. It should work the same.
 */


/* 
 * If defined, you are able to suspend the irc process by pressing ^Z.
 * if undef'd, you are not able to suspend the irc process.
 */
#define ALLOW_STOP_IRC


/* And here is the port number for default client connections.  */
#define IRC_PORT 6667

/*
 * If you want to have a file containing the list of irc servers to 
 * use, define SERVERS_FILE to be that filename.  Put the file in the 
 * ircII library directory.  This file should be whitespace seperated
 * hostname:portnum:password (with the portnum and password being
 * optional).  This server list will supercede the DEFAULT_SERVER
 */
#define SERVERS_FILE "ircII.servers"


/*
 * Message Of The Day file
 *
 * There has been a lot of confusion surrounding this setting. 
 * I will attempt to explain how this works, so that when it doesnt
 * work in the way you are expecting, you wont gripe at me for it
 * being a bug. :P
 *
 * 1) This displays the motd <*>ONCE<*> per time you change it.  Once
 * they see it, they never see it again until you change the MOTD.
 *
 * 2) If you want them to see it every time, you have to #define
 * ALWAYS_SHOW_MOTD which was an "undocumented" feature until now.
 *
 * 3) the MOTD file must be in the TOP level of the irclib directory.
 * This is the same directory as the "script" "translation" and "help"
 * directories!
 *
 * I still think a better alternative is to cat the file using the
 * the file operators and putting it in local.  Maybe ill write a
 * script to do this.
 */
/*#define MOTD_FILE "ircII.motd"*/
/*#define PAUSE_AFTER_MOTD 1*/
/*#define ALWAYS_SHOW_MOTD*/

/*
 * define this if you want your irc client to exit after an 
 * operator kill.  I have no idea why you would, though.
 */
#undef QUIT_ON_OPERATOR_KILL

/*
 * The compile sequence records the user/host/time of the compile,
 * which can be useful for tampering and newbie reasons.  If you want
 * the compile to remain anonymous, define this option.  In this case,
 * the host and the time will remain, but the 'user' field will not
 * be displayed to the user.
 * 
 * Please dont define this on a whim -- be sure you really want it.
 */
#undef ANONYMOUS_COMPILE


/*
 * Below are the IRCII variable defaults.  For boolean variables, use 1 for
 * ON and 0 for OFF.  You may set string variable to NULL if you wish them to
 * have no value.  None of these are optional.  You may *not* comment out or
 * remove them.  They are default values for variables and are required for
 * proper compilation.
 */
#define DEFAULT_ALWAYS_SPLIT_BIGGEST 1
#define DEFAULT_AUTO_NEW_NICK 1
#define DEFAULT_AUTO_RECONNECT 1
#define DEFAULT_AUTO_REJOIN 1
#define DEFAULT_AUTO_UNMARK_AWAY 0
#define DEFAULT_AUTO_WHOWAS 1
#define DEFAULT_BEEP 1
#define DEFAULT_BEEP_MAX 3
#define DEFAULT_BEEP_ON_MSG "NONE"
#define DEFAULT_BEEP_WHEN_AWAY 1
#define	DEFAULT_BOLD_VIDEO 1
#define DEFAULT_CHANNEL_NAME_WIDTH 0
#define DEFAULT_CLOCK 1
#define DEFAULT_CLOCK_24HOUR 0
#define DEFAULT_CLOCK_ALARM NULL
#define DEFAULT_CMDCHARS "/"
#define DEFAULT_COMMAND_MODE 0
#define DEFAULT_COMMENT_HACK 1
#define DEFAULT_CONTINUED_LINE "+"
#define DEFAULT_DCC_LONG_PATHNAMES 1
#define DEFAULT_DCC_SLIDING_WINDOW 1
#define DEFAULT_DISPLAY 1
#define DEFAULT_EIGHT_BIT_CHARACTERS 0
#define DEFAULT_ENCRYPT_PROGRAM NULL
#define DEFAULT_EXEC_PROTECTION 0
#define DEFAULT_FLOATING_POINT_MATH 0
#define DEFAULT_FLOOD_AFTER 3
#define DEFAULT_FLOOD_RATE 3
#define DEFAULT_FLOOD_USERS 3
#define DEFAULT_FLOOD_WARNING 0
#define DEFAULT_FULL_STATUS_LINE 1
#define DEFAULT_HELP_PAGER 1
#define DEFAULT_HELP_PROMPT 1
#define DEFAULT_HELP_WINDOW 0
#define DEFAULT_HIDE_PRIVATE_CHANNELS 0
#define DEFAULT_HIGHLIGHT_CHAR "BOLD"
#define DEFAULT_HISTORY 150
#define DEFAULT_HISTORY_FILE NULL
#define DEFAULT_HOLD_MODE 0
#define DEFAULT_HOLD_MODE_MAX 0
#define DEFAULT_INDENT 0
#define DEFAULT_INPUT_ALIASES 0
#define DEFAULT_INPUT_PROMPT "> "
#define DEFAULT_INPUT_PROTECTION 1
#define DEFAULT_INSERT_MODE 1
#define DEFAULT_INVERSE_VIDEO 1
#define DEFAULT_LASTLOG 1000
#define DEFAULT_LASTLOG_LEVEL "ALL"
#define DEFAULT_LOG 0
#define DEFAULT_LOGFILE "irc.log"
#define DEFAULT_MAIL 2
#define DEFAULT_MAX_RECURSIONS 25
#define DEFAULT_MODE_STRIPPER 0
#define DEFAULT_NO_CTCP_FLOOD 1
#define DEFAULT_NOTIFY_HANDLER "NOISY"
#define DEFAULT_NOTIFY_LEVEL "ALL"
#define DEFAULT_NOTIFY_ON_TERMINATION 1
#define DEFAULT_NUM_OF_WHOWAS 1
#define DEFAULT_PAD_CHAR ' '
#define DEFAULT_REVERSE_STATUS_LINE 1
#define DEFAULT_SCROLL 1
#define DEFAULT_SCROLL_LINES 1
#define DEFAULT_SECURITY 0
#define DEFAULT_SEND_IGNORE_MSG 0
#define DEFAULT_SHELL "/bin/sh"
#define DEFAULT_SHELL_FLAGS "-c"
#define DEFAULT_SHELL_LIMIT 0
#define DEFAULT_SHOW_AWAY_ONCE 1
#define DEFAULT_SHOW_CHANNEL_NAMES 1
#define DEFAULT_SHOW_END_OF_MSGS 1
#define DEFAULT_SHOW_NUMERICS 0
#define	DEFAULT_SHOW_STATUS_ALL 0
#define DEFAULT_SHOW_WHO_HOPCOUNT 1
#define DEFAULT_STATUS_AWAY " (Away)"
#define DEFAULT_STATUS_CHANNEL " %C"
#define DEFAULT_STATUS_CHANOP "@"
#define DEFAULT_STATUS_CLOCK " %T"
#define DEFAULT_STATUS_FORMAT "%T [%R] %*%=%@%N%#%S%H%B%Q%A%C%+%I%O%M%F %D %U %W"
#define DEFAULT_STATUS_FORMAT1 "%T [%R] %*%=%@%N%#%S%H%B%Q%A%C%+%I%O%M%F %U"
#define DEFAULT_STATUS_FORMAT2 "%W %X %Y %Z"
#define DEFAULT_STATUS_HOLD "Held: "
#define DEFAULT_STATUS_HOLD_LINES "%B"
#define DEFAULT_STATUS_INSERT ""
#define DEFAULT_STATUS_MODE " (+%+)"
#define DEFAULT_STATUS_MAIL " (M: %M)"
#define DEFAULT_STATUS_NO_REPEAT 0
#define	DEFAULT_STATUS_NOTIFY " (W: %F)"
#define DEFAULT_STATUS_OPER "*"
#define DEFAULT_STATUS_OVERWRITE " (Overwrite)"
#define DEFAULT_STATUS_QUERY " (Query: %Q)"
#define DEFAULT_STATUS_SERVER " (%S)"
#define DEFAULT_STATUS_UMODE " (+%#)"
#define DEFAULT_STATUS_USER "ircII2.8.2-EPIC3 -- Type /help for help"
#define DEFAULT_STATUS_USER1 ""
#define DEFAULT_STATUS_USER2 ""
#define DEFAULT_STATUS_USER3 ""
/*
 * You must have SHOW_STATUS_ALL set to 0 for the following STATUS_USERs to show
 * These only appear in your non-current window	-- Jake [WinterHawk] Khuon
 */
#define DEFAULT_STATUS_USER4 ""
#define DEFAULT_STATUS_USER5 ""
#define DEFAULT_STATUS_USER6 ""
#define DEFAULT_STATUS_USER7 ""
#define DEFAULT_STATUS_USER8 ""
#define DEFAULT_STATUS_USER9 ""
#define DEFAULT_STATUS_VOICE "+"
#define DEFAULT_STATUS_WINDOW "^^^^^^^^"
#define DEFAULT_SUPPRESS_SERVER_MOTD 0
#define DEFAULT_SUPPRESS_FROM_REMOTE_SERVER 0
#define DEFAULT_TAB 1
#define	DEFAULT_TAB_MAX 0
#define DEFAULT_UNDERLINE_VIDEO 1
#define DEFAULT_USERINFO "EPIC3 -- Bigger and slower then you'd ever hoped!"
#define DEFAULT_VERBOSE_CTCP 1
#define DEFAULT_WARN_OF_IGNORES 0
#define DEFAULT_XTERM_OPTIONS NULL

/*
 * People have wanted me to explain some of these #defines.  Well,
 * Ill tell you what i will do.  I will tell you that some of these
 * defines turn on obscure features, and others turn on features that
 * are specificly placed there at the request of one of the debuggers,
 * but i am making the option of using it available to the general 
 * public.  You should always be aware of what changing one of these 
 * #defines might do to affect the operation of the client.  You can get
 * a good feel for the impact by grepping the source code for them.
 * General "themes" of what the defines do are listed on the right.  
 * These "themes" describe the *spirit* of the define, but do NOT 
 * annotate every reprocussion of defining it!
 *
 * Also, i dont guarantee that changing any of these defines will
 * or wont compile correctly, so you may have to be prepared to do
 * some minor debugging in that case (send changes along to me if
 * you do =)  Dont change any of these unless you know what it will do.
 */
#undef DEBUG			/* General debugging info.  dont use */
#undef EMACS_KEYBINDINGS	/* meta-key keybindings. */
#undef EPIC_DEBUG		/* force coredump on panic */
#define EXEC_COMMAND		/* allow /exec comamnd */
#undef HACKED_DCC_WARNING	/* warn if handshake != sender */
#undef HARD_UNFLASH		/* do a hard reset instead of soft on refresh */
#undef HOP			/* stuff i like that wintrhawk doesnt */
#undef MURPLE			/* stuff i put in for murple to test */
#undef NO_BOTS			/* no bots allowed */
#undef NO_CHEATING		/* always do it the "right" way, no shortcuts */
#undef PHONE			/* stuff phone likes to have */
#undef RESTRICTED		/* keep in novice mode and no /exec */
#undef STRIP_EXTRANEOUS_SPACES	/* strip leading and trailing spaces */
#define WIND_STACK		/* Winding code stack.  Experimental */
#undef WINTRHAWK		/* stuff wintrhawk likes that i dont */

#undef ENFORCE_STRICTER_PROTOCOL /* There are certain things that the stock
				   ircII client doesnt allow users to do
				   that are not illegal by the letter of
				   the protocol (but perhaps the spirit).
				   As i find these restrictions, i #ifdef
				   them out under this define.  The specific
				   list of what may or may not be contained
				   under this define can change from release
				   to release. */
#undef	I_DONT_TRUST_MY_USERS	/* There are certain things that the stock
				   ircII client doesnt allow users to do
				   that are neither illegal by the letter of
				   the protocol nor the spirit of the protocol.
				   These are the things that only a really
				   anal retentive person wouldnt want to totaly
				   prohibit his users from doing without any
				   exceptions.  When i find these things, i
				   #ifdef them out under this define.  The
				   specific list of what may or may not be
				   contained under this define can change
				   from release to release.  This replaces
				   the I_AM_A_FASCIST_BASTARD define which
				   several people found offensive because
				   they wanted to define it =) */

/* Dont change these -- theyre important. */
#if defined(VALID_UIDS) && !defined(HARD_SECURE)
#undef VALID_UIDS
#endif

#if defined(PASSWORD) && !defined(HARD_SECURE) && !defined(SOFT_SECURE)
#undef PASSWORD
#endif

#if defined(HARD_SECURE) && !defined(VALID_UIDS)
#error You must #define VALID_UIDS if you #define HARD_SECURE
#endif

#if defined(VALID_UID_FILE) && !defined(SOFT_SECURE)
#undef VALID_UID_FILE
#endif

#if defined(SOFT_SECURE) && !defined(VALID_UID_FILE)
#error You must #define VALID_UID_FILE if you #define SOFT_SECURE
#endif

#ifndef SPOOF_PROGRAM
#define SPOOF_PROGRAM "/bin/sh"
#endif
/* end of section not to change */

#endif /* _CONFIG_H_ */

