/*
 * alias.h: header for alias.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 *
 * @(#)$Id: alias.h,v 1.5 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _ALIAS_H_
#define _ALIAS_H_

#include <stdio.h>	/* needed for save_aliases() */
#include "irc_std.h"

#define COMMAND_ALIAS 0
#define VAR_ALIAS 1

#define LEFT_BRACE '{'
#define RIGHT_BRACE '}'
#define LEFT_BRACKET '['
#define RIGHT_BRACKET ']'
#define LEFT_PAREN '('
#define RIGHT_PAREN ')'
#define DOUBLE_QUOTE '"'

#define MAX_CMD_ARGS 5

extern	char	alias_illegals[];

struct	ArgPosTag
{
	char *ArgStart;
	int ArgLen;
	char *FirstComp;
};

typedef	struct ArgPosTag	ArgPos;

/* Alias: structure of each alias entry */
typedef	struct	AliasStru
{
	char	*name;			/* name of alias */
	char	*stuff;			/* what the alias is */
	char	*stub;			/* the file its stubbed to */
	int	mark;			/* used to prevent recursive aliasing */
	int	global;			/* set if loaded from `global' */
	struct	AliasStru *next;	/* pointer to next alias in list */
}	Alias;

extern	void	add_alias _((int, char *, char *));
extern	void	alias _((char *, char *, char *));
extern	void	delete_alias _((int, char *));
extern	char *	expand_alias _((char *, char *, char *, int *, char **));
extern	void	execute_alias _((char *, char *, char *));
extern	Alias *	find_alias _((Alias **, char *, int, int *, int));
extern	void	flush_aliases _((char *, char *, char *));
extern	char *	get_alias _((int, char *, int *, char **));
extern	void	insert_alias _((Alias **, Alias *));
extern	char ** match_alias _((char *, int *, int));
extern	char *	MatchingBracket _((char *, char, char));
extern	char *	MatchingBracketBackwards _((char *, char *, char, char));
extern	char *	parse_inline _((char *, char *, int *));
extern	void	save_aliases _((FILE *, int));
extern	void	stubcmd _((char *, char *, char *));
extern	int	word_count _((char *));
extern	char *	function_push _((char *));
extern	char *	function_pop _((char *));
extern	char *	function_shift _((char *));
extern	char *	function_unshift _((char *));
extern	char *	host_to_ip _((const char *));
extern	char *	ip_to_host _((const char *));
extern	char *	one_to_another _((const char *));

#endif /* _ALIAS_H_ */
