;; DragDome/theme.jl

(let*
    (
     (font (get-font "-b&h-lucida-medium-r-normal-*-*-100-*-*-p-*-iso8859-1"))
     (font-small (get-font "-b&h-lucida-medium-r-normal-*-*-80-*-*-p-*-iso8859-1"))
	
     (font-colors "black")
	
     (title-width
      (lambda (w)
        (let
	    ((w-width (car (window-dimensions w))))
	  (max 0 (+ 20 (min (- w-width 67) (text-width (window-name w) font)))))))
    
     (title-width-small
      (lambda (w)
        (let
	    ((w-width (car (window-dimensions w))))
	  (max 0 (+ 16 (min (- w-width 50) (text-width (window-name w) font-small)))))))
          
     (update-title-width
      (lambda (w)
        (if (eq (window-get w 'current-frame-style) 'DragDome) 
	    (rebuild-frame w))))
	
     ;; This function determines the appropriate offset for the title bar.
     ;; It's result is added to all frame parts that should be shifted.
     (title-offset 
      (lambda (w) 
	(let* 
	    ((w-width (car (window-dimensions w))) ;window width
	     (t-width (title-width w))	;title width
	     (b-width (+ 44 t-width))	;bar width
	     (offset  (or (window-get w 'title-offset) 0)))
	  (if (>= w-width (+ offset b-width)) 
	      offset
	    (- w-width b-width)))))
	
     (title-offset-small
      (lambda (w) 
	(let* 
	    ((w-width (car (window-dimensions w))) ;window width
	     (t-width (title-width-small w)) ;title width
	     (b-width (+ 27 t-width))	;bar width
	     (offset  (or (window-get w 'title-offset) 0)))
	  (if (>= w-width (+ offset b-width)) 
	      offset
	    (- w-width b-width)))))
    
     (title-images (list (make-image "mid-title-inactive.png")
			 (make-image "mid-title-active.png")))
     (close-images (list (make-image "close-inactive.png") 
			 (make-image "close-active.png")))
     (iconify-images (list (make-image "iconify-inactive.png") 
			   (make-image "iconify-active.png")))
     (maximize-images (list (make-image "maximize-inactive.png")
			    (make-image "maximize-active.png")))
   
     (title-images-small (list (make-image "mid-title-inactive-small.png")
			       (make-image "mid-title-active-small.png")))
     (close-images-small (list (make-image "close-inactive-small.png") 
			       (make-image "close-active-small.png")))
     (iconify-images-small (list (make-image "iconify-inactive-small.png") 
				 (make-image "iconify-active-small.png")))
    
     (bar-shadow-images (list (make-image "mid-title-shadow-inactive.png") 
			      (make-image "mid-title-shadow-active.png")))
   
     (bottom-image (make-image "bottom-bar.png"))
     (top-image (make-image "top-bar.png"))
     (top-left-image (make-image "top-left.png"))
     (top-right-image (make-image "top-right.png"))
     (bottom-left-image (make-image "bottom-left.png"))
     (bottom-right-image (make-image "bottom-right.png"))
     (left-image (make-image "left-bar.png"))
     (right-image (make-image "right-bar.png"))

     (frame `(
	      ((background . ,top-image)
	       (top-edge . -5)
	       (left-edge . 0)
	       (right-edge . 0)
	       (class . title))
	      ((background . ,left-image)
	       (left-edge . -5)
	       (top-edge . 0)
	       (bottom-edge . 0)
	       (class . left-border))
	      ((background . ,top-left-image)
	       (left-edge . -5)
	       (top-edge . -5)
	       (class . title))
	      ((background . ,top-right-image)
	       (right-edge . -5)
	       (top-edge . -5)
	       (class . title))
	      ((background . ,right-image)
	       (right-edge . -5)
	       (top-edge . 0)
	       (bottom-edge . 0)
	       (class . right-border))
	      ((background . ,bottom-image)
	       (left-edge . 0)
	       (right-edge . 0)
	       (bottom-edge . -5)
	       (class . bottom-border))
	      ((background . ,bottom-left-image)
	       (left-edge . -5)
	       (bottom-edge . -5)
	       (class . bottom-left-corner))
	      ((background . ,bottom-right-image)
	       (right-edge . -5)
	       (bottom-edge . -5)
	       (class . bottom-right-corner))
	      ((background . ,title-images)
	       (foreground . ,font-colors)
	       (font . ,font)
	       (text . ,window-name)
	       (top-edge . -20)
	       (left-edge . ,(lambda (w) (+ 11 (title-offset w))))
	       (width . ,(lambda (w) (title-width w font)))
	       (x-justify . center)
	       (y-justify . center)
	       (class . title))
	      ((background . ,close-images)
	       (left-edge . ,(lambda (w) (+ -5 (title-offset w))))
	       (top-edge . -20)
	       (class . close-button))
	      ((background . ,iconify-images)
	       (left-edge . ,(lambda (w) (+ (title-width w) 11 (title-offset w))))
	       (top-edge . -20)
	       (class . iconify-button))
	      ((background . ,maximize-images)
	       (left-edge . ,(lambda (w) (+ (title-width w) 24 (title-offset w))))
	       (top-edge . -20)
	       (class . maximize-button))
	      ))
     (frame-small `(
		    ((background . ,top-image)
		     (top-edge . -5)
		     (left-edge . 0)
		     (right-edge . 0)
		     (class . title))
		    ((background . ,left-image)
		     (left-edge . -5)
		     (top-edge . 0)
		     (bottom-edge . 0)
		     (class . left-border))
		    ((background . ,top-left-image)
		     (left-edge . -5)
		     (top-edge . -5)
		     (class . title))
		    ((background . ,top-right-image)
		     (right-edge . -5)
		     (top-edge . -5)
		     (class . title))
		    ((background . ,right-image)
		     (right-edge . -5)
		     (top-edge . 0)
		     (bottom-edge . 0)
		     (class . right-border))
		    ((background . ,bottom-image)
		     (left-edge . 0)
		     (right-edge . 0)
		     (bottom-edge . -5)
		     (class . bottom-border))
		    ((background . ,bottom-left-image)
		     (left-edge . -5)
		     (bottom-edge . -5)
		     (class . bottom-left-corner))
		    ((background . ,bottom-right-image)
		     (right-edge . -5)
		     (bottom-edge . -5)
		     (class . bottom-right-corner))
		    ((background . ,title-images-small)
		     (foreground . ,font-colors)
		     (font . ,font-small)
		     (text . ,window-name)
		     (top-edge . -17)
		     (left-edge . ,(lambda (w) (+ 8 (title-offset-small w))))
		     (width . ,(lambda (w) (title-width-small w)))
		     (x-justify . center)
		     (y-justify . center)
		     (class . title))
		    ((background . ,close-images-small)
		     (left-edge . ,(lambda (w) (+ -5 (title-offset-small w))))
		     (top-edge . -17)
		     (class . close-button))
		    ((background . ,iconify-images-small)
		     (left-edge . ,(lambda (w) (+ (title-width-small w) 8 (title-offset-small w))))
		     (top-edge . -17)
		     (class . iconify-button))
		    ))
     (border-frame `(
		     ((background . ,top-image)
		      (top-edge . -5)
		      (left-edge . 0)
		      (right-edge . 0)
		      (class . title))
		     ((background . ,left-image)
		      (left-edge . -5)
		      (top-edge . 0)
		      (bottom-edge . 0)
		      (class . left-border))
		     ((background . ,top-left-image)
		      (left-edge . -5)
		      (top-edge . -5)
		      (class . title))
		     ((background . ,top-right-image)
		      (right-edge . -5)
		      (top-edge . -5)
		      (class . title))
		     ((background . ,right-image)
		      (right-edge . -5)
		      (top-edge . 0)
		      (bottom-edge . 0)
		      (class . right-border))
		     ((background . ,bottom-image)
		      (left-edge . 0)
		      (right-edge . 0)
		      (bottom-edge . -5)
		      (class . bottom-border))
		     ((background . ,bottom-left-image)
		      (left-edge . -5)
		      (bottom-edge . -5)
		      (class . bottom-left-corner))
		     ((background . ,bottom-right-image)
		      (right-edge . -5)
		      (bottom-edge . -5)
		      (class . bottom-right-corner))
		     ))
     (shaped-frame `(
		     ((background . ,title-images)
		      (foreground . ,font-colors)
		      (font . ,font)
		      (text . ,window-name)
		      (top-edge . -20)
		      (left-edge . ,(lambda (w) (+ 16 (title-offset w))))
		      (width . ,(lambda (w) (title-width w)))
		      (x-justify . center)
		      (y-justify . center)
		      (class . title))
		     ((background . ,close-images)
		      (left-edge . ,(lambda (w) (+ (title-offset w))))
		      (top-edge . -20)
		      (class . close-button))
		     ((background . ,iconify-images)
		      (left-edge . ,(lambda (w) (+ (title-width w) 16 (title-offset w))))
		      (top-edge . -20)
		      (class . iconify-button))
		     ((background . ,maximize-images)
		      (left-edge . ,(lambda (w) (+ 29 (title-width w) (title-offset w))))
		      (top-edge . -20)
		      (class . maximize-button))
		     ((background . ,bar-shadow-images)
		      (left-edge . ,(lambda (w) (title-offset w)))
		      (top-edge . -4)
		      (width . ,(lambda (w) (+ 44 (title-width w))))
		      (class . title))
		     ))
     (shaped-frame-small `(
			   ((background . ,title-images-small)
			    (foreground . ,font-colors)
			    (font . ,font-small)
			    (text . ,window-name)
			    (top-edge . -17)
			    (left-edge . ,(lambda (w) (+ 13 (title-offset-small w))))
			    (width . ,(lambda (w) (title-width-small w)))
			    (x-justify . center)
			    (y-justify . center)
			    (class . title))
			   ((background . ,close-images-small)
			    (left-edge . ,(lambda (w) (title-offset-small w)))
			    (top-edge . -17)
			    (class . close-button))
			   ((background . ,iconify-images-small)
			    (left-edge . ,(lambda (w) (+ 13 (title-width-small w) (title-offset-small w))))
			    (top-edge . -17)
			    (class . title))
			   ((background . ,bar-shadow-images)
			    (left-edge . ,(lambda (w) (title-offset-small w)))
			    (top-edge . -4)
			    (width . ,(lambda (w) (+ 27 (title-width-small w))))
			    (class . title))
			   ))
     )

  (add-frame-style 'DragDome
		   (lambda (w type)
		     (cond 
		      ((eq type 'shaped) shaped-frame)
		      ((eq type 'shaded) shaped-frame)
		      ((eq type 'transient) frame-small)
		      ((eq type 'shaded-transient) shaped-frame-small)
		      ((eq type 'unframed) nil-frame)
		      (t frame))))
            
  (call-after-property-changed 'WM_NAME update-title-width)
  )
