/*                               -*- Mode: C -*- 
 * html_entities.c -- 
 * ITIID           : $ITI$ $Header $__Header$
 * Author          : Ulrich Pfeifer
 * Created On      : Mon Jan 27 22:06:08 1997
 * Last Modified By: Ulrich Pfeifer
 * Last Modified On: Mon Jan 27 22:18:02 1997
 * Language        : C
 * Update Count    : 2
 * Status          : Unknown, Use with caution!
 * 
 * (C) Copyright 1997, Universitt Dortmund, all rights reserved.
 * 
 * $$
 * $Log: html_entities.c,v $
 * Revision 2.1  1997/02/08 10:59:30  pfeifer
 *  added cons files
 *
 */

#include "html_entities.h"

static char htab[947] =
{
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  ' ', ' ', ' ',
  '\354',			/* igrave =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  ' ', ' ',
  '\333',			/* Ucirc =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\363',			/* oacute =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\267',			/* middot =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\244',			/* curren =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\322',			/* Ograve =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\332',			/* Uacute =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\362',			/* ograve =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  ' ', ' ', ' ',
  '\277',			/* iquest =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
  ' ', ' ', ' ', ' ',
  '\321',			/* Ntilde =>  */
  ' ', ' ', ' ', ' ', ' ', ' ',
  '\342',			/* acirc =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\372',			/* uacute =>  */
  ' ', ' ', ' ',
  '\346',			/* aelig =>  */
  ' ', ' ', ' ', ' ',
  '\270',			/* cedil =>  */
  ' ', ' ',
  '\330',			/* Oslash =>  */
  ' ', ' ',
  '\325',			/* Otilde =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
  ' ', ' ',
  '\264',			/* acute =>  */
  ' ', ' ', ' ', ' ', ' ', ' ',
  '\335',			/* Yacute =>  */
  ' ', ' ',
  '\352',			/* ecirc =>  */
  ' ', ' ', ' ', ' ', ' ',
  '\361',			/* ntilde =>  */
  ' ',
  '\76',			/* gt => > */
  '\331',			/* Ugrave =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\74',			/* lt => < */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
  ' ', ' ', ' ',
  '\370',			/* oslash =>  */
  ' ', ' ',
  '\365',			/* otilde =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\345',			/* aring =>  */
  '\304',			/* Auml =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\356',			/* icirc =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\375',			/* yacute =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\313',			/* Euml =>  */
  '\371',			/* ugrave =>  */
  ' ', ' ', ' ', ' ', ' ', ' ',
  '\261',			/* plusmn =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\317',			/* Iuml =>  */
  ' ',
  '\241',			/* iexcl =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\306',			/* AElig =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
  ' ', ' ', ' ',
  '\253',			/* laquo =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\364',			/* ocirc =>  */
  ' ', ' ', ' ',
  '\265',			/* micro =>  */
  '\326',			/* Ouml =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\301',			/* Aacute =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\320',			/* ETH =>  */
  ' ', ' ',
  '\307',			/* Ccedil =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\334',			/* Uuml =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
  ' ', ' ',
  '\273',			/* raquo =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\341',			/* aacute =>  */
  ' ', ' ',
  '\373',			/* ucirc =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\336',			/* THORN =>  */
  '\242',			/* cent =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\347',			/* ccedil =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\327',			/* times =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\311',			/* Eacute =>  */
  ' ', ' ', ' ', ' ',
  '\344',			/* auml =>  */
  ' ',
  '\257',			/* macr =>  */
  ' ',
  '\243',			/* pound =>  */
  ' ',
  '\376',			/* thorn =>  */
  '\300',			/* Agrave =>  */
  ' ', ' ', ' ',
  '\251',			/* copy =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
  ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\353',			/* euml =>  */
  ' ', ' ', ' ', ' ', ' ', ' ',
  '\266',			/* para =>  */
  ' ', ' ', ' ', ' ',
  '\240',			/* nbsp =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
  ' ', ' ', ' ', ' ',
  '\302',			/* Acirc =>  */
  ' ',
  '\357',			/* iuml =>  */
  ' ', ' ', ' ',
  '\247',			/* sect =>  */
  ' ', ' ', ' ',
  '\351',			/* eacute =>  */
  ' ', ' ', ' ',
  '\252',			/* ordf =>  */
  ' ', ' ', ' ', ' ', ' ',
  '\260',			/* deg =>  */
  '\272',			/* ordm =>  */
  '\340',			/* agrave =>  */
  ' ', ' ', ' ', ' ', ' ', ' ',
  '\271',			/* sup1 =>  */
  '\262',			/* sup2 =>  */
  '\263',			/* sup3 =>  */
  ' ',
  '\46',			/* amp => & */
  ' ',
  '\337',			/* szlig =>  */
  ' ', ' ', ' ', ' ', ' ',
  '\275',			/* frac12 =>  */
  ' ',
  '\274',			/* frac14 =>  */
  ' ', ' ', ' ',
  '\276',			/* frac34 =>  */
  ' ', ' ',
  '\366',			/* ouml =>  */
  ' ', ' ', ' ', ' ',
  '\360',			/* eth =>  */
  ' ', ' ', ' ', ' ', ' ',
  '\315',			/* Iacute =>  */
  ' ', ' ',
  '\312',			/* Ecirc =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\310',			/* Egrave =>  */
  ' ', ' ',
  '\256',			/* reg =>  */
  ' ',
  '\42',			/* quot => " */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\303',			/* Atilde =>  */
  ' ', ' ', ' ',
  '\254',			/* not =>  */
  ' ', ' ', ' ', ' ',
  '\374',			/* uuml =>  */
  ' ', ' ', ' ', ' ', ' ',
  '\255',			/* shy =>  */
  ' ', ' ', ' ', ' ',
  '\250',			/* uml =>  */
  ' ',
  '\245',			/* yen =>  */
  ' ', ' ', ' ', ' ',
  '\305',			/* Aring =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\316',			/* Icirc =>  */
  ' ',
  '\377',			/* yuml =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\355',			/* iacute =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\350',			/* egrave =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
  ' ', ' ', ' ',
  '\343',			/* atilde =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\367',			/* divide =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\314',			/* Igrave =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\324',			/* Ocirc =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
  '\246',			/* brvbar =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 
  ' ', ' ', ' ',
  '\323',			/* Oacute =>  */
  ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
};

static unsigned int 
hash (s)
     unsigned char *s;
{
  unsigned int result = 0;

  while (*s) {
    result = (result << 1) % 947;
    result += *s;
    s++;
  }
  return (result % 947);
}

static char *
end_entity (s)
     char *s;
{
  char *end = s + 7;

  while (++s < end) {
    if (!isalnum(*s)) return(s);
  }
  return (NULL);
}

void
decode_entities (s)
     char *s;
{
  char *space = s - 1;
  char *e;
  int pl;

  while (*s) {
    switch (*s) {
    case ' ':
      space = s;
      break;
    case '&':
      if (s[1] == '#') {
	unsigned int code = 0;

	e = s + 2;
	while (isdigit (*e)) {
	  code = code * 10 + *e;
	  e++;
	}
	if (*e != ';')		/* the single correct value */
	  e--;			/* '\0' terminated :-( */

	*e = code;
      } else {
	if ((e = end_entity (s))) {
	  unsigned int code;
	  char se = *e;

	  *e = '\0';
	  code = hash (s + 1);
	  *e = se;
	  if (*e != ';')	/* the single correct value */
	    e--;		/* '\0' terminated :-( */

	  *e = htab[code];
	}
      }
      /* xx fgg&auml;bar */
      /* x ^   s    e    */
      if (e) {
        pl = s - space - 1;
        bcopy (space + 1, e - pl, pl);
        memset (space + 1, ' ', e - pl - (space + 1));
      }
    }
    s++;
  }
}

#ifdef TEST_ENTITIES
main (argc, argv)
     int argc;
     char *argv[0];
{
  while (--argc) {
    char *s;

    argv++;
    fprintf (stderr, "=> [%s]\n", argv[0]);
    decode_entities(argv[0]);
    fprintf (stderr, "<= [%s]\n", argv[0]);
  }
}
#endif
