;;; adapt.el: 
;;; v1.50; 10 Jan 1994
;;; Copyright (C) 1993, 1994  Heiko Muenkel
;;; email: muenkel@tnt.uni-hannover.de
;;;
;;;  This program is free software; you can redistribute it and/or modify
;;;  it under the terms of the GNU General Public License as published by
;;;  the Free Software Foundation; either version 1, or (at your option)
;;;  any later version.
;;;
;;;  This program is distributed in the hope that it will be useful,
;;;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;;  GNU General Public License for more details.
;;;
;;;  You should have received a copy of the GNU General Public License
;;;  along with this program; if not, write to the Free Software
;;;  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;;;
;;; 
;;; Description:
;;;
;;;	General functions to port the lisp code, which was written for
;;;	the Lucid Emacs to the GNU Emacs 19.
;;; 
;;; Installation: 
;;;   
;;;	Put this file in one of your lisp load directories.
;;;


(defun adapt-lemacsp ()
  "Return t, if the editor is the Lucid Emacs."
  (string= (substring emacs-version -5 nil) "Lucid"))


(defun adapt-emacsp ()
  "Return t, if the editor is the GNU Emacs 19."
  (and 
   (not (string= (substring emacs-version -5 nil) "Lucid"))
   (string= (substring emacs-version 0 2) "19")))


(if (adapt-emacsp)
    (progn
      (load-library "lucid")

      (load-library "lmenu")

      (require 'font-lock)

      (make-face 'font-lock-comment-face)

(defun read-number (prompt &optional integers-only)
	"Reads a number from the minibuffer."
	(interactive)
	(let ((error t)
	      (number nil))
	  (if integers-only
	      (while error
		(let ((input-string (read-string prompt)))
		  (setq number (if (string= "" input-string)
				   nil
				 (read input-string)))
		  (if (integerp number)
		      (setq error nil))))
	    (while error
	      (let ((input-string (read-string prompt)))
		(setq number (if (string= "" input-string)
				 nil
			       (read input-string)))		
		(if (numberp number)
		    (setq error nil)))))
	  number))

      (defvar original-read-string-function nil
	"Points to the original Emacs 19 function read-string.")

      (if (not original-read-string-function)
	  (fset 'original-read-string-function
		(symbol-function 'read-string)))

      (defun read-string (prompt &optional initial-contents history)
	"Return a string from the minibuffer, prompting with string PROMPT.
If non-nil, optional second arg INITIAL-CONTENTS is a string to insert
in the minibuffer before reading.
Third arg HISTORY, if non-nil, specifies a history list. This is only
a dummy variable in the GNU Emacs 19."
	(original-read-string-function prompt initial-contents))

      (defun make-extent (from to &optional buffer)
	"Make extent for range [FROM, TO) in BUFFER -- BUFFER defaults to 
current buffer.  Insertions at point TO will be outside of the extent;
insertions at FROM will be inside the extent (and the extent will grow.).
This is only a simple emulation for the Lucid Emacs extents !"
	(list 'extent from to buffer))

      (defun set-extent-face (extent face)
	"Make the given EXTENT have the graphic attributes specified by FACE.
This is only a simple emulation for the Lucid Emacs extents !"
	(put-text-property (car (cdr extent))
			   (car (cdr (cdr extent)))
			   'face
			   face
			   (car (cdr (cdr (cdr extent))))))

      (defun delete-extent (extent_obj)
	"Remove EXTENT from its buffer; this does not modify the buffer's text,
only its display properties.
This is only a simple emulation for the Lucid Emacs extents !"
	(remove-text-properties (car (cdr extent_obj))
				(car (cdr (cdr extent_obj)))
				(list 'face nil)
				(car (cdr (cdr (cdr extent_obj))))))
      ))
    

(provide 'adapt)
