/*
 * Copyright (C) 1995 Free Software Foundation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.ai.mit.edu.
 * 
 * etl_cw.c
 *
 * Purpose:
 *   Simple bits of code used to make copyright information available
 * at runtime for all the utilities which use ETALK library source
 * code.  These functions will be accessed on the command line for
 * most applications.
 *
 * $Log: etl_cw.c,v $
 * Revision 1.2  1995/06/13  00:04:28  zappo
 * Some compilers can't handle multi-line strings. Changed to many calls
 * to printf.
 *
 * Revision 1.1  1995/05/09  23:46:46  zappo
 * Initial revision
 *
 * ::Header:: etalklib.h
 */
#include "etalklib.h"


/*
 * Function: CW_display_copywrite
 *
 *   Prints out the copywrite notice warning that this is free
 * software and all that other cool stuff.
 *
 * Returns:     Nothing
 * Parameters:  None
 *
 * History:
 * zappo   5/9/95     Created
 */
void CW_display_copywrite()
{
  printf(" Copyright (C) 1994, 1995 Free Software Foundation\n\n");

  printf(" This program is free software; you can redistribute it and/or modify\n");
  printf(" it under the terms of the GNU General Public License as published by\n");
  printf(" the Free Software Foundation; either version 2, or (at your option)\n");
  printf(" any later version.\n\n");

  printf(" This program is distributed in the hope that it will be useful,\n");
  printf(" but WITHOUT ANY WARRANTY; without even the implied warranty of\n");
  printf(" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n");
  printf(" GNU General Public License for more details.\n\n");

  printf(" You should have received a copy of the GNU General Public License\n");
  printf(" along with this program; if not, you can either send email to this\n");
  printf(" program's author (see below) or write to:\n\n");

  printf("              The Free Software Foundation, Inc.\n");
  printf("              675 Mass Ave.\n");
  printf("              Cambridge, MA 02139, USA. \n\n");

  printf(" Please send bug reports, etc. to zappo@gnu.ai.mit.edu.\n");
}
