/*
 * Copyright (C) 1994, 1995 Free Software Foundation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.ai.mit.edu.
 *
 * $Log: etalk.h,v $
 * Revision 1.10  1995/07/21  02:23:04  zappo
 * Changed version number
 *
 * Revision 1.9  1995/07/16  16:12:33  zappo
 * Added a new state for a user which us UNREACHABLE meaning in the
 * process of being deleted after a failed attempt to connect.
 *
 * Revision 1.8  1995/03/25  04:09:28  zappo
 * Fixed copyright, and prototypes in non-ansi section.
 *
 * Revision 1.7  1995/03/12  20:28:03  zappo
 * Added some new headers and myappname to context, and new message types
 *
 * Revision 1.6  1995/02/11  17:50:13  zappo
 * Added ringer report, and a new shutdown prototype
 *
 * Revision 1.5  1995/02/01  03:38:38  zappo
 * the ringer id # was changed from 7 (bell) to 9 (1 abouve BS) and added
 * a fn.
 *
 * Revision 1.4  1995/01/28  16:17:48  zappo
 * Added ringer information
 *
 * Revision 1.3  1994/11/19  17:04:48  zappo
 * Added some function prototypes.
 *
 * Revision 1.2  1994/11/16  23:15:03  zappo
 * Added sockflag field, and moved some defines into this file.
 *
 * Revision 1.1  1994/08/29  23:38:06  zappo
 * Initial revision
 *
 */

#ifndef ETALK_

#define ETALK_ "ETALK version 0.10 (c) 1994 Free Software Foundation"

#define NUMEDITKEYS 3

/*
 * lets define the context used thoughout
 * this talk program.
 */
struct TalkContext {
  struct HostObject  *me;		/* The current host.            */
  struct InputDevice *tty;		/* TTY to emacs                 */
  int                 socketflag;       /* TRUE means subprocess        */
  int                 ringerflag;       /* TRUE means ringer is active  */
  struct InputDevice *emacs_connect;	/* emacs network port           */
  struct InputDevice *remote_connect;	/* remote connect port          */
  struct InputDevice *udp_port;		/* my udp to daemon port        */
  struct InputDevice *udp_ring;	        /* udp port to use for ring svc */
  struct InputDevice *local_daemon;	/* The local daemons address    */
  char                editkeys[3];      /* My editkeys                  */
  pid_t               pid;		/* pid, (autoconf makes pid_t)  */
  char               *myname;		/* my name                      */
  char               *myappname; 	/* for gtalkd, name of this app */
  int                 message_delay;	/* delay between goofy messages */
};

/*
 * Describe a USER.  USERS represent different connections to
 * multiple talk programs.
 */
enum TalkClientType { Unknowntalk, VanillaTalk, ETALK, YTALK };
enum TalkUserState  { USER_NEW = 0, USER_CONNECTED = 1, 
			USER_UNREACHABLE = 2, USER_CLOSED = 3 };

struct UserObject {
  char               *name;	/* name of user                 */
  char                editkey[3]; /* thier edit keys            */
  int                 id;	/* unique user id.              */
  enum TalkClientType type;	/* thier client type            */
  enum TalkUserState  state;	/* state of this structure      */
  struct InputDevice *remote;	/* thier TCP io device          */
  struct InputDevice *local;	/* thier device to emacs window */
  struct UserObject  *next;	/* closure                      */
  struct UserObject  *prev;
};

/*
 * The following defines are the MESSAGETYPE sent to the emacs
 * over the TTY.  Any character not listed (ie, A-z) means a message
 * to print in the minibuffer.
 */
/* socket number of emacs_connect */
#define TTY_LOCALPORT 0x01
/* socket number of remote_connect */
#define TTY_REMOTEPORT 0x02
/* user id of new user struct */
#define TTY_USERID 0x03
/* id of user struct just turned off. */
#define TTY_DELETED 0x04
/* a minibuff message which should not be logged. */
#define TTY_NOLOG 0x05
/* a reply-query answer proclaming the user and machine he called from. */
#define TTY_REPLY_USER 0x06
/* a ringer announcement came it.  Report this to emacs to make then hook up */
#define TTY_RINGER_REPORT 0x07
/* a look-here command to tell parent that the address of the */
/* currently connecting person should be done on a different system. */
#define TTY_LOOK_HERE 0x08

#ifdef PROTOTYPES
/* etalk.c */
extern void  etalk_shutdown();

/* et_cmd.c */
extern void ETC_parse_command(struct TalkContext *Ctxt, struct InputDevice *dev);
extern int ETC_test();

/* et_daemn.c */
extern void ET_reset_ids();
extern int DMN_Lookup(struct TalkContext *Ctxt, struct InputDevice *io,
		      char *r_user, char *r_tty);
extern struct sockaddr_in *DMN_get_lookup_response(struct InputDevice *io);
extern int DMN_Announce(struct TalkContext *Ctxt, struct InputDevice *io,
		 char *r_user, char *r_tty);
extern void DMN_get_and_display(struct TalkContext *Ctxt,
				struct InputDevice *io);
extern int DMN_Delete(struct TalkContext *Ctxt, struct InputDevice *io,
		      enum DMN_deletion_type type);
extern int DMN_LeaveInvite(struct TalkContext *Ctxt, char *r_user, char *r_tty);
extern int DMN_Reply_Query(struct TalkContext *Ctxt, struct InputDevice *io);
extern int DMN_get_invite_response(struct InputDevice *io);
extern int DMN_get_announce_response(struct InputDevice *io);
extern int DMN_get_delete_response(struct InputDevice *io);
extern struct sockaddr_in *DMN_get_reply_query_response(struct InputDevice *io);
extern char *DMN_last_response(struct InputDevice *io);
extern int DMN_last_response_numeric(struct InputDevice *io);
extern int DMN_last_response_version(struct InputDevice *io);
extern char *DMN_last_response_user(struct InputDevice *io);
extern struct sockaddr_in *DMN_last_addr(struct InputDevice *io);

/* et_proto.c */
extern void PROTOCOL_connect(struct TalkContext *Ctxt, int userid, int sock,
		      char *user, char *node, char *tty);
extern void PROTOCOL_wait(struct TalkContext *Ctxt, int userid,
		   char *user, char *node, char *tty);
extern void PROTOCOL_reply(struct TalkContext *Ctxt);
extern void PROTOCOL_attach(struct TalkContext *Ctxt, int userid,
		     char *user, char *node, char *tty);
extern void PROTOCOL_delete_all(struct TalkContext *Ctxt, int terminate);
extern void PROTOCOL_abort(struct TalkContext *Ctxt);
extern int  PROTOCOL_test(struct TalkContext *Ctxt);
extern char *PROTOCOL_status(struct TalkContext *Ctxt);

/* et_strm.c */
extern void STREAM_local_read(struct TalkContext *Ctxt, struct InputDevice *io);
extern void STREAM_remote_read(struct TalkContext *Ctxt, struct InputDevice *io);

/* et_local.c */
extern void LOCAL_new_tcp(struct TalkContext *Ctxt, struct InputDevice *io);

/* et_user.c */
extern struct UserObject *USER_alloc();
extern struct UserObject *USER_find(int id);
extern struct UserObject *USER_iofind(struct InputDevice *io);
extern void USER_print();
extern void USER_hangup(struct TalkContext *Ctxt, int id);
extern void USER_clean();

/* et_rc.c */
extern void RC_load_all_hosts();
extern int RC_load_file(char *filename);

/* et_ring.c */
extern void ETR_read(struct TalkContext *Ctxt, struct InputDevice *dev);

#else /* PROTOTYPES */
/* etalk.c */
extern void  etalk_shutdown();

/* et_cmd.c */
extern void ETC_parse_command();
extern int ETC_test();

/* et_daemn.c */
extern void ET_reset_ids();
extern int DMN_Lookup();
extern struct sockaddr_in *DMN_get_lookup_response();
extern int DMN_Announce();
extern void DMN_get_and_display();
extern int DMN_Delete();
extern int DMN_LeaveInvite();
extern int DMN_Reply_Query();
extern int DMN_get_invite_response();
extern int DMN_get_announce_response();
extern int DMN_get_delete_response();
extern struct sockaddr_in *DMN_get_reply_query_response();
extern char *DMN_last_response();
extern int DMN_last_response_numeric();
extern int DMN_last_response_version();
extern char *DMN_last_response_user();
extern struct sockaddr_in *DMN_last_addr();

/* et_proto.c */
extern void PROTOCOL_connect();
extern void PROTOCOL_wait();
extern void PROTOCOL_reply();
extern void PROTOCOL_attach();
extern void PROTOCOL_delete_all();
extern void PROTOCOL_abort();
extern int  PROTOCOL_test();
extern char *PROTOCOL_status();

/* et_strm.c */
extern void STREAM_local_read();
extern void STREAM_remote_read();

/* et_local.c */
extern void LOCAL_new_tcp();

/* et_user.c */
extern struct UserObject *USER_alloc();
extern struct UserObject *USER_find();
extern struct UserObject *USER_iofind();
extern void USER_print();
extern void USER_hangup();
extern void USER_clean();

/* et_rc.c */
extern void RC_load_all_hosts();
extern int RC_load_file();

/* et_ring.c */
extern void ETR_read();

#endif /* PROTOTYPES */
#endif /* ETALK_ */
