.\"
.TH XPH 1 "Release 4" "X Version 11"
.SH NAME
xph \- X-window access to the Engineering White Pages Nameserver
.SH SYNOPSIS
.B xph
[-alias \fIalias\fP] [-server \fIhostname\fP] [-service \fIport\fP]
[-\fItoolkitoption...\fP]
.SH DESCRIPTION
.I xph
queries the College of Engineering White Pages Nameserver, a database
of Engineering faculty, students, and staff.  The database contains a
subset of the information in the
.I Student/Staff Directory
(the University phone book), as well as other information, including
electronic mail addresses.
.SH OPTIONS
.PP
\fIXph\fP accepts all of the standard toolkit command line options along
with three additional options:
.PP
.TP 8
.B \-alias
This option specifies the alias to use by default when logging into
the Nameserver.
.PP
.TP 8
.B \-server 
This option specifies the Internet hostname of the White Pages Nameserver,
which ordinarily is set by default.
.PP
.TP 8
.B \-service
This option specifies the port number or name to use on the server to
connect to the Nameserver.  This option is ordinarily set by default.
.PP
.SH OPERATION
.I Xph
presents a dialog panel with an editable field for queries,
various buttons to send or clear the query field, and a scrollable
output window for the results of the queries.  Buttons to the right of
the query dialog panel provide access to a field change mode, some
miscellaneous functions, and a limited help system.
.PP
To send a query, simply place the cursor inside the dialog panel
(labeled "Name to Query:") and type the text of your query.  The standard
Emacs-like line editing is available within the query field.
Once the query has been composed,
either press <RETURN> or click the "Send Query" button.  The ouput of
the query will be placed in the scrollable output window below.
.PP
To clear (erase) either the query field or output window, click the
appropriate button on the dialog panel.  To exit
.I xph,
click on the quit button at the bottom.
.PP
.SH QUERIES
The Nameserver's database containes many entries.
Each entry is comprised of multiple
.I fields,
each containing
information about the entry.  Each field has a name that is
descriptive of what the field contains; for example, the
field named
.I mail address
contains the office mail address of the person in question.
.PP
By default, queries are assumed to refer to the
.I name
field of the entry.  Therefore, querying for ``john doe'' looks for
entries whose name field contains ``john'' and ``doe.''
Fields other than the
.I name
field must be specified; for example
.PP
.RS
dorner address=DCL
.RE
.PP
would return entries with name ``dorner'' whose address contained ``DCL.''
.PP
Matching in
.I xph
is done on a word-by-word basis.  That is,
both the query and the entry are broken up into words, and
the individual words are compared.  Although
.I xph
is insensitive to case, it otherwise requires words to match exactly,
with no characters left over; ``john'' does not match ``johnson''
for example.  This behavior may be overriden by the
use of normal shell metacharacters (``?'' to match any single
character, ``*'' to match zero or more characters, and ``[]''
to match a single character from a set of characters).
.PP
.I Xph
will display only entries that match all of the specifications in the query.
For example,
.PP
.RS
steven dorner
.RE
.PP
will return all entries with both ``steven'' and ``dorner'' in the
.I name
field.
.PP
.I Xph
returns a certain set of fields by default.  It is possible to ask
for different fields in a query.  This is done by specifying the ``return''
keyword, and listing the
.I fields
of interest.  For example,
.PP
.RS
steven dorner return email
.RE
.PP
would print only the electronic mail address.  You may also ask for all
fields in the entry, by using ``all'' as a field name.  This will show
you every field you are allowed to see in the user's entry.
.PP
.SH CHANGE MODE
Users can change certain fields of their Nameserver entry by clicking
on the ``Change Mode'' button to the right of the query dialog panel.
If the user has not already logged in, the user will be prompted for
their login alias and password.  Contact your system administrator to
obtain an initial password.
.PP
Once logged in, a list of fields is presented in a separate window.
Only those fields that are changeable by the user are displayed.  By
default, only those changeable fields that are returned by default on
queries are listed.  To show all the changeable fields, click on the
``All Fields'' toggle button.
.PP
To display and possibly edit a field, simply click on the field name
in the list.  A description of the field and its value will be displayed.
You may edit the value of the field if you wish.  The typical Emacs-like
line-editing features are available.
.PP
Users should not stay logged in to the Nameserver unless they are actively
editing their entry.  To logout from the Nameserver, select the ``Logout''
menu item from the ``Misc'' menu button in the main window.
.PP
.SH CUSTOMIZATION
.I Xph
understands all of the core resource names and classes, although modifying
such resources may cause unpredictable behavior.  The following resources
can be specified safely:
.PP
.TP 8
.B alias
Specifies the login alias to use as default.
.TP 8
.B server
Specifies the Internet hostname of the Nameserver.
.TP 8
.B service
Specifies the port name/number to use on the Nameserver.
.PP
Class resources for foreground and background colors, as well as for
fonts may be changed, although a fixed font should be chosen for the
text widgets.  Some fonts may appear occluded; these font's should be
avoided.
.PP
.SH FILES
.PD 0
.TP 35
.B /usr/lib/X11/app-defaults/Xph
Application defaults
.TP
.B /usr/lib/X11/xph.help
Online help file
.PD
.PP
.SH BUGS
The password change dialog should require the current password, although
this is cumbersome after just logging in.  The dialog should detect this.
However, users should not remain logged in unless they are currently
editing their fields.  An autologout feature should be implemented.
Although maximum lengths of fields are understood by
.I xph,
no attempt is made to enforce these lengths.  The server simply truncates
such long field values.  The field edit panel only supports single-line
editing.
.PP
.SH SEE ALSO
ph(1)
.PP
.SH AUTHOR
Bradley C. Spatz, University of Florida, bcs@ufl.edu
