/* Copyright 1990 GROUPE BULL -- See licence conditions in file COPYRIGHT */
/* xpmP.h:
 *
 *  XPM
 *  Private Include file
 *  Developed by Arnaud Le Hors
 */

#ifndef XPMP_h
#define XPMP_h

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include<stdio.h>
#include "xpm.h"

/* we keep the same codes as for Bitmap management */
#ifndef _XUTIL_H_
#ifdef VMS
#include "decw$include:Xutil.h"
#else
#include <X11/Xutil.h>
#endif
#endif

#ifdef SYSV
#define bcopy(source, dest, count) memcpy(dest, source, count)
#endif

typedef struct {
    unsigned int type;
    union {
	FILE *file;
	char **data;
    } stream;
    char         *cptr;
    unsigned int line;
    int CommentLength;
    char Comment[BUFSIZ];
    char *Bcmt, *Ecmt, Bos, Eos;
} MData;

#define MARRAY 0
#define MFILE  1
#define MPIPE  2

typedef unsigned char  byte;      /* byte type */

#define EOL '\n'
#define TAB '\t'
#define SPC ' '

typedef struct {
    char *type;			/* key word */
    char *Bcmt;			/* string begining comments */
    char *Ecmt;			/* string ending comments */
    char  Bos;			/* character begining strings */
    char  Eos;			/* character ending strings */
    char *Strs;			/* strings separator */
    char *Dec;			/* data declaration string */
    char *Boa;			/* string begining assignment */
    char *Eoa;			/* string ending assignment */
} DataType;

extern DataType DataTypes[];

typedef struct {  /* rgb values and ascii names (from rgb text file) */
   int  r, g, b;  /* rgb values, range of 0 -> 65535 */
   char *name;    /* color mnemonic of rgb value */
} rgb_names;

/* Max number of rgb mnemonics allowed in rgb text file. */
#define MAX_RGBNAMES 1024

extern char *ColorKeys[];
#define NKEYS 5			/* number of ColorKeys */

#define MONO	2		/* key numbers for visual type, they must */
#define GRAY4	3		/* fit along with the number key of each */
#define GRAY 	4		/* corresponding element in ColorKeys[] */
#define COLOR	5		/* defined in xpm.h */


/* XPM private routines */
FUNC(CreatePixmap, int, (Display *display,
			 Visual *visual,
			 Drawable d,
			 Colormap colormap,
			 MData *data,
			 unsigned int depth,
			 Pixmap *pixmap_return,
			 unsigned int *width_return, 
			 unsigned int *height_return, 
			 Pixel **pixels_return,
			 unsigned int *npixels_return,
			 ColorSymbol *colorsymbols,
			 unsigned int numsymbols,
			 XpmInfo *infos));

FUNC(visualType, int, (Visual *visual));
FUNC(freeColorTable, int, (char ***colorTable, int ncolors));
FUNC(storePixel, int, (Pixel pixel, Pixel **pixels, unsigned int *indexsize, 
		       unsigned int *ncolors, unsigned int *index_return));

/* I/O utility */
FUNC(mnextstring, int, (MData *mdata));
FUNC(mnextui, unsigned int, (MData *mdata));
FUNC(mgetc, char, (MData *mdata));
FUNC(mungetc, char, (int c, MData *mdata));
FUNC(mnextc, char, (MData *mdata));
FUNC(mnextw, unsigned int, (MData *mdata, char *buf));
FUNC(mgetcmt, int, (MData *mdata, char **cmt));
FUNC(mreadopen, int, (char *filename, MData **mdataptr));
FUNC(mwriteopen, int, (char *filename, MData **mdataptr));
FUNC(mdataopen, int, (char **data, MData **mdataptr));
FUNC(mclose, int, (MData *mdata));

/* RGB utility */
FUNC(read_rgb_names, int, (char *rgb_fname, rgb_names *rgbn));
FUNC(get_color_name, char*, (rgb_names *rgbn, int rgbn_max, 
			     int red, int green, int blue));
FUNC(free_rgbn, void, (rgb_names *rgbn, int rgbn_max));

#endif
