/* fields.h -- data structures and constants for the field list.
 *
 * Copyright (C), 1992, Bradley C. Spatz, bcs@ufl.edu.
 * Last edited: Wed Apr 22 11:04:39 1992 by bcs (Bradley C. Spatz) on frenulum
 */

/* Describe a data structure to hold the list of fields returned by
 * the server.  We want the field names to be sorted alphabetically,
 * and we want to be able to find an entry in the list by name quickly,
 * so we opt for a simple binary tree.
 */
typedef struct _field_node {
   char               *name;
   int                max_length;
   char               *attr_str;
   int                attr_mask;
   char               *description;
   struct _field_node *left;
   struct _field_node *right;
} field_node_t;


/* The attributes comes as a string of 0 or more words delimited by
 * whitespace.  I forsee to need to be able to check for one or more
 * attributes (words) within an entry, and if we keep them as strings,
 * this will be an expensive operation.  So, I am going to bitcode them
 * for space/time performance.
 */
#define INDEXED  1
#define LOOKUP   2
#define PUBLIC   4
#define DEFAULT  8
#define CHANGE   16
#define ENCRYPT  32
#define NOPEOPLE 64


/* And some useful function prototypes. */
String *field_list();
field_node_t *find_entry();
