/* busy.c -- routines to provide a "busy" (XC_watch) cursor.
 *
 * Copyright (C) 1992, Bradley C. Spatz, bcs@ufl.edu
 * Last edited: Thu May 28 13:25:47 1992 by bcs (Bradley C. Spatz) on frenulum
 */

#include <X11/Xlib.h>
#include <X11/cursorfont.h>
#include <X11/Intrinsic.h>

#include "global.h"

static Window bc_win;

/* Apparently, olwm doesn't like (2^16)-1 for an unsigned int.  Ron
 * Rusnak (ronr@teddybear.uchicago.edu) reports the following works.
 * I don't really like Open Look.  Sun is doing it to themselves...
 */
#ifdef OLWM
#define WIDTH  30000
#define HEIGHT 30000
#else
#define WIDTH  65535
#define HEIGHT 65535
#endif


void init_busy_cursor()
{
   unsigned long valuemask;
   XSetWindowAttributes attributes;

   /* Ignore device events while the busy cursor is displayed. */
   valuemask = CWDontPropagate | CWCursor;
   attributes.do_not_propagate_mask =  (KeyPressMask | KeyReleaseMask |
					ButtonPressMask | ButtonReleaseMask |
					PointerMotionMask);
   attributes.cursor = XCreateFontCursor(XtDisplay(toplevel), XC_watch);
   
   /* The window will be as big as the display screen, and clipped by
    * its own parent window, so we never have to worry about resizing.
    */
   bc_win = XCreateWindow(XtDisplay(toplevel), XtWindow(toplevel), 0, 0,
			  WIDTH, HEIGHT, (unsigned int) 0, CopyFromParent,
			  InputOnly, CopyFromParent, valuemask, &attributes);
}


void busy_cursor()
{
   XMapRaised(XtDisplay(toplevel), bc_win);
}


void unbusy_cursor()
{
   XUnmapWindow(XtDisplay(toplevel), bc_win);
}



