/*---------------------------------------------------------------------------
Qi.h - Header file for Qi.m class.
-----------------------------------------------------------------------------*/
#define MAXSIZE 4096		/* Qi can return a buffer this big */

#include <stdio.h>

#import <objc/Object.h>

@interface Qi:Object
{
   id    statusPanel;           /* Status panel */
   id    msgTextField;		/* Status text field for status message */
   id    serverTextField;       /* Status text field for Server's name */

   id    fieldList;		/* List of QiField objects */
   id    delegate;		/* Current handler of the Qi server output */
   id    qiAnimator;		/* Qi animator object */
   
   BOOL  socketIO;		/* Has there been I/O sent since last check? */
   BOOL  debug;			/* Debugging enabled? */
   BOOL  hasQiFields;		/* Has the server sent all of the fields? */
   BOOL  hasClosed;		/* Did we close the server socket? */
   BOOL  isTimerRunning;        /* Is the Qi timer running? */
   char *server;		/* Server's name */
   int   nDefaults;		/* Number of "default" fields */
   BOOL  watchingFd;		/* Is the file descriptor being watched? */
   
   int   sock;			/* Socket file descriptor */

   char  errMsg[256];		/* Alert panel error message string */
   
   char  lineBuffer[MAXSIZE];	/* Data line from server */
   char  outputBuffer[MAXSIZE];	/* Output buffer from server */
}

- init;

- (BOOL)connectTo:(const char *)aServer;
- (BOOL)openSocket;

- qiSend:(const char *)aCommand delegate:aDelegate;
- qiOutput:(char *)aBuf;

- debugOut:(const char *)aLine toQi:(BOOL)aCommand;

- closeFiles:sender;
- startFd:aDelegate;
- stopFd:sender;
- quit;

- qiTimeCheck;
- startQiTimer:sender;
- stopQiTimer:sender;

- hideStatusPanel:sender;
- showStatusPanel:(const char *)aString server:(const char *)aServer;

- fieldList;
- (BOOL)hasQiFields;
- (BOOL)hasClosed;
- (const char *)server;

@end
