/*---------------------------------------------------------------------------
Prefs.m -- Copyright (c) 1991 Rex Pruess

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA, or send
   electronic mail to the the author.

Preferences allows the user to tailor Ph.  The user must use this at
least once to set the default server name.

Rex Pruess <Rex-Pruess@uiowa.edu>

$Header: /rpruess/apps/Ph/info.subproj/RCS/Prefs.m,v 2.2 92/04/27 13:55:34 rpruess Exp $
-----------------------------------------------------------------------------
$Log:	Prefs.m,v $
Revision 2.2  92/04/27  13:55:34  rpruess
Added new options to allow the enabling/disabling of Services menu items.

Revision 2.1  91/12/10  16:24:50  rpruess
Added code to support the "hide on auto-launch" and "hide default query"
preference options.  This code was added prior to sending the first
production release to the archive sites.  So, the RCS revision numbers
do NOT necessarily match the Ph Version numbers.

Revision 2.0  91/11/18  17:50:14  rpruess
Revision 2.0 is the initial production release of Ph.

-----------------------------------------------------------------------------*/

#define SERVMENUTITLE "Query Ph"

#define COURIER 1
#define OHLFS 2

#define DEBUGTAG 0
#define HIDELAUNCHTAG 1
#define HIDEQUERYTAG 2
#define WRAPTAG 3

#include <strings.h>

#import <appkit/Application.h>
#import <appkit/defaults.h>
#import <appkit/Form.h>
#import <appkit/Listener.h>
#import <appkit/Matrix.h>
#import <appkit/nextstd.h>
#import <appkit/Window.h>

#import "Prefs.h"
#import "../PhShare.h"
#import "../qiServers.h"

@implementation Prefs

/*---------------------------------------------------------------------------
When Preferences is first created, we load the nib file & init the fields.
-----------------------------------------------------------------------------*/
- init
{
   [super init];

   [NXApp loadNibSection:"Prefs.nib" owner:self withNames:NO];

   [self setFields:self];
   [serverTextField selectText:self];
   
   return self;
}

/*---------------------------------------------------------------------------
The Ph object calls this method.  The ID is neeeded so we can tell it to
fetch the other CSO nameservers from the default nameserver.
-----------------------------------------------------------------------------*/
- setServers:anObject
{
   servers = anObject;
   return self;
}

/*---------------------------------------------------------------------------
Get the Ph defaults and initialize the Preferences window accordingly.
-----------------------------------------------------------------------------*/
- setFields:sender
{
   const char     *string;

   /*** Set the default server field */

   string = NXGetDefaultValue ([NXApp appName], DEFAULTSERVER);
   [serverTextField setStringValue:string];
   
   /*** Set font marix value */

   string = NXGetDefaultValue ([NXApp appName], FONT);
   if (strcmp (string, "Courier") == 0)
      [fontMat selectCellWithTag:COURIER];
   else
      [fontMat selectCellWithTag:OHLFS];

   /*** Set font size value */

   string = NXGetDefaultValue ([NXApp appName], FONTSIZE);
   if (string != NULL)
      [fontSizeForm setStringValue:string];
   else
      [fontSizeForm setStringValue:""];

   /*** Set debug switch value */

   string = NXGetDefaultValue ([NXApp appName], DEBUG);
   if (strcmp (string, "YES") == 0)
      [[optionsMat findCellWithTag:DEBUGTAG] setIntValue:YES];
   else
      [[optionsMat findCellWithTag:DEBUGTAG] setIntValue:NO];

   /*** Set "hide on auto-launch" switch value */

   string = NXGetDefaultValue ([NXApp appName], HIDELAUNCH);
   if (strcmp (string, "YES") == 0)
      [[optionsMat findCellWithTag:HIDELAUNCHTAG] setIntValue:YES];
   else
      [[optionsMat findCellWithTag:HIDELAUNCHTAG] setIntValue:NO];

   /*** Set "hide default query" switch value */

   string = NXGetDefaultValue ([NXApp appName], HIDEQUERY);
   if (strcmp (string, "YES") == 0)
      [[optionsMat findCellWithTag:HIDEQUERYTAG] setIntValue:YES];
   else
      [[optionsMat findCellWithTag:HIDEQUERYTAG] setIntValue:NO];

   /*** Set wrap lines switch value */

   string = NXGetDefaultValue ([NXApp appName], WRAPLINES);
   if (strcmp (string, "YES") == 0)
      [[optionsMat findCellWithTag:WRAPTAG] setIntValue:YES];
   else
      [[optionsMat findCellWithTag:WRAPTAG] setIntValue:NO];

   /*** Set services switches */
   [servicesMat sendAction:(SEL) @selector (setServices:) to:self forAllCells:YES];
   
   return self;
}

/*---------------------------------------------------------------------------
Set the switch state based on whether or not the service is enabled.
-----------------------------------------------------------------------------*/
- setServices:sender
{
   char           *menuItem;

   menuItem = malloc (sizeof (SERVMENUTITLE) + 1 + strlen ([sender title]));
   sprintf (menuItem, "%s/%s", SERVMENUTITLE, [sender title]);
   
   [sender setIntValue:NXIsServicesMenuItemEnabled (menuItem) ? YES : NO];

   free (menuItem);
   
   return (id) YES;
}

/*---------------------------------------------------------------------------
Revert all the fields to the default values.
-----------------------------------------------------------------------------*/
- revert:sender
{
   [self setFields:self];
   return self;
}

/*---------------------------------------------------------------------------
Write all the current values to the defaults data base.  Just in case there
is nothing running yet, start the default server.
-----------------------------------------------------------------------------*/
- writePrefs:sender
{
   int             col;
   int             columns;
   char           *menuItem;
   int             row;
   int             rows;
   char            string[10];
   
   /*** Set the DEFAULTSERVER & FONTSIZE variables. */
   
   NXWriteDefault ([NXApp appName], DEFAULTSERVER, [serverTextField stringValue]);
   NXWriteDefault ([NXApp appName], FONTSIZE, [fontSizeForm stringValue]);

   /*** Set the FONT variable. */

   if ([[fontMat selectedCell] tag] == COURIER)
      strcpy (string, "Courier");
   else
      strcpy (string, "Ohlfs");
   
   NXWriteDefault ([NXApp appName], FONT, string);

   /*** Set the DEBUG variable. */

   if ([[optionsMat findCellWithTag:DEBUGTAG] intValue] == YES)
      strcpy (string, "YES");
   else
      strcpy (string, "NO");

   NXWriteDefault ([NXApp appName], DEBUG, string);

   /*** Set the HIDELAUNCH variable. */

   if ([[optionsMat findCellWithTag:HIDELAUNCHTAG] intValue] == YES)
      strcpy (string, "YES");
   else
      strcpy (string, "NO");

   NXWriteDefault ([NXApp appName], HIDELAUNCH, string);

   /*** Set the HIDEQUERY variable. */

   if ([[optionsMat findCellWithTag:HIDEQUERYTAG] intValue] == YES)
      strcpy (string, "YES");
   else
      strcpy (string, "NO");

   NXWriteDefault ([NXApp appName], HIDEQUERY, string);

   /*** Set the WRAPLINES variable. */

   if ([[optionsMat findCellWithTag:WRAPTAG] intValue] == YES)
      strcpy (string, "YES");
   else
      strcpy (string, "NO");

   NXWriteDefault ([NXApp appName], WRAPLINES, string);

   /*** Enable/disable Services based on the servicesMat values. */

   [servicesMat getNumRows:&rows numCols:&columns];

   for (col = 0; col < columns; col++) {

      for (row = 0; row < rows; row++) {

	 menuItem = malloc (sizeof (SERVMENUTITLE) + 1 + strlen ([[servicesMat cellAt:row :col] title]));
         sprintf (menuItem, "%s/%s", SERVMENUTITLE, [[servicesMat cellAt:row :col] title]);
   
	 NXSetServicesMenuItemEnabled (menuItem, [[servicesMat cellAt:row :col] intValue]);

	 free (menuItem);
      }
   }
 
   /*** If this is the user's first run, then we will have to get the
        servers from the newly set default. */

   if ([servers hasServers] == NO)
      [servers fetchServers:[serverTextField stringValue]];
   
   return self;
}

/*---------------------------------------------------------------------------
Show 'em the Preferences window.
-----------------------------------------------------------------------------*/
- showPrefsWindow:sender
{
   [prefsWindow makeKeyAndOrderFront:self];
   return self;
}

@end
