/* password.c -- routines to change a user's password.
 *
 * Copyright (C) 1992, Bradley C. Spatz, bcs@ufl.edu
 * Last edited: Wed Apr 22 11:05:18 1992 by bcs (Bradley C. Spatz) on frenulum
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Toggle.h>

#include "replies.h"
#include "global.h"


/* These popup widgets are global because once created, we save them,
 * and map tham again if the user asks for them.
 */
static Widget password_popup=NULL;
static Widget phelp_popup=NULL;

/* Prototype some functions. */
void ok(), password_help();

/* We need these global for the Ok callback processing. */
static Widget p1text, p2text;

#define PSW_WIDTH 150

#define CARET TRUE

void change_password(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
    Widget	pform, p0label, p0text;
    Widget      p1label, p2label, pok, pcancel, phelp;
    Position	x, y;
    Dimension	width, height;

    if (read_only) {
       XawAsciiSaveTextPosition(text);
       XawAsciiAppend(text, "Database is read-only.\n\n");
       XawAsciiRestoreTextPosition(text);
       return;
    }

    /* If the widget already exists, great; just pop it back up.
     * Otherwise, create it first.
     */
    if (password_popup == NULL) {
       password_popup = XtVaCreatePopupShell("xph_password",
					     transientShellWidgetClass,
					     widget,
					     XtNtitle, "Xph Password",
					     XtNiconPixmap, icon_pixmap, NULL);

       pform = XtCreateManagedWidget("pform", formWidgetClass, password_popup,
				     NULL, ZERO);
       p1label = XtCreateManagedWidget("p1label", labelWidgetClass, pform,
				       NULL, ZERO);
       p1text = XtVaCreateManagedWidget("p1text", asciiTextWidgetClass, pform,
					XtNwidth, PSW_WIDTH,
					XtNdisplayCaret, CARET, NULL);
       p2label = XtCreateManagedWidget("p2label", labelWidgetClass, pform,
				       NULL, ZERO);
       p2text = XtVaCreateManagedWidget("p2text", asciiTextWidgetClass, pform,
					XtNwidth, PSW_WIDTH,
					XtNdisplayCaret, CARET, NULL);
       
       pok = XtCreateManagedWidget("pok", commandWidgetClass, pform, NULL,
				   ZERO);
       XtAddCallback(pok, XtNcallback, ok, (XtPointer) pform);
       pcancel = XtCreateManagedWidget("pcancel", commandWidgetClass, pform,
				       NULL, ZERO);
       XtAddCallback(pcancel, XtNcallback, pop_down_widget, (XtPointer) pform);
       phelp = XtCreateManagedWidget("phelp", commandWidgetClass, pform, NULL,
				     ZERO);
       XtAddCallback(phelp, XtNcallback, password_help, (XtPointer) pform);
    }

    /* Position the widget. */
    XtVaGetValues(widget, XtNwidth, &width, XtNheight, &height, NULL);
    XtTranslateCoords(widget, (Position) (width / 2),
		      (Position) (height / 2), &x, &y);
    XtVaSetValues(password_popup, XtNx, x, XtNy, y-width, NULL);

    XtPopup(password_popup, XtGrabExclusive);
}


static void
ok(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
   String password, verification;

   /* Get the new passsword and its verification. */
   XtVaGetValues(p1text, XtNstring, &password, NULL);
   XtVaGetValues(p2text, XtNstring, &verification, NULL);
   
   if ((strcmp(password, "") == 0) || (strcmp(verification, "") == 0) ||
       (strcmp(password, verification) != 0)) {
      XawAsciiSaveTextPosition(text);
      XawAsciiAppend(text,
         "Password and verification do not match or are null.\n\n");
      XawAsciiSaveTextPosition(text);
   }
   else {
      /* Ok.  The passwords matched.  Encrypt the password and send it
       * to the server.
       */
      encryptit(response, password);
      if (edit_field(login_alias, "password", response)) {
	 /* Remember the new password. */
	 strcpy(login_password, password);
      }
   }

   /* Erase the passwords from the change panel. */
   XtVaSetValues(p1text, XtNstring, "", NULL);
   XtVaSetValues(p2text, XtNstring, "", NULL);
   
   pop_down_widget((Widget) widget, (XtPointer) client_data, (XtPointer) NULL);
}



#define PHELP_WIDTH  310
#define PHELP_HEIGHT 120

static String phelp_text =
"Password Change Help\n\n\
Enter your desired new password\n\
twice; they must match for any\n\
change to take place.\n\n\
No characters will be seen when\n\
entering the passwords, for\n\
obvious security reasons.\n\n";

static void
password_help(widget, client_data, call_data)
Widget	widget;		
XtPointer client_data, call_data;
{
    Widget	hform, htext, hdismiss;
    Position	x, y;
    Dimension	width, height;

    if (phelp_popup == NULL) {
       phelp_popup = XtVaCreatePopupShell("Password_Help",
					  transientShellWidgetClass, widget,
					  XtNtitle, "Xph Password Help",
					  XtNiconPixmap, icon_pixmap, NULL);

       /* Create a form with a text widget and a dismiss button. */
       hform = XtCreateManagedWidget("hform", formWidgetClass, phelp_popup,
				     NULL, ZERO);

       htext = XtVaCreateManagedWidget("htext", asciiTextWidgetClass, hform,
				       XtNwidth, PHELP_WIDTH,
				       XtNheight, PHELP_HEIGHT,
				       XtNdisplayCaret, FALSE,
				       XtNstring, phelp_text, NULL);
       hdismiss = XtCreateManagedWidget("hdismiss", commandWidgetClass, hform,
					NULL, ZERO);
       XtAddCallback(hdismiss, XtNcallback, pop_down_widget,
		     (XtPointer) hform);

#if 0
       /* Add to the help text: query the server for
	* contact for passwords, ignoring the first few lines from "siteinfo".
	* However, we can't guarantee the server will provide this
	* information in the following format.
	*/
       write_ns("siteinfo\n");
       read_ns(buf);
       read_ns(buf);
       read_ns(buf);
       read_ns(buf);
       sprintf(reply, "To secure a password, contact:\n   %s\n",
	       word(buf, ':', 3));
       XawAsciiAppend(htext, reply);
       read_ns(buf);  /* The OK message. */
#endif
    }

    /* Position the login help widget.*/
    XtVaGetValues(widget, XtNwidth, &width, XtNheight, &height, NULL);
    XtTranslateCoords(widget, (Position) (width / 2),
		      (Position) (height / 2), &x, &y);
    XtVaSetValues(phelp_popup, XtNx, x-PHELP_WIDTH,
		  XtNy, y-PHELP_HEIGHT, NULL);

    XtPopup(phelp_popup, XtGrabExclusive);
}
