/* Copyright 1990 GROUPE BULL -- See licence conditions in file COPYRIGHT */
/* free.c:
 *
 *  XPM
 *  Free utility for XPM file format
 *  Developed by Arnaud Le Hors
 */

#include "xpmP.h"

freeColorTable(colorTable, ncolors)
char ***colorTable;
int ncolors;
{ int a, b;
  if (colorTable) {
      for (a = 0; a < ncolors; a++)
	  if (colorTable[a]) {
	      for (b = 0; b < (NKEYS + 1); b++)
		  if (colorTable[a][b])
		      free(colorTable[a][b]);
	      free(colorTable[a]);
	  }
      free(colorTable);
  }
}

XFreeXpmInfo(infos)
XpmInfo *infos;
{
    if (infos) {
	if (infos->type) { free(infos->type); infos->type = NULL; }
	if (infos->colorTable) {
	    freeColorTable(infos->colorTable, infos->ncolors);
	    infos->colorTable = NULL; }
	if (infos->hints_cmt) { free(infos->hints_cmt);
				infos->hints_cmt = NULL; }
	if (infos->colors_cmt) { free(infos->colors_cmt);
				 infos->colors_cmt = NULL; }
	if (infos->pixels_cmt) { free(infos->pixels_cmt);
				 infos->pixels_cmt = NULL; }
	if (infos->pixels) { free(infos->pixels); infos->pixels = NULL; }
    }
}
