/*
 * xutil.c : Miscellaneous X functions
 *
 * George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
 */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/Xaw/Text.h>
#include <X11/StringDefs.h>

/*
 * Functions defined here:
 */
void setWidgetString();
void setWidgetLabel();
char *getWidgetString();
void appendWidgetText();

/*	-	-	-	-	-	-	-	-	*/

/*
 * setWidgetString() : Set the given Text item's value to the given string.
 */
void
setWidgetString(w,str)
Widget w;
char *str;
{
    Arg args[1];

    if (w != NULL && str != NULL) {
	XtSetArg(args[0],XtNstring,str);
	XtSetValues(w,args,1);
    }
}

/*
 * setWidgetLabel() : Set the given Label item's label to the given string.
 */
void
setWidgetLabel(w,str)
Widget w;
char *str;
{
    Arg args[1];

    if (w != NULL && str != NULL) {
	XtSetArg(args[0],XtNlabel,str);
	XtSetValues(w,args,1);
    }
}

/*	-	-	-	-	-	-	-	-	*/

char *
getWidgetString(widget)
Widget widget;
{
    Arg args[1];
    char *s;

    XtSetArg(args[0],XtNstring,&s);
    XtGetValues(widget,args,1);
    return(s);
}

char *
getWidgetLabel(widget)
Widget widget;
{
    Arg args[1];
    char *s;

    XtSetArg(args[0],XtNlabel,&s);
    XtGetValues(widget,args,1);
    return(s);
}

/*	-	-	-	-	-	-	-	-	*/
/* Improved by Tim Auckland <tda10@cus.cam.ac.uk> */

void
appendWidgetText(w,text)
Widget w;
char *text;
{
    XawTextBlock block;
    XawTextPosition pos;
    XawTextEditType saved;
    Arg args[1];

    if ((block.length=strlen(text)) == 0)
	return;
    block.firstPos = 0;
    block.format = FMT8BIT;
    block.ptr = text;
    XtCallActionProc(w,"end-of-file",NULL,NULL,0);
    pos = XawTextGetInsertionPoint(w);
    XtSetArg(args[0],XtNeditType,&saved);
    XtGetValues(w,args,1);
    XtSetArg(args[0],XtNeditType,XawtextAppend);
    XtSetValues(w,args,1);
    switch (XawTextReplace(w,pos,pos,&block)) {
	case XawPositionError:
	    fprintf(stderr,"XawPositionError: `%s'\n",block.ptr);
	    break;
	case XawEditError:
	    fprintf(stderr,"XawEditError: `%s'\n",block.ptr);
	    break;
    }
    XtSetArg(args[0],XtNeditType,saved);
    XtSetValues(w,args,1);
    XtCallActionProc(w,"end-of-file",NULL,NULL,0);
}
