#!/bin/sh
#
# help-text1.sh : Convert xarchie manpage into Help strings.
#
# To avoid long strings, the text is broken into one C string
# per line of formatted text.
#
# George Ferguson, ferguson@cs.rochester.edu, 23 Apr 1993.
#
# The commands below perform the following steps:
# - Indicate Help formatting
# - Send manpage...
# - ...through nroff
# - Remove underlining (sed has no nice way of specifying backspace)
# - Collapse blank lines
# - Escape "real" quotes then add string quotes
# - Put a NULL entry after each topic

echo '.nr XX 1' |\
cat - xarchie.man |\
nroff -man |\
ul -t dumb |\
uniq |\
sed -e 's/"/\\"/g' -e 's/^\(.*\)$/"\1\\n",/' |\
sed 's/^\("..[^ "]\)/NULL,\
\1/'
