#import <objc/Object.h>
#import  <sys/dir.h>
#import <sys/param.h>

@interface MyOpenPanel:Object
{
	id browser;			// Files browser
	id okButton;			// Ok button
	id iconBtn;			// App icon
	id form;				// Form displaying current selection
	id panel;				// The panel
	id panelTitle;		// Title of panel
	char pathName[MAXPATHLEN];		// Full pathname of directory/file
	int dirLevel;			// The number of levels directory is below root
	int fileCount;			// The number of files in the last directory
	struct direct **nameList[32];	// List of file names in directories
	int nameCount[32];	// Number of files in nameList
	BOOL dirFlag;		// Indicates wether directories are to be selected
	BOOL isDirectory;	// Indicates wether the last selected path was a directory
}

/* User interfacing methods */
- setTitle: (char *) theTitle;
- (int) runModal: (BOOL) selectDirs;
- (int) runModal: (char *) directory :(BOOL) selectDirs;
- (const char *) pathName;

/* Panel action methods */
- goHome: sender;
- cancel: sender;
- ok: sender;

/* Private methods */
- getSelectionPath;
- doubleClick;

@end
