/* Copyright (c) 1995,1996 NEC Corporation.  All rights reserved.            */
/*                                                                           */
/* The redistribution, use and modification in source or binary forms of     */
/* this software is subject to the conditions set forth in the copyright     */
/* document ("COPYRIGHT") included with this distribution.                   */

/* This program illustrate how to create a pipe (unix domain socket) for     */
/* serving the prompts from the Socks5 library. Since the socks5 library     */
/* does not know the way you want to typing a requested information, such    */
/* as one time password, it writes the request to a pipe. This password      */
/* server will read from the pipe, and let the user to type in the pass-     */
/* word. Part of the code can be used by a GUI program.                      */

#include "socks5p.h"	/* headers files   */
#include "cram.h"	/* for server path */
#include "log.h"	/* for S5Log API   */
#include "protocol.h"	/* for lsEffUser   */
#include "msg.h"	/* for S5IO flags  */

/* the path used by Challenge/Response Auth. Method, defined in lib/cram.c   */
extern char *CRAM_PIPE_SERVER_PATH;
#define MAX_SKEY_LINE 100

#define my_exit(function) {S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(0),\
				0, function " failed: %m");\
				exit(1); }

void main(int argc, char **argv) {
    struct sockaddr_un s_un;
    S5IOHandle sockfd, fd;
    int len;
    char buffer[MAX_SKEY_LINE];
    int so_reuse=1;
    FILE *fp;
    char *cp;

    signal(SIGPIPE, SIG_IGN);
    S5LogStart(&S5LogDefaultHandle, S5_LOG_LOCAL, S5_LOG_DEBUG_MAX, argv[0]);

    if ((sockfd = socket(AF_UNIX, SOCK_STREAM, 0)) < 0) 
	my_exit("socket");

    s_un.sun_family = AF_UNIX;
    strcpy(s_un.sun_path, CRAM_PIPE_SERVER_PATH);
    strcat(s_un.sun_path, ".");
    strcat(s_un.sun_path, lsEffUser());

    /* in case it already exists, remove it */
    unlink(s_un.sun_path);
#ifdef HAVE_SOCKADDR_SUN_LEN
    len=sizeof(s_un.sun_len) + 1 +
	strlen(s_un.sun_path) + sizeof(s_un.sun_family);
    s_un.sun_len = len;
#else
    len=strlen(s_un.sun_path) + sizeof(s_un.sun_family);
#endif

    setsockopt(sockfd,SOL_SOCKET,SO_REUSEADDR,(char*)&so_reuse,sizeof(so_reuse));
    if (bind(sockfd, (struct sockaddr *)&s_un, len) < 0)
	my_exit("bind");
    if (chmod(s_un.sun_path, S_IRWXU))	/* rwx for user only */
	my_exit("chmod");
    if (listen(sockfd, 1) < 0)
	my_exit("listen");

    for (;;) {
	if ((fd=accept(sockfd, NULL, 0)) < 0)
		my_exit("accept");

	fp=fdopen(fd,"r+");
	setvbuf(fp, NULL, _IONBF, 0);
	/* get a prompt */
	if (fgets(buffer, MAX_SKEY_LINE, fp) == NULL)
	    S5LogUpdate(S5LogDefaultHandle, S5_LOG_DEBUG(0), 0, "read error: %m");
	else {
    	    if ((cp = strchr(buffer, '\n')))
		*cp = 0;

	    /* substitute the following lines with GUI */
	    if (strstr(buffer,"password")) {
		if ((cp = getpass(buffer))) {
		    strncpy(buffer, cp, sizeof(buffer));
		    cp = buffer + strlen(buffer);
		    *cp++ = '\n';
		    *cp = '\0';
		}
	    } else {
		printf("%s ", buffer);
		fgets(buffer, MAX_SKEY_LINE, stdin);
	    }

	    /* send back, fprintf(fp, "%s", buffer) won't work for all platforms */
	    if (S5IOSend(fd, NULL, buffer, strlen(buffer), 0, S5_IOFLAGS_RESTART|S5_IOFLAGS_NBYTES, NULL) < 0) break;

	    /* clean up */
	    memset(buffer, 0, sizeof(buffer));
	}
	fclose(fp);
    }
}

