/* sc_text.c
   gopher item subclass procedures for text */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#include "conf.h"
#include "osdep.h"
#include "globals.h"
#include "gopher.h"
#include "util.h"
#include "status.h"
#include "appres.h"
#include "text.h"
#include "sc_text.h"
#include "sc_textP.h"



/* getFile
   access the Ascii text file as required by the selected item */

static BOOLEAN
getFile(gi, indexString)
gopherItemP	gi;
char		*indexString;
{
	char		errorString[MESSAGE_STRING_LEN];
	char		tempName[PATH_NAME_LEN];
	int		tempFD;
	BOOLEAN		okSoFar;
	
	getTempFile(tempName);
	if ((tempFD = open(tempName, O_WRONLY | O_CREAT, TMP_FILE_MODE)) < 0) {
		perror("getFile");
		sprintf(errorString,
			"Cannot open the temporary file %s", tempName);
		showError(errorString);
		fprintf (stderr, "%s\n", errorString);
		return FALSE;
	}


	okSoFar = GI_copyFromNet(tempFD, gi, "Getting text for display");

	close(tempFD);

	/* check for cancel */

	if (! okSoFar ) {
		unlink(tempName);
		return FALSE;
	}


	showFile(gi, USER_STRING(gi), tempName, indexString);

	return TRUE;

}


/* GIText_init
   initialize text file class - host access list and prefix. */

void
GIText_init()
{
	GU_makePrefix(prefixText,  appResources->prefixFile);
	textHostList = GU_createAccessList(appResources->textServers);
	GU_registerNewType(A_FILE, &textSubclass);

	return;
}


/* GIText_done
   done with text file class - get rid of leftover temp files. */

void
GIText_done()
{
	cleanUpTextProc();

	return;
}


/* GIText_init
   restarts text file class - remove popups and get rid of temp files. */

void
GIText_restart()
{
	removeAllText();
	cleanUpTextProc();

	return;
}


/* GIText_access
   check the accessability of a text file selection */

BOOLEAN
GIText_access(gi)
gopherItemP	gi;
{
	BOOLEAN	result;

	if (textHostList == NULL  ||  GU_checkAccess(gi->host, textHostList)) {
		result = TRUE;
	}else {
		result = FALSE;
	}

	return result;
}


/* GIText_process
   process a text file selection */

BOOLEAN
GIText_process(gi)
gopherItemP	gi;
{
	BOOLEAN	result;

	result = getFile(gi, getCurrentDirIndex());

	return result;
}
