/* sc_cso.c
   gopher item subclass procedures for cso name server */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#include "conf.h"
#include "globals.h"
#include "gopher.h"
#include "util.h"
#include "status.h"
#include "appres.h"
#include "sc_cso.h"
#include "sc_csoP.h"



/* giveCsoNameServer
   provide access to a CSO name server */

static BOOLEAN
giveCsoNameServer(gi)
gopherItemP	gi;
{
	int		s;
	
#ifndef TEST_CSO
	if (( s = GI_connectWithStatus(gi) ) < 0 ) return FALSE;
#endif	/* TEST_CSO */

	showStatus("Starting name server", STAT_PROCESS,
			 gi->host, gi->port);

	showNameServer(USER_STRING(gi), s);

	(void) removeStatusPanel();

	/* important: descriptor s will be closed by the name server
	   panel when it is done.  This will allow that panel to be
	   left up and operate asychronously with the rest of xgopher. */

	return TRUE;
}


/* GICso_init
   initialize CSO name server class - prefix string */

void
GICso_init()
{
	GU_makePrefix(prefixCSO,  appResources->prefixCSO);
	GU_registerNewType(A_CSO, &csoSubclass);

	return;
}


/* GICso_process
   process a cso name server selection.  Display the name server panel.
   Since the panel can operate independent and asynchronous of the rest
   of xgopher, no special grabs are used. */

BOOLEAN
GICso_process(gi)
gopherItemP	gi;
{
	BOOLEAN	result;
	result = giveCsoNameServer(gi);

	return result;
}


/* GICso_restart
   process restart request for class; pop down cso name server panel. */

void
GICso_restart()
{
	removeCsoPanel();
	return;
}
