/*		Telnet Acees, Roligin, etc			HTAccess.c
**		==========================
**
** Authors
**	TBL	Tim Berners-Lee timbl@info.cern.ch
**	JFG	Jean-Francois Groff jgh@next.com
**	DD	Denis DeLaRoca (310) 825-4580  <CSP1DWD@mvs.oac.ucla.edu>
** History
**       8 Jun 92 Telnet hopping prohibited as telnet is not secure (TBL)
**	26 Jun 92 When over DECnet, suppressed FTP, Gopher and News. (JFG)
**	 6 Oct 92 Moved HTClientHost and logfile into here. (TBL)
**	17 Dec 92 Tn3270 added, bug fix. (DD)
**	 2 Feb 93 Split from HTAccess.c. Registration.(TBL)
*/

/* Implements:
*/
#include "HTTelnet.h"

#include "HTParse.h"
#include "HTUtils.h"
#include "HTAnchor.h"
#include "HTTP.h"
#include "HTFile.h"
#include <errno.h>
#include <stdio.h>

#include "tcp.h"
#include "HText.h"

#include "HTAccess.h"
#include "HTAlert.h"

extern void application_user_feedback (char *);

/*	Telnet or "rlogin" access
**	-------------------------
*/
PRIVATE int remote_session ARGS2(char *, access, char *, host)
{
  char *user, *hostname, *port;
  char command[256];
  char *xterm_str;
  enum _login_protocol { telnet, rlogin, tn3270 } login_protocol;
  extern char *global_xterm_str;

  if (!access || !host)
    {
      application_user_feedback 
        ("Cannot open remote session, because\nURL is malformed.\0");
      return HT_NO_DATA;
    }

  login_protocol =
    strcmp(access, "rlogin") == 0 ? rlogin :
      strcmp(access, "tn3270") == 0 ? tn3270 : 
        telnet;
  
  user = host;
  hostname = strchr(host, '@');
  port = strchr(host, ':');
  
  if (hostname) 
    {
      *hostname++ = 0;	/* Split */
    } 
  else 
    {
      hostname = host;
      user = 0;		/* No user specified */
    }
  if (port) 
    *port++ = 0;	/* Split */
  
  xterm_str = global_xterm_str;
  
  if (login_protocol == rlogin)
    {
      /* For rlogin, we should use -l user. */
      sprintf(command, "%s -e %s %s %s %s %s &", xterm_str, access,
              hostname,
              port ? port : "",
              user ? "-l" : "",
              user ? user : "");
    }
  else
    {
      /* For telnet, -l isn't safe to use at all -- most platforms
         don't understand it. */
      sprintf(command, "%s -e %s %s %s &", xterm_str, access,
              hostname,
              port ? port : "");
    }
  
  if (TRACE) fprintf(stderr, "HTaccess: Command is: %s\n", command);
  system(command);
  
  /* No need for application feedback if we're rlogging directly
     in... */
  if (user && login_protocol != rlogin)
    {
      char str[200];
      /* Sleep to let the xterm get up first.
         Otherwise, the popup will get buried. */
      sleep (2);
      sprintf (str, "When you are connected, log in as '%s'.\0", user);
      application_user_feedback (str);
    }
  
  return HT_NO_DATA;		/* Ok - it was done but no data */
}

/*	"Load a document" -- establishes a session
**	------------------------------------------
**
** On entry,
**	addr		must point to the fully qualified hypertext reference.
**
** On exit,
**	returns		<0	Error has occured.
**			>=0	Value of file descriptor or socket to be used
**				 to read data.
**	*pFormat	Set to the format of the file, if known.
**			(See WWW.h)
**
*/
PRIVATE int HTLoadTelnet
ARGS4
(
 CONST char *,		addr,
 HTParentAnchor *,	anchor,
 HTFormat,		format_out,
 HTStream *,		sink			/* Ignored */
)
{
    char * access;
    
    char * host;
    int status;
    
    if (sink) 
      {
        HTAlert("Can't output a live session -- it has to be interactive");
	return HT_NO_ACCESS;
      }
    access =  HTParse(addr, "file:", PARSE_ACCESS);
    
    host = HTParse(addr, "", PARSE_HOST);
    status = remote_session(access, host);

    free(host);	
    free(access);
    return status;
}


PUBLIC HTProtocol HTTelnet = { "telnet", HTLoadTelnet, NULL };
PUBLIC HTProtocol HTRlogin = { "rlogin", HTLoadTelnet, NULL };
PUBLIC HTProtocol HTTn3270 = { "tn3270", HTLoadTelnet, NULL };


