/*
     fc - Filter compiler software for the Drawbridge package
     Copyright (C) 1993 David K. Hess, Douglas Lee Schales, David R. Safford

     Please see the file `COPYING' for the complete copyright notice.
*/
#ifndef __SERVICES_H__
#define __SERVICES_H__

#include "protocols.h"

struct service {
     int start;
     int end;
     int protocol;
};

extern struct filt_protocols *fp_head;

extern void init_services(void);
extern void remove_deny(inout, srcdst);
extern void destroy_services(struct port_range *);
extern void destroy_all_services(void);
extern void add_service(struct service, inout, srcdst, accrej);
extern void push_service(struct service, inout, srcdst, accrej);
extern void push2_service(struct service, int, srcdst, accrej);

#endif
