/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

/*
 * Mem types to be managed
 */
#define OMEM_ADV800	1
#define OMEM_ADV128	2
#define OMEM_ADV64	3
#define OMEM_ADV36	6
#define OMEM_ADV	1
#define OMEM_RTRHDR	1		/* adv */
#define OMEM_NETHDR	1
#define OMEM_NBR	4		/* for nbr struct */
#define OMEM_DBGUTS	5		/* for dbguts part of lsdb entry */
#define OMEM_RRT	5
#define OMEM_ORT_INFO	5
#define OMEM_STUBHDR	6		/* 36 bytes */
#define OMEM_SUMNETHDR	6
#define OMEM_SUMASBHDR	6
#define OMEM_ASEHDR	6
#define OMEM_ASEDFLTHDR	6
#define OMEM_NET	6
#define	OMEM_LS_REQ	6
#define OMEM_HOST	6
#define OMEM_TIMER	6
#define OMEM_ACKLST	7		/* 16 bytes of queues used */
#define OMEM_LL		7
#define OMEM_LSDB	7
#define OMEM_NL		7
#define OMEM_DBSUM	7
#define OMEM_DBRT	7


#define OMEM_PKT	10
#define OMEM_AREA	11
#define OMEM_INTF	12
#define OMEM_TMP	13
#define OMEM_LS_SB	14
#define OMEM_IF_SB	14
#define OMEM_NBR_SB	14

extern struct LSDB_SUM *dbsum_alloc();

/*
 * CLEAR BUFFER CALL
 */
#define CLEAR_BUF(B,LEN) bzero((B),(LEN))

/*
 * General free routine
 */
#define ZAP(PTR,TYPE) (free(PTR))

#define	DB_ZAP_PKT(N) (free(((char *) ((N)->dbpkt))))

#define ZAP_PKT(PKT) free(PKT)

/* For dbsum */
#define	DONT_ZAP_PKT(PTR)

#define exit_nomem()\
	{fprintf(stderr,"Fatal error: calloc returned null\n");exit(1);}

/*
 * OSPF PACKET
 */
#define OSPF_PKT_ALLOC(P,LEN) {((P) = (struct OSPF_HDR *) calloc(1,(LEN)));\
				if (!(P)) exit_nomem();}


/*
 * LSDB structs
 */
#define DBGUTS_ALLOC(DB)\
	{(DB_GUTS(DB) = (struct DBGUTS *) calloc(1,sizeof(struct DBGUTS)));\
	 if(!DB_GUTS(DB)) exit_nomem();}

#define DBGUTS_FREE(DB)\
	{ZAP(DB_GUTS(DB),OMEM_DBGUTS);DB_GUTS(DB) = DBGUTSNULL;}

#define DB_ALLOC(DB)\
	{((DB) = (struct LSDB *) calloc(1,sizeof(struct LSDB)));\
	 if(!(DB)) exit_nomem();}

/* 
 * Allocs For sorting
 */
#define	LS_SB_ALLOC(SB,SIZE)\
	{((SB) =  (struct LSDB **) calloc((SIZE),sizeof(struct LSDB *)));\
	 if(!(SB)) exit_nomem();}

#define	MORE_LS_SB_ALLOC(SB,SIZE) {ZAP((SB),OMEM_LS_SB);LS_SB_ALLOC(SB,SIZE);}

#define	IF_SB_ALLOC(SB,SIZE)\
	{((SB) =  (struct IF_SB *) calloc((SIZE),sizeof(struct IF_SB)));\
	 if(!(SB)) exit_nomem();}

#define NBR_SB_ALLOC(SB,SIZE)\
	{((SB) =  (struct NBR **) calloc((SIZE),sizeof(struct NBR *)));\
	 if(!(SB)) exit_nomem();}

#define	MORE_NBR_SB_ALLOC(SB,SIZE)\
	 {ZAP((SB),OMEM_NBR_SB);NBR_SB_ALLOC(SB,SIZE);}

#define	TMP_ALLOC(T,WIDTH)\
	{((T) = (char *) calloc(1,(WIDTH))); if(!(T)) exit_nomem();}

/*
 * Acks
 */
#define ACKLST_ALLOC(A)\
	{((A) = (struct ACK_LIST *) calloc(1,sizeof(struct ACK_LIST)));\
	 if(!(A)) exit_nomem();}

/*
 * Link State Advertisements
 */
/*	int __Block_Size = adv_stash_type(LEN);\ */
#define ADV_ALLOC(DB,TYPE,LEN){\
		if ((TYPE) == LS_NET || (TYPE) == LS_RTR) {\
			DB_NET(DB) = (struct NET_LA_HDR *) calloc(1,LEN);\
		} else {DB_NET(DB) = (struct NET_LA_HDR *)calloc(1,LEN);}\
	 	if(!(DB_NET(DB))) exit_nomem();}

#define DBADV_FREE(DB,TYPE) ZAP(DB_RTR(DB),OMEM_ADV)

#define ADV_FREE(A,TYPE) ZAP((A),(TYPE))

/*
 * COPY CALLS
 */
#define ADV_COPY(FROM,TO,LEN) bcopy((FROM),(TO),(LEN))

#define ORT_COPY(FROM,TO) bcopy(FROM,TO,sizeof(OSPF_RT_INFO))

#define AUTH_COPY(FROM,TO,LEN) bcopy((FROM),(TO),(LEN))

#define B_COPY(FROM,TO,LEN) bcopy((FROM),(TO),(LEN))

/*
 * REPLACE CALL
 */
#define ADV_REPLACE(DB,ADV,LEN) {{\
		if ((LEN) > ntohs(LS_LEN(DB))) {\
			DBADV_FREE((DB),LS_TYPE(DB));\
	     		ADV_ALLOC((DB), LS_TYPE(DB),(LEN));\
		}\
	     	ADV_COPY((ADV).rtr,DB_RTR(DB),(LEN));},0}

/*
 * COMPARE CALLS
 */
#define RTR_LINK_CMP(R1,R2,LEN)\
	bcmp(&((R1)->link),&((R2)->link),(LEN))

#define NET_ATTRTR_CMP(N1,N2,LEN)\
	bcmp(&((N1)->att_rtr),&((N2)->att_rtr),(LEN))

#define AUTH_FIELD_CMP(A1,A2) bcmp((A1),(A2),8)

#define ASE_TOS_CMP(T1,T2) bcmp((T1),(T2),ASE_LA_PIECES_SIZE)


/*
 * LSDB List
 */
#define LL_ALLOC(LL)\
	{((LL) = (struct LSDB_LIST *) calloc(1,sizeof(struct LSDB_LIST)));\
	 if(!(LL)) exit_nomem();}

/*
 * DBRT List
 */
#define DBRT_ALLOC(LL)\
	{((LL) = (struct DBRT_LIST *) calloc(1,sizeof(struct DBRT_LIST)));\
	 if(!(LL)) exit_nomem();}

/*
 * Self-originated LSA allocs
 */

/*
 * STUBNET LSA HDR
 */
#define STUB_HDR_ALLOC(N,LEN) {((N) = (struct NET_LA_HDR *) calloc(1,LEN));\
	 if(!(N)) exit_nomem();}

/*
 * RTR LSA HDR
 */
#define	RTR_HDR_ALLOC(R,LEN) {((R) = (struct RTR_LA_HDR *) calloc(1,LEN));\
	 if(!(R)) exit_nomem();}

/*
 * NET LSA HDR
 */
#define NET_HDR_ALLOC(N,LEN) {((N) = (struct NET_LA_HDR *) calloc(1,LEN));\
	 if(!(N)) exit_nomem();}

/*
 * SUM LSA HDR
 */
#define SUM_HDR_ALLOC(S,LEN) {((S) = (struct SUM_LA_HDR *) calloc(1,LEN));\
	 if(!(S)) exit_nomem();}

/*
 * ASE LSA HDR
 */
#define ASE_HDR_ALLOC(A,LEN) {((A) = (struct ASE_LA_HDR *) calloc(1,LEN));\
	 if(!(A)) exit_nomem();}

/*
 * DB SUM
 */
#define DBS_ALLOC(D)\
	{((D) = (struct LSDB_SUM *) calloc(1,sizeof(struct LSDB_SUM)));\
	 if(!(D)) exit_nomem();}

/*
 * OTIMER STRUCTURE
 */
#define OTIMER_ALLOC(T)\
	{((T) = (struct OTIMER *) calloc(1,sizeof(struct OTIMER)));\
	 if(!(T)) exit_nomem();}

/*
 * OSPF ROUTE INFO
 */
#define ORT_INFO_ALLOC(R)\
	{((ORT_INFO(R)) = (OSPF_RT_INFO *)\
		calloc(1,sizeof(OSPF_RT_INFO)));\
	 if(!(R)) exit_nomem();}
/*
 * STATIC ROUTE INFO
 */
#define STATIC_INFO_ALLOC(R)\
 	{(STATIC_INFO(R)) = (STATIC_RT_INFO *)\
	 	calloc(1,sizeof(STATIC_RT_INFO));\
	 if(!(R)) exit_nomem();}

/*
 * OSPF ROUTER ROUTE ENTRY
 */
#define RRT_ALLOC(R) {((R) = (RTR_ROUTE *) calloc(1,sizeof(RTR_ROUTE)));\
	 if(!(R)) exit_nomem();}

/*
 * NBR's LS REQ
 */
#define	LS_REQ_ALLOC(R) \
	{((R) = (struct LS_HDRQ *) calloc(1,sizeof(struct LS_HDRQ)));\
	  if (!(R)) exit_nomem();}

/*
 * LSDB's NBR LIST
 */
#define NL_ALLOC(NL)\
	{((NL) = (struct NBR_LIST *) calloc(1,sizeof(struct NBR_LIST)));\
	 if(!(NL)) exit_nomem();}

/*
 * AREA's NET list ALLOC
 */
#define NR_ALLOC(N)\
	{((N) = (struct NET_RANGE *) calloc(1,sizeof(struct NET_RANGE)));\
	 if(!(N)) exit_nomem();}


/*
 * NBR STRUCT ALLOC
 */
#define NBR_ALLOC(N)\
	{((N) = (struct NBR *) calloc(1,sizeof(struct NBR)));\
	 if(!(N)) exit_nomem();}


/*
 * OSPFD's routing table structure
 */
#define AVLALLOC(A)\
	{((A) = (AVL *) calloc(1,sizeof(AVL)));\
	 if(!(A)) exit_nomem();}



/* Configuration's initialization of structures */



/*
 * AREA Structure
 */
#define AREA_ALLOC(A,CNT)\
	{if(((A) = (struct AREA *)\
		 calloc(CNT,sizeof(struct AREA))) == AREANULL) exit_nomem();}

#define AREA_REALLOC(A,CNT)\
	{if (((A) = (struct AREA *)\
	 	realloc((A),(CNT))) == AREANULL) exit_nomem();}

#define DBBLOCK_ALLOC(DB,CNT)\
       {(((DB) = (struct LSDB *) (calloc((CNT), sizeof(struct LSDB)))));\
	 if(!(DB)) exit_nomem();}

/*
 * INTF STRUCT ALLOCs
 */
#define INTF_ALLOC(I)\
	{if(((I) = (struct INTF *)\
		calloc(1,sizeof(struct INTF))) == INTFNULL) exit_nomem();}

#define INTF_REALLOC(I,CNT)\
	{if (((I) = (struct INTF *)\
	 	realloc((I),(CNT))) == INTFNULL) exit_nomem();}

/*
 * AREA's HOST list ALLOC
 */
#define HOST_ALLOC(H)\
	{((H) = (struct OSPF_HOSTS *) calloc(1,(sizeof(struct OSPF_HOSTS))));\
	 if(!(H)) exit_nomem();}


/*
 * AREA's NET list ALLOC
 */
#define NET_INIT_ALLOC(N)\
	{((N) = (struct OSPF_NETS *) calloc(1,sizeof(struct OSPF_NETS)));\
	 if(!(N)) exit_nomem();}

/*
 * NBR STRUCT ALLOC
 */
#define NBR_INIT_ALLOC(N)\
	{((N) = (struct NBR *) calloc(1,sizeof(struct NBR)));\
	 if(!(N)) exit_nomem();}


/*
 * Memory management macros
 */

/*
 * sizeof this area's router advertisement
 */
#define MY_RTR_ADV_SIZE(A)\
	(RTR_LA_HDR_SIZE +\
	  (((A)->ifcnt * RTR_LA_PIECES_SIZE) * 2) +\
	  (((A)->hostcnt * RTR_LA_PIECES_SIZE)) +\
	  (((A) == ospf.area) ? ((ospf.vcnt * RTR_LA_PIECES_SIZE)) : 0))

/*
 * sizeof this area's network advertisement
 */
#define MY_NET_ADV_SIZE(I)\
	 (NET_LA_HDR_SIZE + (((I)->nbrIcnt + 1) * NET_LA_PIECES_SIZE))

#define QBuildSum	6
#define QAck		7
#define QDbSum		8

#define QueueChkReset 1
/* 
 * Check for 16-Byte queues
 */
#define QueueChk(WHAT,A)	TRUE

/*
 * Check for LS_REQ Queues
 */
#define LSReqQueueChk(COUNT) 	TRUE

/*
 * Check for LS_Ack Queues
 */
#define LSAckQueueChk(COUNT) 	TRUE

#define LSAck_ALLOC(A) \
	{(A) = (struct LS_HDRQ *) calloc(1, sizeof(struct LS_HDRQ));\
	 if(!(A)) exit_nomem();}
