/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#ifndef RTAB_H
#define RTAB_H


extern void rvbind();
extern struct OSPF_ROUTE *routescan();
extern struct OSPF_ROUTE *rtr_findroute();

/*
 * maximum number of equal-cost parents - should pad structs out to even words
 */
#define MAXNH		3

/*
 * For accessing router route information (Area border and AS border routers)
 */
#define RRT_INFO(R)	((R)->ospf_rt_info)
#define RRT_DEST(R) 	((R)->dest)
#define RRT_MASK(R) 	((R)->mask)
#define RRT_DTYPE(R) 	((R)->ospf_rt_info.dtype)
#define RRT_ETYPE(R) 	((R)->ospf_rt_info.etype)
#define RRT_CHANGE(R) 	((R)->ospf_rt_info.change)
#define RRT_PTYPE(R) 	((R)->ospf_rt_info.ptype)
#define RRT_REV(R) 	((R)->ospf_rt_info.revision)
#define RRT_AREA(R) 	((R)->ospf_rt_info.area)
#define RRT_COST(R)	((R)->ospf_rt_info.cost)
#define RRT_TYPE2COST(R) ((R)->ospf_rt_info.type2cost)
#define RRT_NH(R) 	(nh_block[((R)->ospf_rt_info.nh_ndx[0])].nh_addr)
#define RRT_IO_NDX(R) (nh_block[((R)->ospf_rt_info.nh_ndx[0])].ifspfndx)
#define RRT_NH_NDX(R) ((R)->ospf_rt_info.nh_ndx[0])
#define RRT_ADVRTR(R) 	((R)->ospf_rt_info.advrtr)
#define RRT_OSPF_PREF(R) ((R)->ospf_rt_info.preference)
#define RRT_V(R) 	((R)->ospf_rt_info.v)
#define RRT_NEXT(R) 	((R)->ptr[NEXT])
#define RRT_LAST(R) 	((R)->ptr[LAST])


typedef struct ospf_rt_info {
    u_char8 nh_ndx[MAXNH];	/* Better all around if an odd number like 3 */
    u_char8 nh_cnt;
    u_char8 etype;		/* external metric type */
    u_char8 dtype;		/* destination type */
    u_char8 change;		/* this entry has been changed flag */
    u_char8 ptype;		/* LS_RTR and LS_NET are internal, LS_SUM
			           are inter area and LS_ASE are external */
    struct LSDB *v;		/* vertex */
    struct AREA *area;		/* associatiated area */
    int preference;
    u_long32 cost;
    u_long32 type2cost;
    u_long32 advrtr;
    u_long32 ase_tag;
    u_long32 revision;
} OSPF_RT_INFO;


#define ORT_INFO_NULL 	((OSPF_RT_INFO *) 0)

#define RTR_ROUTE 	struct OSPF_ROUTE
#define RTR_ROUTENULL 	((struct OSPF_ROUTE *) 0)

/*
 * Type router entries - Area border, AS border and AS border summary
 */
struct OSPF_ROUTE {
    struct OSPF_ROUTE *ptr[2];
    u_long32 dest;
    u_long32 mask;
    OSPF_RT_INFO ospf_rt_info;
};

/*
 * Cache for forwarding address
 */
#define FORWARD_CACHE_SIZE 5

#define fwd_cache_init() {ospf.fwd_cnt = 0;}

struct FORWARD_CACHE {
    u_long32 fwd_addr;
    /* PORT */
    struct avl_node *fwd_rt;
    u_short16 nhndx;
    u_short16 active;
    u_long32 use;
} forward_cache[FORWARD_CACHE_SIZE];

/*
 * OSPF next-hop list
 */
#define NH_DIRECT		1
#define NH_NBR			NH_DIRECT
#define NH_DIRECT_FORWARD	NH_DIRECT
#define NH_VIRTUAL		2

#define MAXNHCOUNT	256	/* Maximum number of unique next hops */

/* May want to include link address here... */
struct NH_BLOCK {
    u_char8 area_ndx;			/* Area index for virtual links */
    u_char8 type;			/* type of next hop */
    u_short16 ifspfndx;			/* index of io port */
    u_long32 nh_addr;			/* next hop ip address */
} nh_block[MAXNHCOUNT];

/* 
 * Destination types 
 */
#define DTYPE_NET  	0
#define DTYPE_ASBR 	1	/* autonomous system border rtr */
#define DTYPE_ABR  	2	/* area border rtr */
#define DTYPE_VIRT 	3
#define DTYPE_ASE  	4

/* MODIFIED 11/26 */
/* 
 * Change types 
 */
#define E_UNCHANGE		0
#define E_NEW			1	/* New route */
#define E_NEXTHOP		2	/* Next hop has changed */
#define E_METRIC		3	/* Metric has changed */
#define E_WAS_INTER_NOW_INTRA	4	/* Was sum now intra */
#define E_WAS_INTRA_NOW_INTER	5	/* Was intra now sum */
#define E_ASE_METRIC		6	/* ASE metric has changed */
#define E_WAS_ASE		7	/* Was ase now internal */
#define E_WAS_INTRA_NOW_ASE	8	/* Was intra now ase */
#define E_WAS_INTER_NOW_ASE	9	/* Was inter now ase */
#define E_ASE_TYPE 		10	/* From type 2 to type 1 or visa versa*/
#define E_ASE_TAG 		11	/* Tag has changed */
#define E_DELETE		12

/*  
 * Path types
 */
#define PTYPE_ANY    	0x3F		/* internal and external routes */
#define PTYPE_INTRA  	0x7		/* intra route */
#define PTYPE_INTER  	0x18		/* inter route */
#define PTYPE_INT    	0x1F		/* intra or inter routes */
/* MODIFIED 4/12/92 */
#define PTYPE_INTNET    0x0F		/* intra or inter network route */
#define PTYPE_INT    	0x1F		/* intra or inter routes */
#define PTYPE_EXT    	0x20		/* external routes */
#define PTYPE_LEAVES 	0x38		/* inter or ext */
#define PTYPE_BIT(T) 	(1 << (T))	/* T is lsa type */

#ifndef UMBC_SIM
RTR_ROUTE sum_asb_rtab;			/* summary as bdr rtr table */

#endif

#ifdef UMBC_SIM
struct OSPF_ROUTE net_rtab_sim[RTR_CNT][KHASHSIZ], struct OSPF_ROUTE sum_asb_rtab_sim[RTR_CNT];

#define sim_intf_ndx(R) (PLST((R)->v)[0].nhndx)
#endif

/*
 * Check to see if the route is an active intra area route
 * - pass the level that has just been run, the area that
 *   is running the spf algorithm, and the route
 */
/* MODIFED 5/30/92 */
#define  INTRA_ACTIVE(FROM,A,R) intra_active(FROM,A,R)

/*
 * Check to see if a route is active as an inter or intra area route
 */
/* MODIFED 5/30/92 */
#define  INT_ACTIVE(FROM,A,R) int_active(FROM,A,R)
	

#endif				/*RTAB_H*/
