/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   **     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/
#include "../ospf.h"

/*
 * A binary avl tree for the routing table
 */
static int ospf_rtab_size;		/* global size count */

/*
 * Stack
 */
AVL *
pop()
{
    AVL **ret = __rt_top;

    if (ret == stack)
	return (NULL);
    __rt_top--;
    return (*ret);
}

/*
 * Find the natural network mask
 */
u_long32
natural_net_mask(addr)
u_long32 addr;
{
    /* class A */
    if ((addr & ntohl(0x80000000)) == 0)
	return (ntohl(0xff000000));

    /* class B */
    if ((addr & ntohl(0xc0000000)) == ntohl(0x80000000))
	return (ntohl(0xffff0000));

    /* class C */
    if ((addr & ntohl(0xe0000000)) == ntohl(0xc0000000))
	return (ntohl(0xffffff00));

    return 0;
}

/*
 * Walk the avl tree
 */
int
avl_walk(head, routine, param1, param2)
AVL *head;
int (*routine) ();
char *param1;
int param2;
{
    AVL *a;				/* temporary node pointer */
    int ret_flag;

    if (!RT_DELETE(&avl_dflt_rt))
	(*routine) (&avl_dflt_rt, param1, param2);
    reset_stack();
    a = head->ptr[RLINK];
    if (!a)
	return(FLAG_NO_PROBLEM);

    /* while stack is not empty */
    for (;;) {
	while (a != AVLNULL) {
	    push(a);
	    a = a->ptr[LLINK];
	}

	/* end of stack entries? */
	if ((a = pop()) == AVLNULL)
	    return(FLAG_NO_PROBLEM);

	/*
	 * Routine may have flagged to terminate
	 */
	if((ret_flag = (*routine) (a, param1, param2)) != FLAG_NO_PROBLEM)
	    return(ret_flag);

	if ((a = a->ptr[RLINK]) != AVLNULL) {
	    push(a);
	    a = a->ptr[LLINK];
	}
    }
}


/*
 * Compare Two addresses for binary insert
 */
int
AddrCompare(k1, k2)
u_long32 k1, k2;
{
    if (ntohl(k1) < ntohl(k2))
	return (LEFT);
    if (ntohl(k1) > ntohl(k2))
	return (RIGHT);
    return (EQUAL);
}

/*
 * best_match() used by forwarding to get best match
 */
AVL *
best_match(head, addr)
AVL *head;
u_long32 addr;
{
    AVL *a, *next;
    int comp;
    u_long32 natural_mask;

    if ((a = head->ptr[RLINK]) == AVLNULL)
	return (AVLNULL);

    natural_mask = natural_net_mask(addr);
    reset_stack();
    for (;; a = next) {
	comp = AddrCompare(addr & natural_mask, RT_DEST(a) & natural_mask);
	switch (comp) {
	    case EQUAL:		/* found the first instance of this subnet */
		/* while stack is not empty */
		for (;;) {
		    while (a != AVLNULL) {
			push(a);
			/* between first node with this net and here */
			if ((addr & RT_MASK(a)) < RT_DEST(a))
			    break;
			a = a->ptr[RLINK];
		    }
		    if ((a = pop()) == AVLNULL) {
			if (!RT_DELETE(&avl_dflt_rt))
			    return (&avl_dflt_rt);
			return (AVLNULL);	/* end of stack */
		    }
		    if (((addr & RT_MASK(a)) == RT_DEST(a)) &&
			(!RT_DELETE(a)))
			return (a);
		    if ((a = a->ptr[LLINK]) != AVLNULL) {
			push(a);
			a = a->ptr[RLINK];
		    }
		}
	    case LEFT:			/* move left */
		if ((next = a->ptr[LLINK]) == AVLNULL) {
		    if (!RT_DELETE(&avl_dflt_rt))
			return (&avl_dflt_rt);
		    return (AVLNULL);
		}
		break;
	    case RIGHT:		/* move right */
		if ((next = a->ptr[RLINK]) == AVLNULL) {
		    if (!RT_DELETE(&avl_dflt_rt))
			return (&avl_dflt_rt);
		    return (AVLNULL);
		}
		break;
	}
    }
}

/*
 * Insert into the avl tree
 */
AVL *
avl_insert(head, addr, mask, nh_ndx, nh_cnt, ptype, pinfo)
AVL *head;
u_long32 addr, mask;			/* the new key */
u_char8 nh_ndx[];			/* nh block index */
int ptype;
void *pinfo;
{
    AVL *new = AVLNULL;	/* new one - also traverses the tree in front of P */
    AVL *a;	/* traverses the tree */
    AVL *R;	/* the rebalancing point, close to head for dbl rotation */
    AVL *S;	/* points to the rebalancing point closest to the new node */
    AVL *T;	/* points to the father of S */

    int LorR;	/* holds the state of the imbalanced point
		   - if a = side that is being added to, do a single rotation
		   - if a = opposite (OPP(a)) of side that is being added
		   do a double rotation */
    int loopin,i;

#ifdef DBG
    sprintf(_ospf_prt_buf, "Inserting %s\n", lntoa(addr));
    DBG_LOG(_ospf_prt_buf);
#endif

    if (!pinfo)
	return(AVLNULL);

    T = head;

    if (!addr) {		/* default net */
	a = &avl_dflt_rt;
	RT_DELETE(a) = FALSE;
	RT_MASK(a) = 0;
	for(i=0;i<nh_cnt;i++)
	    RT_NH_NDX(a,i) = nh_ndx[i];
	RT_NH_CNT(a) = nh_cnt;
	switch (ptype) {
	    case PR_OSPF:
	    	ORT_INFO(a) = (OSPF_RT_INFO *)pinfo;
		break;

	    case PR_STATIC:
	    	STATIC_INFO(a) = (STATIC_RT_INFO *)pinfo;
		break;

	    case PR_DISCARD:
		RT_DISCARD(a) = TRUE;
		break;
	}
	return (a);
    }

    if (!head->ptr[RLINK]) {
	AVLALLOC(a);
	if (!a)
	    return(AVLNULL);
	head->ptr[RLINK] = a;
	ospf_rtab_size++;	 /* add another to the total */
	RT_DEST(a) = addr;
	RT_MASK(a) = mask;
	for(i=0;i<nh_cnt;i++)
	    RT_NH_NDX(a,i) = nh_ndx[i];
	RT_NH_CNT(a) = nh_cnt;
    	switch (ptype) {
    	    case PR_OSPF:
	    	ORT_INFO(a) = (OSPF_RT_INFO *)pinfo;
	    	break;

    	    case PR_STATIC:
	    	STATIC_INFO(a) = (STATIC_RT_INFO *)pinfo;
	    	break;

	    case PR_DISCARD:
		RT_DISCARD(a) = TRUE;
		break;
    	}

	RT_BALANCE(a) = BALANCED; /* start off balanced */
	return (a);
    }
    S = a = head->ptr[RLINK];
    loopin = TRUE;

    while (loopin) {
	LorR = AddrCompare(addr, (RT_DEST(a)));
	switch (LorR) {
	    case EQUAL:		/* found the element */
		loopin = FALSE;
		break;
	    case LEFT:			/* move left */
		if ((new = (a)->ptr[LLINK]) == AVLNULL)
		    loopin = FALSE;
		break;
	    case RIGHT:		/* move right */
		if ((new = (a)->ptr[RLINK]) == AVLNULL)
		    loopin = FALSE;
		break;
	}
	if (loopin) {
	    if (RT_BALANCE(new) != BALANCED) {	/* isn't balanced */
		T = a;			/* the father of S */
		S = new;		/* the highest level inbalance */
	    }
	    a = new;
	}
    }


    if (!LorR) {
	if (RT_DELETE(a))
	    RT_DELETE(a) = FALSE;
	for(i=0;i<nh_cnt;i++)
	    RT_NH_NDX(a,i) = nh_ndx[i];
	RT_NH_CNT(a) = nh_cnt;

    	switch (ptype) {
    	    case PR_OSPF:
	    	ORT_INFO(a) = (OSPF_RT_INFO *)pinfo;
	    	break;

    	    case PR_STATIC:
	    	STATIC_INFO(a) = (STATIC_RT_INFO *)pinfo;
	    	break;

	    case PR_DISCARD:
		RT_DISCARD(a) = TRUE;
		break;
    	}

	return (a);
    }

    AVLALLOC(new);
    if (!new)
	return(AVLNULL);
    if (LorR == RIGHT)			/* allocate right */
	a->ptr[RLINK] = new;
    if (LorR == LEFT)			/* allocate left */
	a->ptr[LLINK] = new;

    ospf_rtab_size++;			/* add another to the total */
    RT_DEST(new) = addr;		/* load new key into node */
    RT_MASK(new) = mask;		/* load new mask into node */
    RT_BALANCE(new) = BALANCED;		/* start off balanced */
    for(i=0;i<nh_cnt;i++)
        RT_NH_NDX(a,i) = nh_ndx[i];
    RT_NH_CNT(new) = nh_cnt;
    switch (ptype) {
    	case PR_OSPF:
	    ORT_INFO(new) = (OSPF_RT_INFO *)pinfo;
	    break;

    	case PR_STATIC:
	    STATIC_INFO(new) = (STATIC_RT_INFO *)pinfo;
	    break;

	case PR_DISCARD:
	    RT_DISCARD(a) = TRUE;
	    break;
    }
    new->ptr[LLINK] = new->ptr[RLINK] = AVLNULL;

    /*
	    adjust balancing factors between S and new
	    - everything was balanced between S and new
    */

    LorR = AddrCompare(addr, (RT_DEST(S)));
    if (LorR == LEFT)
	R = (a = S->ptr[LLINK]);
    else
	R = (a = S->ptr[RLINK]);


    while (a != new) {
	LorR = AddrCompare(addr, RT_DEST(a));
	if (LorR == LEFT) {
	    RT_BALANCE(a) = LEFT;
	    a = a->ptr[LLINK];
	} else if (LorR == RIGHT) {
	    RT_BALANCE(a) = RIGHT;
	    a = a->ptr[RLINK];
	}
    }

    /* now for the balancing act */
    LorR = AddrCompare(addr, RT_DEST(S));
    if (LorR == BALANCED)
	LorR = RIGHT;
    if (RT_BALANCE(S) == BALANCED) {
	/* the tree has grown higher - terminate */
	RT_BALANCE(S) = LorR;
	return (new);
    } else if (RT_BALANCE(S) != LorR) {
	/* tree has gotten more balanced-terminate */
	RT_BALANCE(S) = BALANCED;
	return (new);
    } else if (RT_BALANCE(S) == LorR) {
	/* the tree has gotten out of balance */
	if (RT_BALANCE(R) == RT_BALANCE(S)) {	/* single rotation mode */
	    a = R;
	    if (LorR == LEFT) {
		S->ptr[LLINK] = R->ptr[RLINK];
		R->ptr[RLINK] = S;
	    } else {			/*RIGHT */
		S->ptr[RLINK] = R->ptr[LLINK];
		R->ptr[LLINK] = S;
	    }
	    RT_BALANCE(S) = (RT_BALANCE(R) = BALANCED);
	}
	if (RT_BALANCE(R) == OPP(LorR)) {
	    /* the deadly double rotation !!! */
	    if (LorR == LEFT) {
		a = R->ptr[RLINK];
		R->ptr[RLINK] = a->ptr[LLINK];
		a->ptr[LLINK] = R;
		S->ptr[LLINK] = a->ptr[RLINK];
		a->ptr[RLINK] = S;
	    } else {			/* RIGHT */
		a = R->ptr[LLINK];
		R->ptr[LLINK] = a->ptr[RLINK];
		a->ptr[RLINK] = R;
		S->ptr[RLINK] = a->ptr[LLINK];
		a->ptr[LLINK] = S;
	    }
	    if (RT_BALANCE(a) == LorR) {
		RT_BALANCE(S) = OPP(LorR);
		RT_BALANCE(R) = BALANCED;
	    }
	    if (RT_BALANCE(a) == BALANCED)
		RT_BALANCE(S) = (RT_BALANCE(R) = BALANCED);
	    if (RT_BALANCE(a) == OPP(LorR)) {
		RT_BALANCE(S) = BALANCED;
		RT_BALANCE(R) = LorR;
	    }
	    RT_BALANCE(a) = BALANCED;
	}				/* end double rotation */
	if (S == T->ptr[RLINK])
	    T->ptr[RLINK] = a;
	else
	    T->ptr[LLINK] = a;
    }					/* end out-of-balance case */
    return (new);
}

/*
 * MIB access for the routing table
 */
AVL *
get_rtab(action, addr)
int	action;
u_long32 addr;
{
    AVL *a, *next;

    int LorR;	/* holds the state of the imbalanced point
		   - if a = side that is being added to, do a single rotation
		   - if a = opposite (OPP(a)) of side that is being added
		   do a double rotation */


    if (!ospf_rtab->ptr[RLINK])
	return (AVLNULL);

    /*
     * GET 
     */
    if (action == GET_THIS) {
	a = best_match(ospf_rtab,addr);
	if (a && RT_DEST(a) == addr)
	   return(a);
	return(AVLNULL);
    }

    reset_stack();

    next = a = ospf_rtab->ptr[RLINK];

    /* Get Next and Get First handled in this loop */	
    while (TRUE) {

	if (action == GET_FIRST) {
	    /* Get the lowest - leftmost entry */
	    while (a != AVLNULL) {
		push(a);
		a = a->ptr[LLINK];
	    }
	    if (a && (!RT_DELETE(a)))
		return(a);
	    LorR = EQUAL;
	} else if (action == GET_NEXT) {
	    LorR = AddrCompare(addr, (RT_DEST(a)));
	}

	switch (LorR) {
	    case EQUAL:		/* found the element */
		if ( a && ((next = a->ptr[RLINK]) != AVLNULL) ) {
		    while(next->ptr[LLINK]) {
			push(next);
		    	next = next->ptr[LLINK];
		    }

		    if (RT_DELETE(next))
		    {
			next = get_rtab(GET_NEXT,RT_DEST(next));
		    }
		    return(next);
		}

		if ((next = pop()) == AVLNULL)
		    return (AVLNULL);	/* end of stack */

		if (next->ptr[LLINK] == a)
		{
		    if (RT_DELETE(next))
		    {
			/* This one is deleted, get the next one */
			next = get_rtab(GET_NEXT,RT_DEST(next));
		    }
		    return(next);
		}

		/* 
		 * must be right link - first left link will be parent
		 */
		do {
		    if (next->ptr[LLINK] == a) {
		        if (RT_DELETE(next))
		        {
			    /* This one is deleted, get the next one */
			    next = get_rtab(GET_NEXT,RT_DEST(next));
		    	}
		        return(next);
		    }
		    a = next;
		} while(next = pop());

		return(AVLNULL);

	    case LEFT:		/* move left */
		if ((next = (a)->ptr[LLINK]) == AVLNULL)
		    return(AVLNULL);
		break;

	    case RIGHT:		/* move right */
		if ((next = (a)->ptr[RLINK]) == AVLNULL)
		    return(AVLNULL);
		break;
	}
	push(a);
	a = next;
    }
}
