#ifdef PROTO_OSPF
#include "../ospf.h"
#else
#include "rt_include.h"
#endif

extern int	__num_large_bufs;
extern int	__num_small_bufs;

#ifdef PENRIL_PORT

/*
 * These two variables hold information about where the ospf memory
 * partition is, and how big it is. These are "char *" pointers so that the
 * byte wise pointer arithmetic will work.
 *
 * Rob will need to negotiate the actual size with ...Ken.
 *
 */

static BYTE *  ppe_ospf_mem_free_start; /* what the address of the free memory is, currently */


/*  */
void
rb_init(ndx,r)
int ndx;
struct ROB_BUFS *r;
{
    int j;
    struct MEM_HDR *m;
    volatile BYTE * tmp_ptr;

    /* carve up the partition */
    tmp_ptr = ppe_ospf_mem_free_start + (r->init * (r->size + sizeof(struct MEM_HDR)));

    if (( tmp_ptr - ppe_ospf_mem_start ) > ppe_ospf_mem_size )
    {
	/* oops!, we ran out of partition space */
	fatal_error(FATAL_PPE_OSPF_CARVE);
    }

    r->block = (char *)ppe_ospf_mem_free_start;
    ppe_ospf_mem_free_start = tmp_ptr;

    /* Set up next ptrs */
    for(j=0,m = (struct MEM_HDR *) r->block; j<r->init; j++)
    {
	m = (struct MEM_HDR *)&(r->block[j * (r->size + sizeof(struct MEM_HDR))]);
	m->partition = ndx;
	m->next_rbuf = (j == (r->init - 1)) ? -1 : j+1;
    }
}

/*
 * Initialization for ip_bufs
 * Non-private buffers must be in increasing order
 */
void
partition_init()
{
    int i;

    __num_small_bufs = 0;
    __num_large_bufs = 0;
    ppe_ospf_mem_free_start = ppe_ospf_mem_start;

    for (i=0;i<MAX_MEM_PARTITIONS;i++) {
	bzero(&ip_bufs[i],sizeof(struct ROB_BUFS));
    }

    /* 
     * OSPF Small queues
     */
    ip_bufs[0].size = 16;
    ip_bufs[0].init = ip_bufs[0].available = 20;
    ip_bufs[0].private = _TRUE;
    rb_init(0,&ip_bufs[0]);

    /* 
     * OSPF Large queues
     */
    ip_bufs[1].size = 24;
    ip_bufs[1].init = ip_bufs[1].available = 20;
    ip_bufs[1].private = _TRUE;
    rb_init(1,&ip_bufs[1]);

    /* 
     * IP RTAB ENTRIES
     */
    ip_bufs[2].size = sizeof(struct avl_node);
    ip_bufs[2].init = ip_bufs[2].available = 20;
    ip_bufs[2].private = _TRUE;
    rb_init(2,&ip_bufs[2]);

    ip_bufs[3].size = 32;
    ip_bufs[3].init = ip_bufs[3].available = 20;
    ip_bufs[3].private = 0;
    rb_init(3,&ip_bufs[3]);

    ip_bufs[4].size = 40;
    ip_bufs[4].init = ip_bufs[4].available = 20;
    ip_bufs[4].private = 0;
    rb_init(4,&ip_bufs[4]);

    ip_bufs[5].size = 64;
    ip_bufs[5].init = ip_bufs[5].available = 20;
    ip_bufs[5].private = 0;
    rb_init(5,&ip_bufs[5]);

    ip_bufs[6].size = 128;
    ip_bufs[6].init = ip_bufs[6].available = 20;
    ip_bufs[6].private = 0;
    rb_init(6,&ip_bufs[6]);

    ip_bufs[7].size = 512;
    ip_bufs[7].init = ip_bufs[7].available = 10;
    ip_bufs[7].private = 0;
    rb_init(7,&ip_bufs[7]);

    ip_bufs[8].size = 1500;
    ip_bufs[8].init = ip_bufs[8].available = 10;
    ip_bufs[8].private = 0;
    rb_init(8,&ip_bufs[8]);

    ip_bufs[9].size = 4096;
    ip_bufs[9].init = ip_bufs[9].available = 3;
    ip_bufs[9].private = 0;
    rb_init(9,&ip_bufs[9]);

    ip_bufs[10].size = 8192;
    ip_bufs[10].init = ip_bufs[10].available = 3;
    ip_bufs[10].private = 0;
    rb_init(10,&ip_bufs[10]);

}

#else /* NOT (!) PENRIL_PORT */

void
rb_init(ndx,r)
int ndx;
struct ROB_BUFS *r;
{
    int i,j;
    struct MEM_HDR *m;

    r->block =  (char *)
	malloc(r->init * (r->size + sizeof(struct MEM_HDR)));

    /* Set up next ptrs */
    for(j=0,m = (struct MEM_HDR *) r->block; j<r->init; j++)
    {
	m = (struct MEM_HDR *)&(r->block[j * (r->size + sizeof(struct MEM_HDR))]);
	m->owner = 0;
	m->partition = ndx;
	m->next_rbuf = (j == (r->init - 1)) ? -1 : j+1;
    }

}

/*
 * Initialization for ip_bufs
 * Non-private buffers must be in increasing order
 */
void
partition_init()
{
    int i;

    __num_small_bufs = 0;
    __num_large_bufs = 0;

    for (i=0;i<MAX_MEM_PARTITIONS;i++) {
	bzero(&ip_bufs[i],sizeof(struct ROB_BUFS));
    }

    /* 
     * OSPF Small queues
     */
    ip_bufs[0].size = 16;
    ip_bufs[0].init = ip_bufs[0].available = 10;
    ip_bufs[0].private = _TRUE;
    rb_init(0,&ip_bufs[0]);

    /* 
     * OSPF Large queues
     */
    ip_bufs[1].size = 24;
    ip_bufs[1].init = ip_bufs[1].available = 10;
    ip_bufs[1].private = _TRUE;
    rb_init(1,&ip_bufs[1]);

    /* 
     * IP RTAB ENTRIES
     */
    ip_bufs[2].size = sizeof(struct avl_node);
    ip_bufs[2].init = ip_bufs[2].available = 10;
    ip_bufs[2].private = _TRUE;
    rb_init(2,&ip_bufs[2]);

    ip_bufs[3].size = 32;
    ip_bufs[3].init = ip_bufs[3].available = 10;
    ip_bufs[3].private = 0;
    rb_init(3,&ip_bufs[3]);

    ip_bufs[4].size = 40;
    ip_bufs[4].init = ip_bufs[4].available = 10;
    ip_bufs[4].private = 0;
    rb_init(4,&ip_bufs[4]);

    ip_bufs[5].size = 64;
    ip_bufs[5].init = ip_bufs[5].available = 10;
    ip_bufs[5].private = 0;
    rb_init(5,&ip_bufs[5]);

    ip_bufs[6].size = 128;
    ip_bufs[6].init = ip_bufs[6].available = 10;
    ip_bufs[6].private = 0;
    rb_init(6,&ip_bufs[6]);

    ip_bufs[7].size = 512;
    ip_bufs[7].init = ip_bufs[7].available = 10;
    ip_bufs[7].private = 0;
    rb_init(7,&ip_bufs[7]);

    ip_bufs[8].size = 1500;
    ip_bufs[8].init = ip_bufs[8].available = 10;
    ip_bufs[8].private = 0;
    rb_init(8,&ip_bufs[8]);

    ip_bufs[9].size = 4096;
    ip_bufs[9].init = ip_bufs[9].available = 10;
    ip_bufs[9].private = 0;
    rb_init(9,&ip_bufs[9]);

    ip_bufs[10].size = 8192;
    ip_bufs[10].init = ip_bufs[10].available = 10;
    ip_bufs[10].private = 0;
    rb_init(10,&ip_bufs[10]);

}

#endif

char *
ralloc(cnt,size)
int cnt, size;
{
    int i, tot = cnt * size;
    struct ROB_BUFS *r;
    char *new;
    struct MEM_HDR *m;

    for (i=0,r = ip_bufs;i<MAX_MEM_PARTITIONS;i++,r++) {
    	if (!r->init) break;

	if ( (r->available) && (!r->private) && (tot <= r->size) ) {
	    new = &(r->block[r->free_list * (r->size + sizeof(struct MEM_HDR))]);
	    m = (struct MEM_HDR *) new;
	    r->free_list = m->next_rbuf;
	    r->available--;
	    r->total_alloc++;
	    new = new + sizeof(struct MEM_HDR);
	    bzero(new,r->size);
	    return(new);
	}

    }
    return((char *)0);
}

void
rfree(buf,type)
char *buf;
int type;
{
    struct MEM_HDR *m;
    struct ROB_BUFS *r;

    if (!buf) {
	return;
    }
    m = (struct MEM_HDR*)(((long)buf) - sizeof(struct MEM_HDR));
    r = &(ip_bufs[m->partition]);

    /* check for valid rob_buf */
    if (!RB_VALID(m)) {
    }

    if (!r->available) {
	m->next_rbuf = -1;
    } else {
    	m->next_rbuf = r->free_list;
    }
    m->owner = OMEM_FREE;
    r->free_list = 
	(((long) m) - (long)r->block)/(r->size + sizeof(struct MEM_HDR));
    r->total_free++;
    r->available++;
}

char *
private_ralloc(ndx)
int ndx;
{
    struct ROB_BUFS *r;
    char *new;
    struct MEM_HDR *m;

    r = &ip_bufs[ndx];
    if (!r->init) 
	return((char *)0);

    if (r->available) {
    	new = &(r->block[r->free_list * (r->size + sizeof(struct MEM_HDR))]);
    	m = (struct MEM_HDR *) new;
    	r->free_list = m->next_rbuf;
    	r->available--;
    	r->total_alloc++;
    	new = new + sizeof(struct MEM_HDR);
    	bzero(new,r->size);
    	return(new);
    }
    return((char *)0);
}


#ifndef PENRIL_PORT

/* Moved this to pport_mem.h, so that function prototypes
 * would make sense, among other things... */

/* For MIB */
struct IP_MEM_STATS {
	int size;
        int init;
        int available;
	int private;
        int total_alloc;
        int total_free;
};
#endif

#ifdef NOTDEF
int
get_mem_stats(action,mp)
int action;
struct IP_MEM_STATS **mp;
{
    int i;
    struct ROB_BUFS *r;

    r = ip_bufs;

    if (action == GET_FIRST)
    {
#ifdef PENRIL_PORT
/* Hey Rob... I'm not sure what ndx was attempting to do, so
 * I did a quick guess on this, please chsck it out and fix it up...
 */
	return (0);
#else
	ndx = 0;
#endif
    }
    else
    {
    	for (i=0;i<MAX_MEM_PARTITIONS;i++,r++)
	{
    	    if (!r->init)
	    {
		return(FALSE);
	    }
	    if ( ((*mp)->size == r->size) && ((*mp)->private == r->private) )
	    {
		if (action == GET_THIS)
		{
		    break;
		}
		else		   /* action == GET_NEXT */
		{ 
		    if (i == MAX_MEM_PARTITIONS - 1)
		    {
			return(FALSE);
		    }
		    r++;
		    break;
		}
	    }
	}
    }

    (*mp)->size = r->size;
    (*mp)->init = r->init;
    (*mp)->available = r->available;
    (*mp)->private = r->private;
    (*mp)->total_alloc = r->total_alloc;
    (*mp)->total_free = r->total_free;
    (*mp)->block = r->block;
    return(_TRUE);
}
#endif
