/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software not be misrepresented, either by          *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20472				       *
*		     (301) 405-4208					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#define MIB_VALID	1
#define MIB_INVALID	2

#define MIB_TRUE	1
#define MIB_FALSE	2

#define MIB_ENABLED	1
#define MIB_DISABLED	2

#define MaxAdvSize 	2000

/*
 * For sorting the interfaces
 */
struct IF_SB {
    u_long32	addr;
    u_long32	area_id;
    struct	INTF *intf;
};

struct MIB_TAB {
    char *mib_name;
    int  (*mib_routine) ();
    void (*mib_print) ();
};
    

struct	OspfGeneralGroup  {
    u_long32 	ospfRouterId;
    int		ospfVersionNumber;
    u_char8	ospfAdminStat;
    u_char8	ospfAreaBdrRtrStatus;
    u_char8	ospfASBdrRtrStatus;
    u_char8	ospfTOSSupport;
    int		ospfExternLSACount;
    u_long32	ospfExternLSACksumSum;
    int		ospfOriginateNewLsa;
    int		ospfRxNewLSA;
};


struct OspfAreaEntry {
    u_long32	ospfAreaId;
    u_short16	ospfAuthType;
    u_short16 	ospfImportASExtern;
    int		ospfSpfRuns;
    int		ospfAreaBdrRtrCount;
    int		ospfASBdrRtrCount;
    int		ospfLSACount;
    u_long32	ospfAreaLSACksumSum;
};


struct OspfStubAreaEntry  {
    u_long32	ospfStubAreaID;
    int		ospfStubTOS;
    u_long32	ospfStubMetric;
    int		ospfStubStatus;
};

struct	OspfLsdbEntry	{
    u_long32	ospfLsdbAreaId;
    u_long32	ospfLsdbLSID;
    u_long32	ospfLsdbRouterId;
    u_short16	ospfLsdbType;
    u_short16	ospfLsdbAge;
    u_long32	ospfLsdbSequence;
    u_short16	ospfLsdbChecksum;
    u_short16 	adv_len;
    u_char8 	ospfLsdbAdvertisement[MaxAdvSize];
};

struct	OspfAreaRangeEntry {
    u_long32	ospfAreaRangeAreaID;
    u_long32	ospfAreaRangeNet;
    u_long32	ospfAreaRangeMask;
    int		ospfAreaRangeStatus;
};

struct OspfHostEntry {
    u_long32 	ospfHostIpAddress;
    int		ospfHostTOS;
    u_short16	ospfHostCost;
    u_short16   ospfHostStatus;
};

struct OspfIfEntry {
    u_long32	ospfIfIpAddress;
    int		ospfAddressLessIf;
    u_long32	ospfIfAreaId;
    u_char8	ospfIfType;
    u_char8	ospfIfAdminStat;
    u_short16	ospfIfRtrPriority;
    u_short16	ospfIfTransitDelay;
    u_short16	ospfIfRetransInterval;
    u_short16	ospfIfHelloInterval;
    u_short16	ospfIfPollInterval;
    u_long32	ospfIfRtrDeadInterval;
    int		ospfIfState;
    u_long32	ospfIfDesignatedRouter;
    u_long32	ospfIfBackupDesignatedRouter;
    int		ospfIfEvents;
    char	ospfIfAuthKey[8];
};

struct OspfIfMetricEntry {
    u_long32	ospfIfMetricIpAddress;
    int		ospfIfMetricAddressLessIf;
    int		ospfIfMetricTOS;
    u_long32	ospfIfMetricCost;
    int		ospfIfMetricStatus;
};

struct OspfVirtIfEntry	{
    u_long32	ospfVirtIfAreaID;
    u_long32	ospfVirtIfNeighbor;
    u_long32	ospfVirtIfTransitDelay;
    u_short16	ospfVirtIfRetransInterval;
    u_short16	ospfVirtIfHelloInterval;
    u_long32	ospfVirtIfRtrDeadInterval;
    int		ospfVirtIfState;
    int		ospfVirtIfEvents;
    char	ospfVirtIfAuthKey[8];
    int		ospfVirtIfStatus;
};


struct	OspfNbrEntry	{
    u_long32	ospfNbrIpAddr;
    int		ospfNbrAddressLessIndex;
    u_long32	ospfNbrRtrId;
    u_short16	ospfNbrOptions;
    u_short16	ospfNbrPriority;
    int		ospfNbrState;
    int		ospfNbrEvents;
    int		ospfNbrLSRetransQLen;
    int		ospfNBMANbrStatus;
};

struct	OspfVirtNbrEntry {
    u_long32	ospfVirtNbrArea;
    u_long32	ospfVirtNbrRtrId;
    u_long32	ospfVirtNbrIpAddr;
    u_short16	ospfVirtNbrOptions;
    u_short16	ospfVirtNbrState;
    int		ospfVirtNbrEvent;
    int		ospfVirtNbrLSRetransQLen;
};

union 	OSPF_MIB_UN {
    struct OspfGeneralGroup 	OspfGeneralGroup;
    struct OspfAreaEntry 	OspfAreaEntry;
    struct OspfStubAreaEntry	OspfStubAreaEntry;
    struct OspfLsdbEntry	OspfLsdbEntry;
    struct OspfAreaRangeEntry	OspfAreaRangeEntry;
    struct OspfHostEntry	OspfHostEntry;
    struct OspfIfEntry		OspfIfEntry;
    struct OspfIfMetricEntry	OspfIfMetricEntry;
    struct OspfVirtIfEntry	OspfVirtIfEntry;
    struct OspfNbrEntry		OspfNbrEntry;
    struct OspfVirtNbrEntry	OspfVirtNbrEntry;
};

struct ospfMibmsg  {
    u_char8	action;
/* subagent-to-ospfd message types */
#define GET_FIRST       1
#define GET_THIS        2
#define GET_NEXT        3
#define MIB_SET         4

/* ospfd-to-subagent message types */
#define MIB_RSP         1
#define MIB_EOT         2    /* end of table */
#define MIB_ERR         3

    u_char8	objtype;
    u_char8	ret_val;
    u_char8	fill;
#define OGeneral        1
#define OArea           2
#define OStubArea       3
#define OLSDBEntry      4
#define OAreaRange      5
#define OHostEntry      6
#define OIfEntry        7
#define OIfMetricEntry  8
#define OVirtIfEntry    9
#define ONbrEntry       10
    union OSPF_MIB_UN	 o_mu;
};
