#define ospfIfStateChangeTrap		0
#define ospfVirtIfStateChangeTrap	1
#define ospfNbrStateChangeTrap		2
#define ospfVirtNbrStateChangeTrap	3
#define ospfConfigErrorTrap		4
#define ospfVirtIfConfigErrorTrap	5
#define ospfRxBadPacketTrap		6
#define ospfVirtIfRxBadPacketTrap	7
#define ospfTxRetransmitTrap		8
#define ospfVirtIfTxRetransmitTrap	9
#define ospfOriginateLSATrap		10
#define ospfMaxAgeLSATrap		11
#define ospfLSDBOverflowTrap		12
#define ospfLSDBHiWaterExceededTrap	13

struct ospfIfStateChange {
	ospfRouterId,
	ospfIfIpAddress,
	ospfAddressLessIf,
	ospfIfState


struct ospfVirtIfStateChange {
	ospfRouterId,
	ospfVirtAreaID,
	ospfVirtIfNeighbor,
	ospfVirtIfState

struct ospfNbrStateChange {
	ospfRouterId,
	ospfNbrIpAddress,
	ospfNbrAddressLessIndex,
	ospfNbrRtrId,	
	ospfNbrState }

struct ospfVirtNbrStateChange {
	ospfRouterId,
	ospfVirtNbrArea,
	ospfVirtNbrRtrId,
	ospfVirtNbrState }

struct ospfConfigError	{
	ospfRouterId,
	ospfIfIpAddress,
	ospfAddressLessIf,
	IpAddress,
	ospfConfigErrorType,
	ospfPacketType }

struct ospfVirtIfConfigError {
	ospfRouterId,
	ospfVirtAreaID,
	ospfVirtIfNeighbor,
	ospfConfigErrorType,
	ospfPacketType }

struct ospfRxBadPacket {
	ospfRouterId,
	ospfIfIpAddress,
	ospfAddressLessIf,
	IpAddress,
	ospfPacketType }

struct ospfVirtIfRxBadPacket {
	ospfRouterId,
	ospfVirtAreaID,
	ospfVirtIfNeighbor,
	ospfPacketType }

struct ospfTxRetransmit {
	ospfRouterId,
	ospfIfIpAddress,
	ospfAddressLessIf,
	ospfNbrRtrId,
	ospfPacketType }

struct ospfVirtIfTxRetransmit {
	ospfRouterId,
	ospfVirtAreaID,
	ospfVirtIfNeighbor,
	ospfPacketType }

struct ospfOriginateLSA {
	ospfRouterId,
	ospfLsdbAreaId,
	ospfLsdbType,
	ospfLsdbLSID,
	ospfLsdbRouterId }

struct ospfMaxAgeLSA {
	ospfRouterId,
	ospfLsdbAreaId,
	ospfLsdbType,
	ospfLsdbLSID,
	ospfLsdbRouterId }

struct ospfLSDBOverflow {
	ospfRouterId,
	ospfLSDBLimit }

struct ospfLSDBHiWaterExceeded {
	ospfRouterId,
	ospfLSDBHiWater }

ospf_db_cnt_trap(type) 
int type;
{
}

ospf_send_trap(type,db,nbr,intf,area,src_addr,pkt_type,config_error_type)
ospf_traps *ospf_trap;
{
}
