/*******************************************************************************
*									       *
*                U   U M   M DDDD     OOOOO SSSSS PPPPP FFFFF		       *
*                U   U MM MM D   D    O   O S     P   P F		       *
*                U   U M M M D   D    O   O  SSS  PPPPP FFFF		       *
*                U   U M M M D   D    O   O     S P     F		       *
*                 UUU  M M M DDDD     OOOOO SSSSS P     F		       *
*									       *
*    		          Copyright 1989, 1990, 1991, 1992         	       *
*    	       The University of Maryland, College Park, Maryland.	       *
*								               *
*			    All Rights Reserved				       *
*									       *
*     The University of Maryland College Park ("UMCP") is the owner of all     *
*     right, title and interest in and to UMD OSPF (the "Software").           *
*     Permission to use, copy and modify the Software and its documentation    *
*     solely for non-commercial purposes is granted subject to the following   *
*     terms and conditions:						       *
*								               *
*     1. This copyright notice and these terms shall appear in all copies      *
*	 of the Software and its supporting documentation.		       *
*									       *
*     2. The Software shall not be distributed, sold or used in any way in     *
*	 a commercial product, without UMCP's prior written consent.           *
*									       *
*     3. The origin of this software may not be misrepresented, either by      *
*        explicit claim or by omission.					       *
*    									       *
*     4. Modified or altered versions must be plainly marked as such, and      *
*	 must not be misrepresented as being the original software.	       *
*     									       *
*     5. The Software is provided "AS IS". User acknowledges that the          *
*        Software has been developed for research purposes only. User          *
*	 agrees that use of the Software is at user's own risk. UMCP	       *
*	 disclaims all warrenties, express and implied, including but          *
*	 not limited to, the implied warranties of merchantability, and        *
*	 fitness for a particular purpose.				       *
*									       *
*    Royalty-free licenses to redistribute UMD OSPF are available from	       *
*    The University Of Maryland, College Park. 			               *
*      For details contact:						       *
*	        Office of Technology Liaison 				       *
*		4312 Knox Road     					       *
*		University Of Maryland					       *
*		College Park, Maryland 20742				       *
*		     (301) 405-4209					       *
*		FAX: (301) 314-9871    					       *
*									       *
*    This software was written by Rob Coltun				       *
*     rcoltun@ni.umd.edu						       *
*									       *
*******************************************************************************/

#include "ospf.h"

#ifdef	PROTO_OSPF

/*
 * Combine the next hop lists of parents in sorted order
 */
void
nh_list_add(v, parent)
struct LSDB *v, *parent;
{
    int p[MAXNH * 2];
    int vndx, pndx, i, tot = DB_NH_CNT(v) + DB_NH_CNT(parent);

    vndx = pndx = 0;
    for (i = 0; i < (MAXNH * 2); i++)
	p[i] = 0;
    /*
     * merge lists into p based on nh_addr
     */
    /* MODIFIED DB_NH_NDX 1/10 */
    for (i = 0; i < (tot); i++) {
	if (vndx >= DB_NH_CNT(v)) {
	    p[i] = DB_NH_NDX(parent,pndx);
	    pndx++;
	} else if (pndx >= DB_NH_CNT(parent)) {
	    p[i] = DB_NH_NDX(v,vndx);
	    vndx++;
	} else if (DB_NH_NDX(v,vndx) == DB_NH_NDX(parent,pndx)) {
	    /* same next hop */
	    p[i] = DB_NH_NDX(v,vndx);
	    vndx++;
	    pndx++;
	    tot--;
	} else if ((ntohl(nh_block[(DB_NH_NDX(v,vndx))].nh_addr)) <=
		   (ntohl(nh_block[(DB_NH_NDX(parent,pndx))].nh_addr))) {
	    p[i] = DB_NH_NDX(v,vndx);
	    vndx++;
	} else {
	    p[i] = DB_NH_NDX(parent,pndx);
	    pndx++;
	}
    }

    DB_NH_CNT(v) = 0;
    for (i = 0; i < (MAXNH); i++) {
	if (!p[i]) {
#ifdef DBG
	    sprintf(_ospf_prt_buf, "Setting nh to %d", DB_NH_CNT(v));
	    DBG_LOG(_ospf_prt_buf);
#endif
	    return;
	}
	/* MODIFIED 1/10 */
	DB_NH_NDX(v,i) = p[i];
	DB_NH_CNT(v) += 1;
    }
#ifdef DBG
    sprintf(_ospf_prt_buf, "Setting nh to %d", DB_NH_CNT(v));
    DBG_LOG(_ospf_prt_buf);
#endif
}

/*
 * Add next hop entry to nh_block
 */
int
add_nh_entry(ifspfndx, nh_addr, type, area_ndx)
int ifspfndx;
u_long32 nh_addr;
int type, area_ndx;
{
    int i;

    /* Already added? */
    for (i = 1; i < ospf.nh_high; i++)
	if ((nh_addr == nh_block[i].nh_addr) &&
	    (type == nh_block[i].type) &&
	    (ifspfndx == nh_block[i].ifspfndx))
	    return (i);
    if (!ospf.nh_high)
	ospf.nh_high = 1;
    nh_block[ospf.nh_high].ifspfndx = ifspfndx;
    nh_block[ospf.nh_high].nh_addr = nh_addr;
    nh_block[ospf.nh_high].type = type;
    nh_block[ospf.nh_high].area_ndx = area_ndx;
    ospf.nh_high += 1;
    return (ospf.nh_high - 1);
}

/*
 * Find appropriate non-virtual nh_block entry
 */
int
find_nh_entry(v, if_ip_addr)
struct LSDB *v;
u_long32 if_ip_addr;
{
    int i;

    switch (LS_TYPE(v)) {
	case LS_STUB:
	    /* either host or point-to-point interface */
	    if (DB_NET(v)->net_mask == HOST_NET_MASK) {
		for (i = 1; i < ospf.nh_high; i++) {
		    if ((nh_block[i].type != NH_VIRTUAL) &&
			(ifspfIF(nh_block[i].ifspfndx).type ==
			 POINT_TO_POINT) &&
			(nh_block[i].nh_addr == LS_ID(v)))
			return (i);
		}
	    } else
		for (i = 1; i < ospf.nh_high; i++) {
		    if ((nh_block[i].type != NH_VIRTUAL) &&
		     (NDX_NET_NUM(nh_block[i].ifspfndx) == DB_NETNUM(v)))
			return (i);
		}
#ifdef NOTDEF
	    /* go through host list, if should be configured */
	    /* need to look up IF_NDX of host??? */
	    for (host = ospf.area[i].hosts.ptr[NEXT],
		 host != HOSTNULL;
		 host = host->ptr[NEXT])
		if (host->ipaddr == LS_ID(v))
		    break;
#endif
	    break;
	case LS_NET:
	    for (i = 1; i < ospf.nh_high; i++) {
		if ((nh_block[i].type != NH_VIRTUAL) &&
		    (NDX_NET_NUM(nh_block[i].ifspfndx) == DB_NETNUM(v)))
		    return (i);
	    }
	    break;

	case LS_RTR:
	    /* Find adjacent neighbor */
	    for (i = 1; i < ospf.nh_high; i++) {
		if ((nh_block[i].type != NH_VIRTUAL) &&
		    (nh_block[i].nh_addr == if_ip_addr))
		    return (i);
	    }
	    break;
    }
    return (0);
}


/*
 *	free db's parent list
 */
void
freeplist(db)
struct LSDB *db;
{
    int i;

    if (!DB_NH_CNT(db))
	return;

    DB_DIRECT(db) = FALSE;
    /* MODIFIED 1/10 */
    for (i = 0; i < DB_NH_CNT(db); i++) {
	DB_NH_NDX(db,i) = 0;
    }
    DB_NH_CNT(db) = 0;
}

/*
 *      Spf(a) has just been run - cleanup unused stubs
 */
void
stub_cleanup(a)
struct AREA *a;
{
    struct LSDB *db, *hp;

    for (hp = a->htbl[LS_STUB]; hp < &(a->htbl[LS_STUB][HTBLSIZE]); hp++) {
	for (db = DB_NEXT(hp);
	     db != LSDBNULL;
	     db = DB_NEXT(db)) {
	    if (NO_GUTS(db))
		continue;

	    if (DB_ROUTE(db) == ROUTENULL) {
		freeplist(db);
		db_free(db);
	    }
	}
    }
}

/*
 *  spfinit()    free parent list and reset vertex variables
 */
void
spfinit(a)
struct AREA *a;
{

    int type;
    struct LSDB *hp, *db;

    for (type = LS_STUB; type <= LS_NET; type++)
	for (hp = a->htbl[type]; hp < &(a->htbl[type][HTBLSIZE]); hp++) {
	    for (db = DB_NEXT(hp); db != LSDBNULL; db = DB_NEXT(db)) {
		if (NO_GUTS(db) ||
		    DB_FREEME(db))
		    continue;
		DB_WHERE(db) = UNINITIALIZED;
		DB_VIRTUAL(db) = FALSE;
		DB_PTR(db)[LAST] = DB_PTR(db)[NEXT] = LSDBNULL;
		if (type == LS_NET || type == LS_STUB) {
		    if (DB_ROUTE(db) != ROUTENULL)
			ORT_CHANGE(DB_ROUTE(db)) = E_UNCHANGE;
		} else {
		    if (DB_AB_RTR(db) != RTR_ROUTENULL)
			RRT_CHANGE(DB_AB_RTR(db)) = E_UNCHANGE;
		    if (DB_ASB_RTR(db) != RTR_ROUTENULL)
			RRT_CHANGE(DB_ASB_RTR(db)) = E_UNCHANGE;
		}
		DB_DIST(db) = RTRLSInfinity;
		freeplist(db);
	    }
	}
}


/*
 * enq v in order on candidate list
 */
void
clenq(a, v)
struct AREA *a;
struct LSDB *v;
{
    struct LSDB *nextv;

#ifdef DBG
    sprintf(_ospf_prt_buf, "Adding type %d id %s rtr %s to clist",
	    LS_TYPE(v), lntoa(LS_ID(v)), lntoa(ADV_RTR(v)));
    DBG_LOG(_ospf_prt_buf);
#endif
    /* Remove from previous queue */
    DEL_DBQ(v);
    nextv = DB_PTR(&(a->candidates))[NEXT];
    if ((nextv == LSDBNULL) || (DB_DIST(nextv) > DB_DIST(v))) {
	ADD_DBQ(&(a->candidates), v);
    } else {				/* install in order */
	for (; DB_PTR(nextv)[NEXT] != LSDBNULL &&
	     DB_DIST(DB_PTR(nextv)[NEXT]) < DB_DIST(v);
	     nextv = DB_PTR(nextv)[NEXT]) ;
	ADD_DBQ(nextv, v);
    }
}



/*
 * Resolve virtual next hops
 */
int
resolve_virtual(v, parent)
struct LSDB *v, *parent;
{
    int hash;
    struct LSDB *db;
    struct AREA *transarea = &ospf.area[DB_TRANS_AREA_NDX(v)];
    RTR_ROUTE *rr;
    u_long32 newmetric = SUMLSInfinity;

#ifdef DBG
    sprintf(_ospf_prt_buf, "In resolve_virtual: type %d ID %s",
	    LS_TYPE(v),
	    lntoa(LS_ID(v)));
    DBG_LOG(_ospf_prt_buf);
#endif
    if (LS_TYPE(v) == LS_NET || LS_TYPE(v) == LS_STUB) {
	hash = XHASH(DB_NETNUM(v), 0);
	/*
         * Zip through sum nets for transarea
         */
	db = &(transarea->htbl[LS_SUM_NET][hash]);
	{
	    for (db = DB_NEXT(db); db != LSDBNULL; db = DB_NEXT(db)) {
		/* or mania */
		if ((NO_GUTS(db)) ||
		    (BIG_METRIC(db) == SUMLSInfinity) ||
		    (DB_FREEME(db)) ||
		    (LS_AGE(db) >= MaxAge) ||
		    (ADV_RTR(db) == MY_ID) ||
		    (DB_NETNUM(v) != DB_NETNUM(db))) {
#ifdef DBG
		    sprintf(_ospf_prt_buf, "RV Cont1 %d %d %d %d %d %d",
			    (NO_GUTS(db)),
			    (BIG_METRIC(db) == SUMLSInfinity),
			    (DB_FREEME(db)),
			    (LS_AGE(db) >= MaxAge),
			    (ADV_RTR(db) == MY_ID),
			    (DB_NETNUM(v) != DB_NETNUM(db)));
		    DBG_LOG(_ospf_prt_buf);
#endif
		    continue;
		}
		if ((rr = rtr_findroute( transarea,
					 ADV_RTR(db),
					 DTYPE_ABR,
					 PTYPE_INTRA)) == RTR_ROUTENULL) 
		{
		    DBG_LOG("RV Continue2");
		    continue;
		}
		if ((RRT_COST(rr) + BIG_METRIC(db)) < newmetric) {
		    DB_DIST(v) = (newmetric = RRT_COST(rr) + BIG_METRIC(db));
	    	    /* MODIFIED 1/10 */
		    DB_NH_NDX(v,0) = RRT_NH_NDX(rr);
		    DB_NH_CNT(v) = 1;
#ifdef DBG
		    sprintf(_ospf_prt_buf, "RV: Setting SUMNET %s nh to %s dist %d",
			    lntoa(DB_NETNUM(v)),
			    lntoa(nh_block[DB_NH_NDX(v,0)].nh_addr),
			    newmetric);
		    DBG_LOG(_ospf_prt_buf);
#endif
		}
	    }
	}
    } else if (LS_TYPE(v) == LS_RTR) {
	hash = XHASH(LS_ID(v), 0);
	/*
         * resolve only if AS Border route
         */
	if ((ntohs(DB_RTR(v)->E_B) & bit_E)) {
	    /*
	     * First check for intra-area route
	     */
	    rr = rtr_findroute( transarea,
				LS_ID(v),
				DTYPE_ASBR,
				PTYPE_INTRA);
	    if (rr) {
		DB_DIST(v) = RRT_COST(rr);
		DB_NH_NDX(v,0) = RRT_NH_NDX(rr);
		DB_NH_CNT(v) = 1;
#ifdef DBG
		sprintf(_ospf_prt_buf, "Intra: RV: Setting ASBR %s nh to %s",
			lntoa(ADV_RTR(v)),
			lntoa(nh_block[DB_NH_NDX(v,0)].nh_addr));
		DBG_LOG(_ospf_prt_buf);
#endif
		return (TRUE);
	    }
	    /*
	     * Zip through sum ASBs for transarea
	     */
	    db = &(transarea->htbl[LS_SUM_ASB][hash]);
	    {
		for (db = DB_NEXT(db); db != LSDBNULL; db = DB_NEXT(db)) 
		{
		    /* or mania */
		    if ((NO_GUTS(db)) ||
			(BIG_METRIC(db) == SUMLSInfinity) ||
			(DB_FREEME(db)) ||
			(LS_AGE(db) >= MaxAge) ||
			(ADV_RTR(db) == MY_ID) ||
			(LS_ID(db) != LS_ID(v))) {
#ifdef DBG
			sprintf(_ospf_prt_buf, "RV: Cont3 %d %d %d %d %d %d",
				(NO_GUTS(db)),
				(BIG_METRIC(db) == SUMLSInfinity),
				(DB_FREEME(db)),
				(LS_AGE(db) >= MaxAge),
				(ADV_RTR(db) == MY_ID),
				(LS_ID(v) != LS_ID(db)));
			DBG_LOG(_ospf_prt_buf);
#endif
			continue;
		    }
		    if ((rr = rtr_findroute( transarea,
					     ADV_RTR(db),
					     DTYPE_ABR,
					     PTYPE_INTRA)) == RTR_ROUTENULL) 
		    {
			DBG_LOG("RV Continue33");
			continue;
		    }
		    DBG_LOG("NV: Past continues");
		    if ((RRT_COST(rr) + BIG_METRIC(db)) < newmetric) {
			DB_DIST(v) =
			    (newmetric = RRT_COST(rr) + BIG_METRIC(db));
			DB_NH_NDX(v,0) = RRT_NH_NDX(rr);
			DB_NH_CNT(v) = 1;
#ifdef DBG
			sprintf(_ospf_prt_buf, "RV: Setting ASBR %s nh to %s",
				lntoa(ADV_RTR(v)),
				lntoa(nh_block[DB_NH_NDX(v,0)].nh_addr));
			DBG_LOG(_ospf_prt_buf);
#endif
		    }
		}
	    }
	} else {
	    /*
	     * Non-asb router link
	     */
	    DB_VIRTUAL(v) = TRUE;
	    DB_TRANS_AREA_NDX(v) = transarea->area_ndx;
	    nh_list_add(v, parent);
#ifdef DBG
	    sprintf(_ospf_prt_buf, "AB Router2 here resolve virtual %d %s",
		    DB_NH_NDX(v,0),
		    lntoa(nh_block[DB_NH_NDX(v,0)].nh_addr));
	    DBG_LOG(_ospf_prt_buf);
#endif
	}
    }
    if (DB_NH_NDX(v,0))
	return (TRUE);
    return (FALSE);
}

/*
 *	Add parent to vertex
 *	- used by all entries except for ase() who rolls its own
 */
int
addpar(v, parent, newdist, a, nh, vnh_ndx, transarea)
struct LSDB *v, *parent;
int newdist;
struct AREA *a;
u_long32 nh;			/* if attached to this rtr, nbrs IP address */
int	vnh_ndx;		/* Virtual nexthop index */
struct AREA *transarea;		/* for resolving virtual links */
{
    int ret = TRUE;

    if (v == DB_PTR(&(a->spf))[NEXT])
	return (ret);

#ifdef DBG
    sprintf(_ospf_prt_buf, "Addpar v: type %d id %s rtr %s par: type %d id %s rtr %s",
	    LS_TYPE(v),
	    lntoa(LS_ID(v)),
	    lntoa(ADV_RTR(v)),
	    LS_TYPE(parent),
	    lntoa(LS_ID(parent)),
	    lntoa(ADV_RTR(parent)));
    DBG_LOG(_ospf_prt_buf);
#endif

    /*
     * If there are no parents or this is an Intra area route
     * place on candidate list
     */
    if ((!(DB_NH_CNT(v))) && (LS_TYPE(v) < LS_SUM_NET)) {
	/*
	 * put it in order on the candidate list
	 */
	if (LS_TYPE(v) != LS_STUB)
	    clenq(a, v);
	DB_WHERE(v) = ON_CLIST;
    }
    DB_DIST(v) = newdist;

    /*
     * set rtr if addr for virtual link dest ip addr
     */
    if (transarea) {
	/*
	 * virtual link
	 */
	DB_NH_NDX(v,0) = vnh_ndx;
	DB_NH_CNT(v) = 1;
	DB_VIRTUAL(v) = TRUE;
	DB_TRANS_AREA_NDX(v) = transarea->area_ndx;
#ifdef DBG
	sprintf(_ospf_prt_buf, "AB Router here resolve virtual %d %s",
		vnh_ndx,
		lntoa(nh_block[DB_NH_NDX(v,0)].nh_addr));
	DBG_LOG(_ospf_prt_buf);
#endif
    } else if ((DB_VIRTUAL(parent) == TRUE) && (LS_TYPE(v) < LS_SUM_NET)) {
	/*
  	 * Flag for children of this virtual vertex
	 */
	DB_VIRTUAL(v) = TRUE;
	DB_TRANS_AREA_NDX(v) = DB_TRANS_AREA_NDX(parent);
	/*
	 * If transit area hasn't come around yet
	 * remove from candidate list
	 */
	if ((!resolve_virtual(v, parent)) && (LS_TYPE(v) != LS_STUB)) {
	    DBG_LOG("Resolve virtual failed");
	    ret = FALSE;
	    DEL_DBQ(v);
	}
    } else if (ADV_RTR(parent) == MY_ID) {
	/*
	 * if adjacent to this rtr, first hop is direct
	 */
	DBG_LOG("Here1 in addpar");
	DB_NH_NDX(v,0) = find_nh_entry(v, nh);
	DB_NH_CNT(v) = 1;
	DB_DIRECT(v) = TRUE;
    } else if (DB_DIRECT(parent) && LS_TYPE(parent) == LS_NET) {
	/*
	 * if this rtr is DR (parent) - is also direct
	 */
	/* MODIFIED 4/9/92 */
        DB_NH_NDX(v,0) = (ADV_RTR(v) == MY_ID) ?
	    find_nh_entry(v, nh) :
            add_nh_entry(nh_block[DB_NH_NDX(parent,0)].ifspfndx,nh,NH_NBR,0);

	DB_NH_CNT(v) = 1;
	DBG_LOG("Here2 in addpar");
    } else {
	/*
	 * bind to parent's next hop interface addr
	 */
	DBG_LOG("Here4 in addpar");
	nh_list_add(v, parent);
    }
    if (DB_NH_NDX(v,0)) {
#ifdef DBG
	sprintf(_ospf_prt_buf,"NH address = %s",
		lntoa(nh_block[DB_NH_NDX(v,0)].nh_addr));
	DBG_LOG(_ospf_prt_buf);
#endif
    }
    return (ret);
}


/*
 *	Get next candidate (closest to the root)
 *	  and install it on the spftree
 */
void
getnextcandidate(a, v)
struct AREA *a;
struct LSDB **v;
{

    if (((*v) = DB_PTR(&(a->candidates))[NEXT]) == LSDBNULL)
	return;
    DEL_DBQ(*v);
}

/*
 *  	Check rtr vertex to see if there is a link back to id
 *		Add vertex's interface address to vertex
 */
int
rtr_backlink(nextv, v, type, if_ip_addr)
struct LSDB *nextv, *v;
int type;
u_long32 *if_ip_addr;
{
    int i;
    int cnt = ntohs(DB_RTR(nextv)->lnk_cnt);
    struct RTR_LA_PIECES *lnk;

    if (cnt == 0) {
	*if_ip_addr = 0;
	return (FALSE);
    }
    for (i = 0, lnk = &(DB_RTR(nextv)->link);
	 i < cnt;
	 i++, lnk = (struct RTR_LA_PIECES *) ((long) lnk +
					       RTR_LA_PIECES_SIZE +
			    ((lnk->metric_cnt) * RTR_LA_METRIC_SIZE))) {
	if (lnk->lnk_id == LS_ID(v) && lnk->con_type == type) {
	    /* Un numbered ptop link? */
	    *if_ip_addr = (lnk->lnk_data) ? lnk->lnk_data : ADV_RTR(nextv);
	    return (TRUE);
	}
    }
    *if_ip_addr = 0;
    return (FALSE);
}

/*
 *  	Check net vertex to see if there is a link back to id
 */
int
net_backlink(id, db)
u_long32 id;
struct LSDB *db;
{
    int 	i;
    int 	cnt = (ntohs(LS_LEN(db)) - NET_LA_HDR_SIZE) / 4;
    struct 	NET_LA_PIECES *att_rtr;

    for (i = 0, att_rtr = &(DB_NET(db)->att_rtr); i < cnt; i++, att_rtr++) {
	if (att_rtr->lnk_id == id)
	    return (TRUE);
    }

    return (FALSE);
}


/*
 * Update intra area routing table updates
 */
int
rtr_update(area)
struct AREA *area;
{
    RTR_ROUTE *r, *next;

    area->asbr_cnt = 0;
    area->abr_cnt = 0;
    /*
     * Update as border rtrs
     */
    for (r = area->asbrtab.ptr[NEXT];
	 r != RTR_ROUTENULL;
	 r = next) {
	next = RRT_NEXT(r);
#ifdef DBG
	sprintf(_ospf_prt_buf, "RTR_UPDATE: %s", lntoa(RT_DEST(r)));
	DBG_LOG(_ospf_prt_buf);
#endif
	/*
	 * Add Asb rtr summary info to other areas - prepare to flood
	 */
	if ((IAmBorderRtr) && (RRT_ADVRTR(r) != MY_ID)) {
	    DBG_LOG("calling build asb");
	    if (build_sum_asb(area, r, area)) {
		area->spfsched = INTRASCHED;
		return(FLAG_NO_BUFS);	/* Out of memory */
	    }
	}

	if (RRT_REV(r) != RTAB_REV) {	
    	    /* No longer valid route
	     * If not marked invalid, flag build_sum_asb to remove
	     * for now  unbind from lsdb entry
	     */
	    if (RRT_V(r)) {
		DB_ASB_RTR(RRT_V(r)) = RTR_ROUTENULL;
		freeplist(RRT_V(r));	/* free parent vertex list */
	    }
	    /*
	     * delete from routing table
	     */
	    DEL_Q(r, NUKE, OMEM_ORT);
	} else
	    area->asbr_cnt++;
    }

    /*
     * Update area border rtrs
     * These are entered into the routing tble if this area isn't the
     * backbone for virtual endpoints to exchange routing info
     */
    for (r = area->abrtab.ptr[NEXT];
	 r != RTR_ROUTENULL;
	 r = next) {
	next = RRT_NEXT(r);
	if (RRT_REV(r) != RTAB_REV) {
	    /*
	     * no longer valid route
	     * unbind from lsdb entry
	     */
	    if (RRT_V(r)) {
		DB_AB_RTR(RRT_V(r)) = RTR_ROUTENULL;
		/* free parent vertex list */
		freeplist(RRT_V(r));
	    }
	    DEL_Q(r, NUKE, OMEM_ORT);
	} else {
	    if (area != ospf.area && RRT_ADVRTR(r) != MY_ID)
	    	RRT_CHANGE(r) = E_UNCHANGE;
    	    area->abr_cnt++;
	}
    }
    return(FLAG_NO_PROBLEM);
}

/*
 * get_transarea() - return area if nbr_id of virtual link == nh_addr
 */
struct AREA *
get_transarea(virt_id)
u_long32 virt_id;
{
    int i;

#ifdef DBG
    sprintf(_ospf_prt_buf, "Get_transarea looking for %s", lntoa(virt_id));
    DBG_LOG(_ospf_prt_buf);
#endif
    for (i = 0; i < ospf.vcnt; i++) {
	if (ospf.vl[i].nbr.nbr_id == virt_id) {
	    DBG_LOG("Found virtual link");
	    return (&ospf.area[ospf.vl[i].transarea]);
	}
    }
    return (AREANULL);
}

/*
 *	set_virtual_addr() - called by intra when
 *		1) virtual links are configured,
 * 		2) v is a rtr adv with the ABR bit set
 *		3) area is transit area
 *	set up ifspfndx and virtual nbr's ip address
 */
void
set_virtual_addr(v, area, if_ip_addr)
struct LSDB *v;
struct AREA *area;
u_long32 if_ip_addr;
{
    int j;

#ifdef DBG
    sprintf(_ospf_prt_buf, "Here in set_virtual_addr type %d %s %s",
	    LS_TYPE(v), lntoa(LS_ID(v)), lntoa(ADV_RTR(v)));
    DBG_LOG(_ospf_prt_buf);
#endif
    for (j = 0; j < ospf.vcnt; j++) {
	if ((ADV_RTR(v) == ospf.vl[j].nbr.nbr_id) &&
	    (&ospf.area[ospf.vl[j].transarea] == area)) {
#ifdef DBG
	    sprintf(_ospf_prt_buf, "Setting ipaddr to %s",
		    lntoa(if_ip_addr));
	    DBG_LOG(_ospf_prt_buf);
#endif
	    ospf.vl[j].nbr.nbrip_addr = if_ip_addr;
	    ospf.vl[j].nbr.ifspfndx =
		(ospf.vl[j].ifspfndx =
		 nh_block[DB_NH_NDX(v,0)].ifspfndx);
	    break;
	}
    }
}

/*
 * First handle all intra-area routes
 */
int
intra(a)
struct AREA *a;
{
    int i, newdist, cnt;
    int foundlsa, was_added;
    int nomem = 0;		/* if out of memory will run again in tqlock */
    int lookup;			/* RTR or NET LSA lookup in LSDB */
    time_t sec;
    struct LSDB *v, *nextv;	/* current spfnode */
    struct NET_LA_PIECES *att_rtr;
    struct RTR_LA_PIECES *lnk;
    struct LSDB *stublist = LSDBNULL, *stub;
    struct AREA *transarea;	/* transit area for virtual route */
    u_long32 nh;		/* for discovering next hop address */
    int vnh_ndx;		/* virtual next hop ndx */
    RTR_ROUTE *vr;		/* for virtual route */


    sec = ospf_get_time();	/* get time to check MaxAge */
    if ((v = FindLSA(a, MY_ID, MY_ID, LS_RTR)) == LSDBNULL)
	adios("spf: can't find my_rtr_id in lsdb");

    SPFRUN_LOG("Intra", a->area_id);
    DB_DIST(v) = 0;
    DB_WHERE(v) = ON_RTAB;
    ADD_DBQ(&(a->spf), v);
    for (; v != LSDBNULL; getnextcandidate(a, &v)) {
	/* if no candidates left we are finished */
	if (LS_TYPE(v) != LS_STUB)
	    nomem = addroute(a, v, INTRASCHED, a);

	if (nomem) {
	    a->spfsched = INTRASCHED;
	    return (FLAG_NO_BUFS);
	}
	transarea = AREANULL;
	was_added = 0;

	if ((ADV_AGE(v, sec) >= MaxAge) || DB_FREEME(v))
	    continue;
	/* first handle ls rtr update */
	if (LS_TYPE(v) == LS_RTR) {
	    /*
	     * check all links
	     */
	    cnt = ntohs(DB_RTR(v)->lnk_cnt);
	    for (i = 0, lnk = (struct RTR_LA_PIECES *) & (DB_RTR(v)->link);
		 i < cnt;
		 lnk = (struct RTR_LA_PIECES *) ((long) lnk +
						  RTR_LA_PIECES_SIZE +
		       ((lnk->metric_cnt) * RTR_LA_METRIC_SIZE)), i++) {
		/*
	         * if it is a transit vertex check other side
	         */
		if ((lnk->con_type == RTR_IF_TYPE_RTR) ||
		    (lnk->con_type == RTR_IF_TYPE_TRANS_NET) ||
		    (lnk->con_type == RTR_IF_TYPE_VIRTUAL)) {
		    newdist = ntohs(lnk->tos0_metric) + DB_DIST(v);

		    if ((lnk->con_type == RTR_IF_TYPE_RTR) ||
			(lnk->con_type == RTR_IF_TYPE_VIRTUAL)) {
			if (lnk->tos0_metric == RTRLSInfinity)
			    continue;
			lookup = LS_RTR;
			/*
		         * check for virtual link
		         */
			if ((a == ospf.area) &&
			    (ADV_RTR(v) == MY_ID) &&
			    (lnk->con_type == RTR_IF_TYPE_VIRTUAL)) {
#ifdef DBG
			    sprintf(_ospf_prt_buf, "HERE in VIRTUAL %s",
				    lntoa(lnk->lnk_data));
			    DBG_LOG(_ospf_prt_buf);
#endif
			    transarea = get_transarea(lnk->lnk_id);
			    if (transarea == AREANULL) {
				DBG_LOG("Transit area is NULL");
				continue;
			    }
			    /*
			     * lookup area bdr rtr for virtual link
			     */
			    vr = rtr_findroute(transarea,
					       lnk->lnk_id,
					       DTYPE_ABR,
					       PTYPE_INTRA);
			    if (vr == RTR_ROUTENULL) {
				DBG_LOG("VR is NULL");
				continue;
			    }
			    /*
			     * add new virtual nh_entry
			     */
			    vnh_ndx = add_nh_entry(RRT_IO_NDX(vr),
					      RRT_NH(vr),
					      NH_VIRTUAL,
					      transarea->area_ndx);
			}
		    } else
			lookup = LS_NET;

		    /*
		     * if not in lsdb get next vertex
		     */
		    if ((nextv = (struct LSDB *)
			 FindLSA(a, lnk->lnk_id, lnk->lnk_id, lookup))
				== LSDBNULL) {
			DBG_LOG("Couldn't find link");
			continue;
		    }
#ifdef DBG
		    sprintf(_ospf_prt_buf,
			    "Checking nextv type %d id %s rtr %s",
			    LS_TYPE(nextv),
			    lntoa(LS_ID(nextv)),
			    lntoa(ADV_RTR(nextv)));
		    DBG_LOG(_ospf_prt_buf);
#endif

		    /*
		     * if it is too old, or on spf tree get next vertex
		     */
		    if ((DB_WHERE(nextv) == ON_RTAB) ||
			(ADV_AGE(nextv, sec) >= MaxAge) ||
			(DB_FREEME(nextv))) {
#ifdef DBG
			sprintf(_ospf_prt_buf, "Continue2 %d %d %d",
				(DB_WHERE(nextv) == ON_RTAB),
				(ADV_AGE(nextv, sec) >= MaxAge),
				(DB_FREEME(nextv)));
			DBG_LOG(_ospf_prt_buf);
#endif
			continue;
		    }
		    /*
		     * if no backlink get next vertex
		     */
		    if ((lnk->con_type == RTR_IF_TYPE_RTR) ||
			(lnk->con_type == RTR_IF_TYPE_VIRTUAL)) {
			DBG_LOG("Here4");
			if (!rtr_backlink(nextv,
					  v,
					  lnk->con_type,
					  &nh)) {
			    DBG_LOG("Continue4");
			    continue;
			}
			/*
		         * This rtrs link data holds nbr's ip address
		         */
		    } else if (lnk->con_type == RTR_IF_TYPE_TRANS_NET) {
			if (!net_backlink(LS_ID(v), nextv)) {
			    DBG_LOG("Continue4a");
			    continue;
			}
		        nh = lnk->lnk_data;
		    }
		    /*
		     * if newdist is > than current get next vertex
		     */
		    if (newdist > DB_DIST(nextv)) {
			DBG_LOG("Continue5");
			continue;
		    }
		    /*
		     * add equal cost route
		     */
		    if (newdist == DB_DIST(nextv)) {
			addpar(nextv, v, newdist, a, nh, vnh_ndx, transarea);
			/* Potential virtual neighbor */
			if ((ntohs(DB_RTR(nextv)->E_B) & bit_B) &&
			    (a->is_trans_area) &&
			    (lnk->con_type == RTR_IF_TYPE_RTR))
			    set_virtual_addr(nextv, a, nh);
		    } else if (newdist < DB_DIST(nextv)) {
			freeplist(nextv);
			DB_VIRTUAL(nextv) = FALSE;
			addpar(nextv, v, newdist, a, nh, vnh_ndx, transarea);
			/* Potential virtual neighbor */
			if ((ntohs(DB_RTR(nextv)->E_B) & bit_B) &&
			    (a->is_trans_area) &&
			    (lnk->con_type == RTR_IF_TYPE_RTR))
			    set_virtual_addr(nextv, a, nh);
		    }
		} else if (lnk->con_type == RTR_IF_TYPE_STUB_NET) {
		    /*
		     * stub net - queue to be handled after spf algorithm
		     */
		    DBG_LOG("Here in stub");
		    newdist = ntohs(lnk->tos0_metric) + DB_DIST(v);

		    foundlsa = AddLSA(&stub, a, RTR_ADV_NETNUM(lnk),
				      ADV_RTR(v), 0, LS_STUB);
		    if (stub == LSDBNULL) {
			a->spfsched = INTRASCHED;
			return (FLAG_NO_BUFS);
		    }

		    if (!foundlsa) {
			STUB_HDR_ALLOC(DB_NET(stub), NET_LA_HDR_SIZE);
			if (!DB_NET(stub)) {
			    a->spfsched = INTRASCHED;
			    a->db_cnts[LS_STUB]--;
			    db_free(stub);
			    return(FLAG_NO_BUFS);
			}
			LS_ID(stub) = lnk->lnk_id;
			ADV_RTR(stub) = ADV_RTR(v);
			DB_MASK(stub) = lnk->lnk_data;
			LS_LEN(stub) = htons(NET_LA_HDR_SIZE);
			DB_TIME(stub) = DB_TIME(v);
			/* add ls checksum */
			fletch(DB_NET(stub), NET_LA_HDR_SIZE);
			was_added =
			    addpar(stub, 
				   v, 
				   newdist, 
				   a, 
				   lnk->lnk_id,
				   vnh_ndx,
				   transarea);
		    } else {
			DB_TIME(stub) = DB_TIME(v);
			if (newdist == DB_DIST(stub))
			    was_added = addpar(stub,
					       v,
					       newdist,
					       a,
					       lnk->lnk_id,
					       vnh_ndx,
					       transarea);
			if (newdist < DB_DIST(stub)) {
			    freeplist(stub);
			    was_added = addpar(stub,
					       v,
					       newdist,
					       a,
					       lnk->lnk_id,
					       vnh_ndx,
					       transarea);
			}
		    }
		    if (was_added) {
			/* Remove just in case... */
			REM_DBQ(stublist, stub);
			EN_DBQ(stublist, stub);
		    } else
			DBG_LOG("was added is FALSE");
		    continue;
		}
	    }				/* end of router links loops */
	} else if (LS_TYPE(v) == LS_NET) {
	    /* now zip through the net links */
	    cnt = ntohs(LS_LEN(v)) - NET_LA_HDR_SIZE;
	    for (att_rtr = &(DB_NET(v)->att_rtr), i = 0;
		 i < cnt;
		 att_rtr++, i += 4) {
		/*
	         * check other side
	         */
		if ((nextv = FindLSA(a, att_rtr->lnk_id, att_rtr->lnk_id,
				     LS_RTR)) == LSDBNULL) {
		    continue;
		}
		/*
	         * if it is on spftree, too old or no back link,
	         *	go to next vertex
	         */
		if ((DB_WHERE(nextv) == ON_RTAB) ||
		    (ADV_AGE(nextv, sec) >= MaxAge) ||
		    (DB_FREEME(nextv)) ||
		 (!rtr_backlink(nextv, v, RTR_IF_TYPE_TRANS_NET, &nh))) {
		    continue;
		}
		/*
		 * 0 cost on same net
		 */
		if (DB_DIST(v) > DB_DIST(nextv)) {
		    continue;
		} else if (DB_DIST(v) == DB_DIST(nextv)) {
		    addpar(nextv,
			   v,
			   DB_DIST(v),
			   a,
			   nh,
			   vnh_ndx,
			   0);
		    /*
		     * Potential virtual neighbor
		     */
		    if ((ntohs(DB_RTR(nextv)->E_B) & bit_B) &&
			(a->is_trans_area))
			set_virtual_addr(nextv, a, nh);
		} else if (DB_DIST(v) < DB_DIST(nextv)) {
		    freeplist(nextv);
		    if (DB_WHERE(nextv) == ON_CLIST)
			DEL_DBQ(nextv);
		    addpar(nextv,
			   v,
			   DB_DIST(v),
			   a,
			   nh,
			   vnh_ndx,
			   0);
		    /* Potential virtual neighbor */
		    if ((ntohs(DB_RTR(nextv)->E_B) & bit_B) &&
			(a->is_trans_area))
			set_virtual_addr(nextv, a, nh);
		}
	    }
	}
    }

    /* 
     * now do stub nets; at this point shortest intra routes are known 
     */
    for (stub = stublist; stub != LSDBNULL;) 
    {
	stublist = DB_PTR(stub)[NEXT];
	/*
	 * remove from stublist
         */
	DB_PTR(stub)[LAST] = DB_PTR(stub)[NEXT] = LSDBNULL;
#ifdef DBG
	sprintf(_ospf_prt_buf, "Doing STUB net %s", lntoa(LS_ID(stub)));
	DBG_LOG(_ospf_prt_buf);
#endif
	if (addroute(a, stub, INTRASCHED, a)) {
		a->spfsched = INTRASCHED;
		return (FLAG_NO_BUFS);
		/* XXX freeq? */
	}

	stub = stublist;
    }
    return (FLAG_NO_PROBLEM);
}

/*
 * Check virtual links to see if they have come up
 * - if we have an intra area route to the virtual nbr, bring it up
 */
void
virtual_check(area)
struct AREA *area;
{
    int i, match = FALSE;
    RTR_ROUTE *rr;

    for (i = 0; i < ospf.vcnt; i++) {
	DBG_LOG("Virtual check Here2");
	if (&ospf.area[ospf.vl[i].transarea] == area) {
	    /* if we have route, bring link up -
	     * we will wait for hello protocol to discover that
	     * link is down or that other parameters have changed
	     * so virtual links works like everyone else
	     */
	    if (ospf.vl[i].state == IDOWN) {
		match++;
		DBG_LOG("Virtual check Here4");
		if ((rr = rtr_findroute( area,
					 ospf.vl[i].nbr.nbr_id,
					 DTYPE_ABR,
					 PTYPE_INTRA)) == RTR_ROUTENULL) 
	        {
		    DBG_LOG("Virtual check Here5");
		    continue;
		}
#ifdef DBG
		sprintf(_ospf_prt_buf, "Virtual check Here6 ndx = %d",
			RRT_IO_NDX(rr));
		DBG_LOG(_ospf_prt_buf);
#endif
		ospf.vl[i].cost = RRT_COST(rr);
		(*(if_trans[INTF_UP][IDOWN])) (&(ospf.vl[i]));
	    }
	}
    }

    /*
     * have to schedule backbone to rerun if there is a virtual link
     * if there was a match, building the rtr lsa will rerun the dijkstra
     */
    if ((!match) && (area->virtual_up))
	ospf.area->spfsched |= SCHED_BIT(LS_RTR);
}

/*
 * Run Dijkstra on this area
 * - If we run out of memory along the way tq_lock will rerun
 */
void
spf(area)
struct AREA *area;
{

    /* MODIFIED 12/17 added sum_area */
    struct AREA *sum_area = (IAmBorderRtr) ? ospf.area : area;

    area->spfcnt += 1;
    RTAB_REV++;

    /*
     * run spf on this area
     */
    spfinit(area);			/* clear spf tree */
    DB_PTR(&(area->candidates))[NEXT] =
	DB_PTR(&(area->spf))[NEXT] = LSDBNULL;

    if (intra(area))
	return;				/* Out of memory */
    /*
     * update asbr and abr routing tables for this area
     */
    if (rtr_update(area))
	return;				/* Ouf of memory */

    /*
     * Run sum on backbone if this rtr is area border router
     * else run on first (and only) area
     */
    if (netsum(sum_area, ALLSCHED, area, 0))
	return;			/* Out of memory */
    if (asbrsum(sum_area, ALLSCHED, area, 0))
    	return;			/* Out of memory */

    /*
     * Run ASE on global exteral as LSAs
     */
    if (ase(area, ALLSCHED, 0))
	return;				/* Out o'memory */

    /*
     * Update network routing table
     */
    if (ntab_update(area, ALLSCHED))
	return;				/* Out o'memory */

    /*
     * if border rtr, intra routes may have changed
     * - will build sum net links that have changed
     * - will inject them into other areas
     */
    if (IAmBorderRtr) {
	if (build_sum_net(area))
	    return;			/* Out o'memory */
    }

    /*
     * cleanup no longer valid stub network lsdb entries
     */
    stub_cleanup(area);

    /*
     * check virtual links - bring up adjacencies if we have intra route
     */
    if (area->is_trans_area)
	virtual_check(area);
    area->spfsched = 0;			/* a done deal */
}


/*
 * A call to run the correct level of the spf algorithm
 * - called by Rx routines and timerq routines
 * - All dijkstra runs come through this routine so if a routing table open
 *   and close is necessary, it goes in here (look out for the returns)
 */
void
run_spf(area, partial)
struct AREA *area;
int partial;
{
    int bad_run = FALSE;
    int from = 0;
    /* MODIFIED 12/17 added sum_area */
    struct AREA *a, *sum_area = (IAmBorderRtr) ? ospf.area : area;

    /*
     *  Check for a spf sched event having been run
     *  - if out of memory during spf process may have scheduled
     */
    if (area->spfsched & (RTRSCHED | NETSCHED)) {
	area->spfsched = 0;
	spf(area);
    } else {
	/*
         *	Only will run sum if area border rtr and area is backbone
         *	or not area border rtr
         */
	if (area->spfsched & SUMSCHED) {
	    /* MODIFIED 12/17 added sum_area */
	    /*
	     * Run either or both
	     */
	    if (!(area->spfsched & SCHED_BIT(LS_SUM_ASB))) {
		area->spfsched = 0;
		bad_run = netsum(sum_area, SUMNETSCHED, area, partial);
		from = (ASESCHED | SUMNETSCHED);
	    } else if (!(area->spfsched & SCHED_BIT(LS_SUM_NET))) {
		area->spfsched = 0;
		bad_run = asbrsum(sum_area, SUMASBSCHED, area, partial);
		from = (ASESCHED | SUMASBSCHED);
	    } else {
		area->spfsched = 0;
		bad_run = netsum(sum_area, SUMASESCHED, area, partial);
		bad_run |= asbrsum(sum_area, SUMASESCHED, area, partial);
		from = SUMASESCHED;
	    }
	    /* MODIFIED 4/28/92 XXX */
	    /* Turn partial off for ase */
	    partial = 0;
	} else if (area->spfsched & ASESCHED) {
	    from = ASESCHED;
	    area->spfsched = 0;
	}
	if ( ((!bad_run) && from) && (area->ext_option == EXT_OPT_NORMAL) )
	    bad_run = ase(area, from, partial);
	/*
         * Update the network routing table
         */
	if ((!bad_run) && from) {
	    /*
	     * Partial updates have handled updating the routing table
	     */
	    if (!partial)
		ntab_update(area, from);
	    /* MODIFIED 5/22/92 removed build_sum_net */
	}
    }
    /*
     * new sum routes may be on txq
     * or new inter routes may have become available, inject into areas
     */
    for (a = ospf.area; a < &(ospf.area[ospf.acnt]); a++) {
	if (a->txq != LLNULL) {
	    self_orig_area_flood(a, a->txq, LS_SUM_NET);
	    ospf_freeq(&(a->txq), OMEM_LL);
	}
    }

}

#endif				/* PROTO_OSPF */
