/************************************************************************/
/*	Routing Protocol Simulator	Release 1.0	1994/3/17	*/
/*                                              1.21    1997/2/10       */
/*									*/
/*		module 	: network management	  	      		*/
/*		file	: netmng.h		       			*/
/*									*/
/*   Copyright (c) 1994-1997 by Systems Development Laboratory Hitachi,	*/
/*   Ltd. All rights reserved.						*/
/*----------------------------------------------------------------------*/
/*	UPDATE HISTORY							*/
/*									*/
/************************************************************************/

#define	CNCT_IFUP		1
#define CNCT_IFDOWN		2

#define MAX_HOSTID		254

#define ITYPE_AS		1
#define	ITYPE_AREA		2
#define ITYPE_NETWORK		3
#define ITYPE_ROUTER		4
#define ITYPE_INTER_AS		5

#define LIST_HEAD		-1

#define IF_TYPE_DR		1
#define IF_TYPE_BDR		2

struct INDEX {
    struct INDEX *next;
    u_short src_type;
    byte *src;
    u_short dst_type;
    byte *dst;
};

struct DOMAIN {
    int type;
    byte *prt;
};

struct RT_TBL {
    struct RT_TBL *next;
    u_long id;
    u_short cnct_num;
    struct RT_INTF *ilist;
    u_short domain_num;
    struct INDEX *domain;
};

struct RT_INTF {
    struct RT_INTF *next;
    struct NET_TBL *net;
    u_long ifaddr;
    u_short type;
    u_short state;
    u_long cost;
};

struct NET_TBL {
    struct NET_TBL *next;
    u_long id;
    u_long addr;
    u_long mask;
    u_short cnct_num;
    struct INDEX *cnct_rt;
    struct RT_TBL *dr;
    u_short domain_type;
    byte *domain;
};

struct AREA_TBL {
    struct AREA_TBL *next;
    u_long id;
    u_long number;
    u_short net_num;
    struct INDEX *nlist;
    u_short abr_num;
    struct INDEX *abrlist;
    struct AS_TBL *as_idx;
};
    
struct AS_TBL {
    struct AS_TBL *next;
    u_long id;
    u_long number;
    u_short area_num;
    struct AREA_TBL *alist;
    u_short net_num;
    struct INDEX *nlist;
    u_short br_num;
    struct INDEX *brlist;
};

struct LINK_TBL {
    struct LINK_TBL *next;
    int id;
    struct RT_TBL *org;
    struct RT_TBL *cnct;
    struct NET_TBL *link_net;
    u_long cost;
};
    
#define GET_LINK_NET(rt,link,net) \
		{ \
		    for(link=rt->ilist;link;link=link->next) \
		      if(link->net == net) break; \
		}

		      
#define IF_STATE_DOWN(rt,net) \
                { \
		    struct RT_INTF *link; \
		    GET_LINK_NET(rt,link,net); \
		    if(link->state == INTF_DOWN) continue; \
		}
