/* $Id: reg.c,v 1.1 1999/08/23 16:18:39 naamato Exp $ */
/*
 * Copyright(c) 1998 by Hitachi.Ltd All rights reserved.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>

#define IF_NAME_SIZE 8
#define IP_DATA_LEN 64

char usage[] = "Usage: reg [-i interface] [-s src_addr] [-n] [-b] -p ip_src/ip_dst -d dst_addr \n";

char buf[IP_DATA_LEN];

main(argc, argv)
int argc;
char **argv;
{
    char opt;
    extern char *optarg;
    u_long src,dst;
    u_long ip_src,ip_dst;
    char *if_name;
    int num;
    u_long n_bit,b_bit;
    struct ip *ip_pkt;

    src = dst = 0;
    ip_src = ip_dst = 0;
    if_name = NULL;
    num = 0;
    n_bit = b_bit = 0;

    while((opt = getopt(argc,argv,"i:d:s:p:nb")) != -1) {
        switch(opt) {
	case 'i' : if_name = malloc(IF_NAME_SIZE);
	           strcpy(if_name,optarg);
	           break;
	case 'd' : dst = inet_stoa(optarg);
	           break;
	case 'p' : sg_entry_parse(optarg,&ip_src,&ip_dst);
	           break;
	case 's' : src = inet_stoa(optarg);
	           break;
	case 'n' : n_bit = 0x40000000;
	           break;
	case 'b' : b_bit = 0x80000000;
	           break;
	default:   fprintf(stderr,usage);
	           exit(1);
	}
    }

    if(!dst) {
        fprintf(stderr,usage);
	exit(1);
    }

    interface_init();
    pim_init();

    if(!n_bit && ip_src && ip_dst) {
        ip_pkt = (struct ip *)&buf;
	ip_pkt->ip_v = IPVERSION;
	ip_pkt->ip_hl = sizeof(struct ip) >> 2;
	ip_pkt->ip_tos = 0;
	ip_pkt->ip_off = 0;
	ip_pkt->ip_p = IPPROTO_UDP;
	ip_pkt->ip_ttl = 32;
	ip_pkt->ip_src.s_addr = htonl(ip_src);
	ip_pkt->ip_dst.s_addr = htonl(ip_dst);
	ip_pkt->ip_len = htons(IP_DATA_LEN + sizeof(struct ip));
	ip_pkt->ip_sum = 0;
	ip_pkt->ip_sum = in_cksum(ip_pkt,20);
    }
    else {
        ip_pkt = NULL;
    }

    pimsm_register_send(if_name,src,dst,(char *)ip_pkt,n_bit,b_bit);

}

