/* $Id: query.c,v 1.1 1999/08/23 16:18:38 naamato Exp $ */
/*
 * Copyright(c) 1998 by Hitachi.Ltd All rights reserved.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include "igmp_def.h"

#define IF_NAME_SIZE 8

void timer();

char usage[] = "Usage: query [-i interface] [-s src_addr] [-d dst_addr] [-g group_addr] [-t resp_time] [-C count] -n\n";

int time_expire;

main(argc, argv)
int argc;
char **argv;
{
    char opt;
    extern char *optarg;
    u_long src,dst,grp;
    u_int resp_time;
    char *if_name;
    int count;
    int isalert;
#ifndef SOLARIS
    struct sigvec sigv;
#endif

    grp = 0;
    resp_time = DEFAULT_RESPONSE_TIME;
    src = dst = 0;
    if_name = NULL;
    count=1;
    isalert = ROUTER_ALERT_ON;

    while((opt = getopt(argc,argv,"i:g:d:t:s:C:n")) != -1) {
        switch(opt) {
	case 'i' : if_name = malloc(IF_NAME_SIZE);
	           strcpy(if_name,optarg);
	           break;
	case 'g' : grp = inet_stoa(optarg);
	           break;
	case 't' : resp_time = atoi(optarg);
	           break;
	case 's' : src = inet_stoa(optarg);
	           break;
	case 'd' : dst = inet_stoa(optarg);
	           break;
	case 'C' : count = atoi(optarg);
	           break;
	case 'n': isalert = ROUTER_ALERT_OFF;
	           break;
	default:   fprintf(stderr,usage);
	           exit(1);
	}
    }

    interface_init();
    igmp_init();

#ifdef SOLARIS
    sighold(SIGALRM);
    sigset(SIGALRM,timer);
#else
    bzero((char *)&sigv, sizeof(sigv));
    sigv.sv_flags = 0;
    sigv.sv_handler = timer;
    sigv.sv_mask = 0;
    sigvec(SIGALRM, &sigv, (struct sigvec *)NULL);
#endif

    time_expire = 1;
    igmp_query_send(if_name,src,dst,grp,resp_time,isalert);
    for(;count>1;count--) {
	sleep(IGMP_QUERY_INTERVAL);
	igmp_query_send(if_name,src,dst,grp,resp_time,isalert);
    }

}

void timer()
{
    time_expire = 1;
}

