/* $Id: prune.c,v 1.1 1999/08/23 16:18:38 naamato Exp $ */
/*
 * Copyright(c) 1998 by Hitachi.Ltd All rights reserved.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "dvmrp_def.h"

#define IF_NAME_SIZE 8

char usage[] = "Usage: prune [-i interface] [-s src_addr] [-l life_time] -d dst_addr -e <src>/<grp>\n";

main(argc, argv)
int argc;
char **argv;
{
    char opt;
    extern char *optarg;
    u_long src,dst,sg_src,sg_grp;
    char *if_name;
    int life_time;
      
    src = dst = 0;
    sg_src = sg_grp = 0;
    if_name = NULL;
    dvmrp_init();
    life_time = DVMRP_DEFAULT_LIFETIME;

    while((opt = getopt(argc,argv,"i:s:l:d:e:")) != -1) {
        switch(opt) {
	case 'i' : if_name=malloc(IF_NAME_SIZE);
	           strcpy(if_name,optarg);
	           break;
	case 's' : src = inet_stoa(optarg);
	           break;
	case 'l' : life_time = atoi(optarg);
	           break;
	case 'd' : dst = inet_stoa(optarg);
	           break;
	case 'e' : sg_entry_parse(optarg,&sg_src,&sg_grp);
		   break;
	default:   fprintf(stderr,usage);
	           break;
	}
    }

    if(!sg_src || !sg_grp) {
        fprintf(stderr,usage);
	exit(1);
    }
    
    interface_init();
    dvmrp_prune_send(if_name,src,dst,0,sg_src,sg_grp,life_time);
}
