/* $Id: probe.c,v 1.1 1999/08/23 16:18:38 naamato Exp $ */
/*
 * Copyright(c) 1998 by Hitachi.Ltd All rights reserved.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <sys/types.h>
#include "dvmrp_def.h"

#define IF_NAME_SIZE 8

int parse_nbr_list();
int atoh();
void timer();

char usage[] = "Usage: probe [-i interface] [-s src_addr] [-d dst_addr] [-c capability] [-g gen_id] [-C count] [-n nbr1 nbr2 ...]\n";

int time_expire;
char *if_name;

main(argc, argv)
int argc;
char **argv;
{
    char opt;
    extern char *optarg;
    u_long src,dst;

    char flags;
    u_long gen_id;
    int count;
#ifndef SOLARIS
    struct sigvec sigv;
#endif

    src = dst = 0;
    if_name = NULL;
    flags = 0;
    gen_id = 0;
    count = 1;

    interface_init();
    dvmrp_init();

    argv++; argc--;
    while(argc-- > 0) {
        opt = *(*argv+1);
	argv++; argc--;
        switch(opt) {
	case 'i' : if_name = malloc(IF_NAME_SIZE);
	           strcpy(if_name,*argv);
	           break;
	case 'n' : argc -= parse_nbr_list(argc,argv);
	           break;
	case 'c' : flags = atoh(*argv);
	           break;
	case 's' : src = inet_stoa(*argv);
	           break;
	case 'd' : dst = inet_stoa(*argv);
                   break;
	case 'g' : gen_id = atoi(*argv);
	           break;
	case 'C' : count = atoi(*argv);
	           break;
	default:   fprintf(stderr,usage);
	           break;
	}
	argv++;
    }
    
#ifdef SOLARIS
    sighold(SIGALRM);
    sigset(SIGALRM,timer);
#else
    bzero((char *)&sigv, sizeof(sigv));
    sigv.sv_flags = 0;
    sigv.sv_handler = timer;
    sigv.sv_mask = 0;
    sigvec(SIGALRM, &sigv, (struct sigvec *)NULL);
#endif

    time_expire = 1;
    dvmrp_probe_send2(if_name,src,dst,flags,gen_id,0,NULL);
    for(;count>1;count--) {
	sleep(DVMRP_PROBE_INTERVAL);
	dvmrp_probe_send2(if_name,src,dst,flags,gen_id,0,NULL);
    }

}

int parse_nbr_list(argc,argv)
int argc;
char **argv;
{
    u_long nbr;
    char buf[16];
    int len;

    len = 0;
    while(argc-- >= 0) {
	nbr = inet_stoa(*argv);
	add_nbr_list2(if_name,nbr);
	argv++;
	len++;
    }

    return len;
}

int atoh(num)
char *num;
{
    char *buf, c;
    int hex;

    buf = num;
    hex = 0;
    while(*buf) {
	hex <<= 4;
        if(*buf >= '0' && *buf <= '9') hex |= *buf - '0';
	else if (*buf >= 'a' && *buf <= 'f') hex |= 10 + (*buf-'a');
	buf++;
    }

    return hex;
}

void timer()
{
    time_expire = 1;
}
