/* $Id: join.c,v 1.1 1999/08/23 16:18:33 naamato Exp $ */
/*
 * Copyright(c) 1998 by Hitachi.Ltd All rights reserved.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include "igmp_def.h"

#define IF_NAME_SIZE 8

char usage[] = "Usage: join [-i interface] [-s src_addr] [-d dst_addr] [-v 1|2] [-n] -g group_addr\n";

main(argc, argv)
int argc;
char **argv;
{
    char opt;
    extern char *optarg;
    u_long src,dst,grp;
    char *if_name;
    int ver;
    int isalert;

    grp = 0;
    dst = src = 0;
    ver = IGMP_VERSION_2;
    if_name=NULL;
    isalert=ROUTER_ALERT_ON;

    while((opt = getopt(argc,argv,"i:g:s:d:v:n")) != -1) {
        switch(opt) {
	case 'i' : if_name = malloc(IF_NAME_SIZE);
	           strcpy(if_name,optarg);
	           break;
	case 's' : src = inet_stoa(optarg);
	           break;
	case 'd' : dst = inet_stoa(optarg);
	           break;
	case 'g' : grp = inet_stoa(optarg);
	           break;
        case 'v' : ver = atoi(optarg);
  	           break;
	case 'n':  isalert = ROUTER_ALERT_OFF;
	           break;
	default:   fprintf(stderr,usage);
	           exit(1);
	}
    }

    if(!grp) {
        fprintf(stderr,usage);
	exit(1);
    }

    interface_init();
    igmp_init();
    igmp_report_send(if_name,src,dst,grp,ver,isalert);

}

