/* $Id: dvmrp_def.h,v 1.1 1999/08/23 16:18:30 naamato Exp $ */
/*
 * Copyright(c) 1998 by Hitachi.Ltd All rights reserved.
 *
 */

#define DVMRP_CAP_LEAF          0x01
#define DVMRP_CAP_PRUNE         0x02
#define DVMRP_CAP_GENID         0x04
#define DVMRP_CAP_MTRACE        0x08
#define DVMRP_CAP_SNMP          0x10
#define DVMRP_CAP_CAPABILITIES  0x0f

#define DVMRP_VERSION_MAJOR     3       /* Gated DVMRP release */
#define DVMRP_VERSION_MINOR     0xff    /* Conforms to latest spec. */
#define DVMRP_DEFAULT_VERSION   DVMRP_VERSION_MINOR << 8 | DVMRP_VERSION_MAJOR

#define DVMRP_VERSION(major,minor)   ((minor << 8) | major)

#define DVMRP_PROBE             1       /* for finding neighbors             */
#define DVMRP_REPORT            2       /* for reporting some or all routes  */
#define DVMRP_ASK_NEIGHBORS     3       /* sent by mapper, asking for a list */
                                        /* of this router's neighbors. */
#define DVMRP_NEIGHBORS         4       /* response to such a request */
#define DVMRP_ASK_NEIGHBORS2    5       /* as above, want new format reply */
#define DVMRP_NEIGHBORS2        6
#define DVMRP_PRUNE             7       /* prune message */
#define DVMRP_GRAFT             8       /* graft message */
#define DVMRP_GRAFT_ACK         9       /* graft acknowledgement */
#define DVMRP_MAX_TYPE          10      /* all dvmrp messages below this */

#define DVMRP_PROBE_INTERVAL  10
#define DVMRP_REPORT_INTERVAL  60
#define DVMRP_DEFAULT_LIFETIME  180
#define DVMRP_NBR_TIMEOUT  35

#define DVMRP_GROUP  0xe0000004

#define DVMRP_INFINITY 32

#define MAX_DVMRP_PACKET_LEN   576
#define MIN_IP_HEADER_LEN      20
#define MAX_IP_HEADER_LEN      60
#define DVMRP_HEADER_LEN       8
#define MAX_DVMRP_DATA_LEN  \
            (MAX_DVMRP_PACKET_LEN - MAX_IP_HEADER_LEN - DVMRP_HEADER_LEN)
