/* $Id: assert.c,v 1.1 1999/08/23 16:18:28 naamato Exp $ */
/*
 * Copyright(c) 1998 by Hitachi.Ltd All rights reserved.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#define IF_NAME_SIZE 8

char usage[] = "Usage: assert [-i interface] [-s src_addr] [-p <preference>] [-m <metric>] [-r] [-d dst_addr]  -g grp/masklen -e src \n";

main(argc, argv)
int argc;
char **argv;
{
    char opt;
    extern char *optarg;
    u_long src,dst;
    u_long en_src,grp,mask;
    char *if_name;
    u_long pref,metric;
    int num;
    int r_bit;

    src = dst = 0;
    en_src = grp = mask = 0;
    pref = metric = 0;
    if_name = NULL;
    r_bit = 0;

    while((opt = getopt(argc,argv,"i:d:s:e:g:p:m:r")) != -1) {
        switch(opt) {
	case 'i' : if_name = malloc(IF_NAME_SIZE);
	           strcpy(if_name,optarg);
	           break;
	case 'd' : dst = inet_stoa(optarg);
	           break;
	case 'e' : en_src = inet_stoa(optarg);
	           break;
	case 'g' : prefix_parse(optarg,&grp,&mask);
	           break;
	case 's' : src = inet_stoa(optarg);
	           break;
	case 'p' : pref = atol(optarg);
	           break;
	case 'm' : metric = atol(optarg);
	           break;
	case 'r' : r_bit = 1;
	           break;
	default:   fprintf(stderr,usage);
	           exit(1);
	}
    }

    if(!en_src || !grp) {
        fprintf(stderr,usage);
	exit(1);
    }

    interface_init();
    pim_init();
    pimsm_assert_send(if_name,src,dst,en_src,grp,mask,pref,metric,r_bit);

}

