/* num2prim.c - integer to presentation element */

#ifndef	lint
static char *rcsid = "$Header: /lusr/src/cvs/isode-snmp/psap/num2prim.c,v 1.1.1.1 1997/01/31 19:06:41 ljb Exp $";
#endif

/* 
 * $Header: /lusr/src/cvs/isode-snmp/psap/num2prim.c,v 1.1.1.1 1997/01/31 19:06:41 ljb Exp $
 *
 *
 * $Log: num2prim.c,v $
 * Revision 1.1.1.1  1997/01/31 19:06:41  ljb
 * Imported ISODE SNMP sources
 *
 * Revision 9.0  1992/06/16  12:25:44  isode
 * Release 8.0
 *
 */

/*
 *				  NOTICE
 *
 *    Acquisition, use, and distribution of this module and related
 *    materials are subject to the restrictions of a license agreement.
 *    Consult the Preface in the User's Manual for the full terms of
 *    this agreement.
 *
 */


/* LINTLIBRARY */

#include <stdio.h>
#include "psap.h"

/*  */

PE	num2prim (i, class, id)
register integer i;
PElementClass	class;
PElementID	id;
{
    register integer mask,
                    sign,
                    n;
    register PElementData dp;
    register PE	    pe;

    if ((pe = pe_alloc (class, PE_FORM_PRIM, id)) == NULLPE)
	return NULLPE;

    sign = i >= 0 ? i : i ^ (-1);
    mask = 0x1ff << (((n = sizeof i) - 1) * 8 - 1);
    while (n > 1 && (sign & mask) == 0)
	mask >>= 8, n--;

    if ((pe -> pe_prim = PEDalloc (n)) == NULLPED) {
	pe_free (pe);
	return NULLPE;
    }

    for (dp = pe -> pe_prim + (pe -> pe_len = n); n-- > 0; i >>= 8)
	*--dp = i & 0xff;

    return pe;
}
