extern char *malloc(), *realloc();

# line 2 "parser.y"
/*
 *  parser.y,v 1.131.2.5 1994/03/18 22:56:17 jch Exp
 */

/* Gated Release 3.5 */
/* Copyright (c) 1990,1991,1992,1993,1994 by Cornell University. All rights */
/* reserved. Refer to Particulars and other Copyright notices at the end of this */
/* file. */

#include "include.h"
@BEGIN:	PROTO_INET
#include "inet.h"
@END:	PROTO_INET
@BEGIN:	PROTO_ISO
#include "iso.h"
@END:	PROTO_ISO
#include "parse.h"
#include "krt.h"
@BEGIN:	PROTO_RIP
#include "rip.h"
@END:	PROTO_RIP
@BEGIN:	PROTO_HELLO
#include "hello.h"
@END:	PROTO_HELLO
@BEGIN:	PROTO_ICMP
#include "icmp.h"
@END:	PROTO_ICMP
@BEGIN:	PROTO_OSPF
#include "ospf.h"
@END:	PROTO_OSPF
@BEGIN:	PROTO_IDPR
#include "idpr.h"
@END:	PROTO_IDPR
@BEGIN:	PROTO_EGP
#include "egp.h"
@END:	PROTO_EGP
@BEGIN:	PROTO_BGP
#include "bgp.h"
@END:	PROTO_BGP
@BEGIN:	PROTO_DVMRP
#include "dvmrp.h"
@END:	PROTO_DVMRP
@BEGIN:	PROTO_ISODE_SNMP
#include "snmp_isode.h"
@END:	PROTO_ISODE_SNMP
@BEGIN:	PROTO_ISIS
#include "isis.h"
#include "isis_test.h"
#include "isis_globals.h"
@END:	PROTO_ISIS
@BEGIN:	PROTO_SLSP
#include "slsp.h"
@END:	PROTO_SLSP
@BEGIN:	PROTO_RDISC
#include "rdisc.h"
@END:	PROTO_RDISC
@BEGIN: PROTO_IDRP
#include "idrp.h"
@END: PROTO_IDRP
#undef	vsprintf

char parse_error[LINE_MAX] = { 0 };
char *parse_filename = 0;

static	proto_t	parse_proto;			/* For correctly tagging ADV lists */
static	proto_t	parse_export_proto;		/* For checking metrics */
static	gw_entry	**parse_gwlist;
@BEGIN:	PROTO_INET
static	gw_entry	*parse_gwp;		/* To fake a list for EGP and BGP */
@END:	PROTO_INET
@BEGIN:	PARSE_PORT
static  char *parse_serv_proto;
@END:	PARSE_PORT
static	int	parse_contig_masks = TRUE;	/* Masks must be contiguous */
@BEGIN:	PROTO_EGP
static	int parse_group_index;
static	egp_neighbor *ngp, egp_group, *gr_ngp;
@END:	PROTO_EGP
@BEGIN:	PROTO_BGP
static	bgpPeer *bnp;
static	bgpPeerGroup *bgp;
static 	struct bgp_conf *bcp;
@END:	PROTO_BGP
@BEGIN:	PROTO_OSPF
static struct AREA *ospf_AREA;
@END:	PROTO_OSPF
@BEGIN:	PROTO_SLSP
static slsp_instance *slsp_parse_instance;
static slsp_gateway *slsp_parse_gateway;
@END:	PROTO_SLSP
@BEGIN:	PROTO_IDRP
static	idrpPeer *idgp = (idrpPeer *) NULL; 
static  idrpPeer idrp_group, *gr_idrp;
struct	iso_prefix *nlri; 
static	idrpRoute *p_idrp;
static	int idrp_parse_group_index;
static	idrpRoute_options 	*p_idrp_opts,*p_idrp_opts_old;	
static	idrpRoute_options 	*p_idrp_ps_atts = (idrpRoute_options *) NULL;	
static  idrp_distinguish_att	*p_qos;
static  qos_operator	*p_qos_op;
static	snpa_list	*p_snpa_list = (snpa_list *) NULL;
static  struct _adv_entry *p_adv;
#define PS_NONE -1
#define PS_OFF 0
#define PS_ON  1
static  int idrp_have_nexthop = FALSE;
static  int idrp_ps_flag = PS_NONE;
static  int junk_int;
static  struct _idrp_canon_rdpath *p_idrp_dist_canon_rdpath = (struct _idrp_canon_rdpath *) NULL;
@END:	PROTO_IDRP
@BEGIN: PROTO_RDPATHS
static	idrp_canon_rdpath	*p_rdi_head,*p_rdi_tail;
static	idrp_canon_rdpath	*p_idrp_excl_rdi_tail, *p_idrp_excl_rdi_head;
static	idrp_canon_rdpath	*p_idrp_incl_rdi_tail, *p_idrp_incl_rdi_head;
static  idrp_canon_rdpath	*p_idrp_incl =  NULL; /* @@@ (idrp_canon_rdpath) NULL,
							*p_idrp_excl = (idrp_canon_rdpath) NULL;*/
struct  _RD_path *p_rdpath, *p_old_rdpath_part, *p_new_rdpath_part;
@END: PROTO_RDPATHS
static if_info parse_ifi;	/* Used for configuring interfaces that do not exist */

u_int parse_state = PS_INITIAL;
proto_t protos_seen = 0;

PROTOTYPE(yyerror,
	  static void,
	  (const char *));

#define	free_string(s)	task_mem_free((task *) 0, (caddr_t) s); s = 0
#define	free_charstr(s)	task_mem_free((task *) 0, (caddr_t) (s)->ptr); (s)->ptr = (char *) 0; (s)->len = (s)->type = 0
#define	free_bytestr(s)	task_mem_free((task *) 0, (caddr_t) (s)->ptr); (s)->ptr = (byte *) 0; (s)->len = (s)->type = 0

#define	PARSE_ERROR	yyerror(parse_error); yynerrs++; YYERROR;

#define	PROTO_SEEN(proto) \
	if (BIT_TEST(protos_seen, RTPROTO_BIT(proto))) { \
	    sprintf(parse_error, "parse_proto_seen: duplicate %s clause", gd_lower(trace_state(rt_proto_bits, proto))); \
	    PARSE_ERROR; \
	} else { \
	    BIT_SET(protos_seen, RTPROTO_BIT(proto)); \
	    parse_proto = proto; \
	} \


# line 147 "parser.y"
typedef union  {
    long	num;
    u_long	u_num;
    bytestr	hex;
    charstr	str;
    flag_t	flag;
    time_t	time;
    utime_t	utime;
    as_t	as;
    proto_t	proto;
    pmet_t	metric;
    pref_t	pref;
    if_addr	*ifap;
    if_addr_entry	*ifae;
    adv_entry	*adv;
    gw_entry	*gwp;
    void_t	vt;
    sockaddr_un	*sockaddr;
    trace_file	*trace_file;
#ifdef	PROTO_INET
    struct in_addr in_addr;
#endif	/* PROTO_INET */
    dest_mask	dm;
    struct {
	pmet_t metric;
	adv_entry *adv;
    } metric_adv ;
    struct {
	proto_t proto;
	adv_entry **import_list;
	adv_entry **export_list;
	gw_entry **gw_list;
    } proto_lists;
    config_entry *config;
    config_list *conflist;
#ifndef	GATED_LEXER
#ifdef	PROTO_OSPF
    ospf_config_router *ospf_router;
#endif	/* PROTO_OSPF */
#ifdef PROTO_RDPATHS
    struct _RD_path *rdp_match;
    struct _idrp_canon_rdpath *p_idrp_canon_rdpath;
#endif
/* TODO SJR--clean this up */
    struct _policy_rdpath *p_policy_rdpath;
    struct _idrp_canon_rdpath *p_idrp_canon_rdpath;
#ifdef	PROTO_ASPATHS
    as_path *aspath;
    asmatch_t *asp_match;
    asp_range asp_range;
    asp_stack asp_stack;
#endif	/* PROTO_ASPATHS */
#endif	/* GATED_LEXER */
} YYSTYPE;
